/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.custom;

import com.google.common.base.Optional;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class CustomRecipes<C> {
    private final String name;
    private final List<C> loadedRecipes = new ArrayList<C>();
    private IRecipeRegistrar<C> recipeRegistrar;
    private final Map<String, Optional<IRecipeEntry<?>>> loadedEntries = new HashMap();
    private final Map<String, RecipeArg<?>> args;
    private final Map<String, RecipeArg<?>> optionalArgs;

    public CustomRecipes(String name, Map<String, RecipeArg<?>> args, Map<String, RecipeArg<?>> optionalArgs) {
        this.name = name;
        this.args = args;
        this.optionalArgs = optionalArgs;
    }

    public final void parse(JsonArray array) {
        this.clear();
        array.forEach(element -> {
            this.parseRecipe((JsonElement)element);
            this.loadedRecipes.add(this.load());
        });
        this.recipeRegistrar = this.createRegistrar();
    }

    private final void parseRecipe(JsonElement element) {
        JsonElement entryJson;
        this.loadedEntries.clear();
        for (Map.Entry<String, RecipeArg<?>> entry : this.args.entrySet()) {
            entryJson = this.getElement(entry.getKey(), element);
            if (entryJson == null) {
                throw new InvalidRecipeException(String.format("Missing entry %s for recipe %s", entry.getKey(), this.getName()));
            }
            this.loadedEntries.put(entry.getKey(), Optional.of(entry.getValue().parse(entryJson)));
        }
        for (Map.Entry<String, RecipeArg<?>> entry : this.optionalArgs.entrySet()) {
            entryJson = this.getElement(entry.getKey(), element);
            if (entryJson == null) continue;
            this.loadedEntries.put(entry.getKey(), Optional.of(entry.getValue().parse(entryJson)));
        }
    }

    private final JsonElement getElement(String entry, JsonElement parent) {
        String[] path = entry.split("/");
        JsonElement element = parent;
        for (String str : path) {
            JsonObject obj;
            if (element.isJsonObject()) {
                obj = element.getAsJsonObject();
                if (!obj.has(str)) {
                    return null;
                }
            } else {
                return null;
            }
            element = obj.get(str);
        }
        return element;
    }

    protected abstract C load();

    protected abstract IRecipeRegistrar<C> createRegistrar();

    protected final IRecipeRegistrar<C> getRegistrar() {
        return this.recipeRegistrar;
    }

    public final void registerRecipes() {
        for (C recipe : this.loadedRecipes) {
            this.getRegistrar().register(recipe);
        }
    }

    public final void unregisterRecipes() {
        for (C recipe : this.loadedRecipes) {
            this.getRegistrar().unregister(recipe);
        }
    }

    public final List<C> getRecipes() {
        return Collections.unmodifiableList(this.loadedRecipes);
    }

    public final void clear() {
        this.loadedRecipes.clear();
    }

    protected final void throwException(String msg) {
        throw new InvalidRecipeException(msg);
    }

    public final <T, F extends RecipeArg<T>> Optional<IRecipeEntry<T>> get(String id, RecipeArg<T> arg) {
        Optional<IRecipeEntry<?>> entry = this.loadedEntries.get(id);
        if (entry != null && entry.isPresent()) {
            return Optional.of((Object)((IRecipeEntry)entry.get()));
        }
        return Optional.absent();
    }

    public final String getName() {
        return this.name;
    }

    protected static abstract class RecipeArg<T> {
        public static final RecipeArg<ItemStack> ITEM_INPUT = new RecipeArg<ItemStack>(){

            @Override
            public IRecipeEntry<ItemStack> parse(JsonElement element) {
                return RecipeArg.parseItemStack(element, true);
            }
        };
        public static final RecipeArg<FluidStack> FLUID_INPUT = new RecipeArg<FluidStack>(){

            @Override
            public IRecipeEntry<FluidStack> parse(JsonElement element) {
                return RecipeArg.parseFluidStack(element, true);
            }
        };
        public static final RecipeArg<ItemStack> ITEM_OUTPUT = new RecipeArg<ItemStack>(){

            @Override
            public IRecipeEntry<ItemStack> parse(JsonElement element) {
                return RecipeArg.parseItemStack(element, false);
            }
        };
        public static final RecipeArg<FluidStack> FLUID_OUTPUT = new RecipeArg<FluidStack>(){

            @Override
            public IRecipeEntry<FluidStack> parse(JsonElement element) {
                return RecipeArg.parseFluidStack(element, false);
            }
        };
        public static final RecipeArg<Entity> ENTITY = new RecipeArg<Entity>(){

            @Override
            public IRecipeEntry<Entity> parse(JsonElement element) {
                JsonObject obj = element.getAsJsonObject();
                String id = obj.get("id").getAsString();
                NBTTagCompound nbt = null;
                nbt = obj.has("nbt") ? (NBTTagCompound)NBT.parse(obj.get("nbt")).create() : new NBTTagCompound();
                nbt.func_74778_a("id", id);
                NBTTagCompound finalNbt = nbt;
                return (world, pos, crafter) -> AnvilChunkLoader.func_186054_a((NBTTagCompound)finalNbt, (World)world, (double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c, (boolean)true);
            }
        };
        public static final RecipeArg<NBTTagCompound> NBT = new RecipeArg<NBTTagCompound>(){

            @Override
            public IRecipeEntry<NBTTagCompound> parse(JsonElement element) {
                try {
                    NBTTagCompound nbt = JsonToNBT.func_180713_a((String)element.getAsString());
                    return (world, pos, crafter) -> nbt;
                }
                catch (NBTException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        public static final RecipeArg<Integer> INT = new RecipeArg<Integer>(){

            @Override
            public IRecipeEntry<Integer> parse(JsonElement element) {
                int i = element.getAsInt();
                return (world, pos, crafter) -> i;
            }
        };
        public static final RecipeArg<Boolean> BOOL = new RecipeArg<Boolean>(){

            @Override
            public IRecipeEntry<Boolean> parse(JsonElement element) {
                boolean b = element.getAsBoolean();
                return (world, pos, crafter) -> b;
            }
        };
        public static final RecipeArg<Double> DOUBLE = new RecipeArg<Double>(){

            @Override
            public IRecipeEntry<Double> parse(JsonElement element) {
                double d = element.getAsDouble();
                return (world, pos, crafter) -> d;
            }
        };
        public static final RecipeArg<String> STRING = new RecipeArg<String>(){

            @Override
            public IRecipeEntry<String> parse(JsonElement element) {
                String s = element.getAsString();
                return (world, pos, crafter) -> s;
            }
        };

        protected RecipeArg() {
        }

        public abstract IRecipeEntry<T> parse(JsonElement var1);

        private static IRecipeEntry<ItemStack> parseItemStack(JsonElement element, boolean input) {
            JsonObject obj = element.getAsJsonObject();
            String id = obj.get("id").getAsString();
            int meta = obj.has("meta") ? obj.get("meta").getAsInt() : (input ? Short.MAX_VALUE : 0);
            NBTTagCompound nbt = null;
            if (obj.has("nbt")) {
                nbt = NBT.parse(obj.get("nbt")).create();
            }
            int size = obj.has("size") ? obj.get("size").getAsInt() : 1;
            ItemStack stack = new ItemStack(Item.func_111206_d((String)id), size, meta);
            stack.func_77982_d(nbt);
            return (world, pos, crafter) -> stack.func_77946_l();
        }

        private static IRecipeEntry<FluidStack> parseFluidStack(JsonElement element, boolean input) {
            JsonObject obj = element.getAsJsonObject();
            String id = obj.get("id").getAsString();
            int meta = obj.has("meta") ? obj.get("meta").getAsInt() : (input ? Short.MAX_VALUE : 0);
            NBTTagCompound nbt = null;
            if (obj.has("nbt")) {
                nbt = NBT.parse(obj.get("nbt")).create();
            }
            int size = obj.has("size") ? obj.get("size").getAsInt() : 1;
            Fluid fluid = FluidRegistry.getFluid((String)id);
            FluidStack stack = new FluidStack(fluid, 1000);
            stack.tag = nbt;
            return (world, pos, crafter) -> stack.copy();
        }
    }

    @FunctionalInterface
    protected static interface IRecipeEntry<T> {
        default public T create() {
            return this.create(null, null, null);
        }

        public T create(@Nullable World var1, @Nullable Vec3d var2, @Nullable EntityPlayer var3);
    }

    public static interface IRecipeRegistrar<C> {
        public boolean register(C var1);

        public boolean unregister(C var1);
    }

    public static class InvalidRecipeException
    extends RuntimeException {
        private static final long serialVersionUID = -6724435505685374630L;

        public InvalidRecipeException(String msg) {
            super(msg);
        }
    }
}

