/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.censer;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.ICenser;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.recipe.censer.CenserRecipeSwampWaterContext;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class CenserRecipeSwampWater
extends AbstractCenserRecipe<CenserRecipeSwampWaterContext> {
    private static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "swamp_water");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean matchesInput(FluidStack stack) {
        return stack.getFluid() == FluidRegistry.SWAMP_WATER;
    }

    @Override
    public boolean matchesSecondaryInput(ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.BARK_AMULET;
    }

    @Override
    public CenserRecipeSwampWaterContext createContext(FluidStack stack) {
        return new CenserRecipeSwampWaterContext();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getEffectColor(CenserRecipeSwampWaterContext context, ICenser censer, ICenserRecipe.EffectColorType type) {
        return -1118482;
    }

    private List<EntityPlayer> getAffectedEntities(World world, BlockPos pos) {
        return world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos).func_72314_b(45.0, 1.0, 45.0).func_72321_a(0.0, 16.0, 0.0));
    }

    @Override
    public int update(CenserRecipeSwampWaterContext context, ICenser censer) {
        ItemStack inputStack = censer.getInputStack();
        if (!inputStack.func_190926_b() && inputStack.func_77973_b() == ItemRegistry.BARK_AMULET) {
            World world = censer.getCenserWorld();
            if (world.func_82737_E() % 100L == 0L) {
                BlockPos pos = censer.getCenserPos();
                List<EntityPlayer> affected = this.getAffectedEntities(world, pos);
                if (!world.field_72995_K) {
                    for (EntityPlayer player : affected) {
                        player.func_70690_d(new PotionEffect(ElixirEffectRegistry.ENLIGHTENED, 200, 0, true, false));
                    }
                }
                context.setConsuming(!affected.isEmpty());
            }
        } else {
            context.setConsuming(false);
        }
        return 0;
    }

    @Override
    public int getConsumptionDuration(CenserRecipeSwampWaterContext context, ICenser censer) {
        return 9;
    }

    @Override
    public int getConsumptionAmount(CenserRecipeSwampWaterContext context, ICenser censer) {
        return context.isConsuming() ? 1 : 0;
    }
}

