/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.animator;

import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.recipes.IAnimatorRecipe;

public class ToolRepairAnimatorRecipe
implements IAnimatorRecipe {
    private Item tool;
    private int minRepairLifeCost;
    private int fullRepairLifeCost;
    private int minRepairFuelCost;
    private int fullRepairFuelCost;

    public ToolRepairAnimatorRecipe(Item tool, int minRepairLifeCost, int fullRepairLifeCost, int minRepairFuelCost, int fullRepairFuelCost) {
        this.tool = tool;
        this.fullRepairFuelCost = fullRepairFuelCost;
        this.fullRepairLifeCost = fullRepairLifeCost;
        this.minRepairLifeCost = minRepairLifeCost;
        this.minRepairFuelCost = minRepairFuelCost;
    }

    public ToolRepairAnimatorRecipe(IAnimatorRepairable repairable) {
        this.tool = (Item)repairable;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77952_i() > 0 && stack.func_77973_b() == this.tool && (!(this.tool instanceof IAnimatorRepairable) || ((IAnimatorRepairable)this.tool).isRepairableByAnimator(stack));
    }

    @Override
    public int getRequiredFuel(ItemStack stack) {
        int minRepairFuelCost = this.minRepairFuelCost;
        int fullRepairFuelCost = this.fullRepairFuelCost;
        if (this.tool instanceof IAnimatorRepairable) {
            minRepairFuelCost = ((IAnimatorRepairable)this.tool).getMinRepairFuelCost(stack);
            fullRepairFuelCost = ((IAnimatorRepairable)this.tool).getFullRepairFuelCost(stack);
        }
        return minRepairFuelCost + MathHelper.func_76123_f((float)((float)(fullRepairFuelCost - minRepairFuelCost) / (float)stack.func_77958_k() * (float)stack.func_77952_i()));
    }

    @Override
    public int getRequiredLife(ItemStack stack) {
        int minRepairLifeCost = this.minRepairLifeCost;
        int fullRepairLifeCost = this.fullRepairLifeCost;
        if (this.tool instanceof IAnimatorRepairable) {
            minRepairLifeCost = ((IAnimatorRepairable)this.tool).getMinRepairLifeCost(stack);
            fullRepairLifeCost = ((IAnimatorRepairable)this.tool).getFullRepairLifeCost(stack);
        }
        return minRepairLifeCost + MathHelper.func_76123_f((float)((float)(fullRepairLifeCost - minRepairLifeCost) / (float)stack.func_77958_k() * (float)stack.func_77952_i()));
    }

    @Override
    public Entity getRenderEntity(ItemStack stack) {
        return null;
    }

    @Override
    public ItemStack getResult(ItemStack stack) {
        ItemStack result = stack.func_77946_l();
        result.func_77964_b(0);
        return result;
    }

    @Override
    public Class<? extends Entity> getSpawnEntityClass(ItemStack stack) {
        return null;
    }

    @Override
    public ItemStack onAnimated(World world, BlockPos pos, ItemStack stack) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean onRetrieved(World world, BlockPos pos, ItemStack stack) {
        return true;
    }

    @Override
    public boolean getCloseOnFinish(ItemStack stack) {
        return false;
    }

    public Item getTool() {
        return this.tool;
    }
}

