/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.serverbound;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thebetweenlands.common.entity.draeton.DraetonPhysicsPart;
import thebetweenlands.common.entity.draeton.EntityDraeton;
import thebetweenlands.common.network.MessageEntity;
import thebetweenlands.common.registries.SoundRegistry;

public class MessageSetDraetonAnchorPos
extends MessageEntity {
    private BlockPos pos;

    public MessageSetDraetonAnchorPos() {
    }

    public MessageSetDraetonAnchorPos(EntityDraeton carriage) {
        this.addEntity(carriage);
        DraetonPhysicsPart part = carriage.getAnchorPhysicsPart();
        this.pos = new BlockPos(part.x, part.y, part.z);
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.func_179255_a(this.pos);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        super.deserialize(buf);
        this.pos = buf.func_179259_c();
    }

    @Override
    public IMessage process(MessageContext ctx) {
        DraetonPhysicsPart part;
        EntityDraeton carriage;
        super.process(ctx);
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Entity entity = this.getEntity(0);
        if (entity instanceof EntityDraeton && (carriage = (EntityDraeton)entity).func_184179_bs() == player && (part = carriage.getAnchorPhysicsPart()) != null) {
            BlockPos newPos;
            float maxDist;
            Vec3d anchorPos = new Vec3d((double)((float)this.pos.func_177958_n() + 0.5f), (double)((float)this.pos.func_177956_o() + 0.5f), (double)((float)this.pos.func_177952_p() + 0.5f));
            Vec3d diff = anchorPos.func_178788_d(carriage.func_174791_d());
            float dist = (float)Math.sqrt(diff.field_72450_a * diff.field_72450_a + diff.field_72448_b * diff.field_72448_b + diff.field_72449_c * diff.field_72449_c);
            if (dist > (maxDist = carriage.getMaxTetherLength(part) + 4.0f)) {
                diff = diff.func_186678_a((double)(1.0f / dist * maxDist));
            }
            if (!(newPos = new BlockPos(carriage.func_174791_d().func_178787_e(diff))).equals((Object)carriage.getAnchorPos())) {
                carriage.field_70170_p.func_184148_a(null, (double)newPos.func_177958_n() + 0.5, (double)newPos.func_177956_o() + 0.5, (double)newPos.func_177952_p() + 0.5, (SoundEvent)SoundRegistry.DRAETON_ANCHOR, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            carriage.setAnchorPos(newPos, true);
        }
        return null;
    }
}

