/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thebetweenlands.common.entity.mobs.EntityAnadia;

public class LootFunctionSetCountFromAnadia
extends LootFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final float sizeStart;
    private final float sizeEnd;
    private final int minCount;
    private final int maxCount;

    public LootFunctionSetCountFromAnadia(LootCondition[] conditionsIn, float sizeStart, float sizeEnd, int minCount, int maxCount) {
        super(conditionsIn);
        this.sizeStart = sizeStart;
        this.sizeEnd = sizeEnd;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        Entity entity = context.func_186493_a();
        if (entity instanceof EntityAnadia) {
            float size = ((EntityAnadia)entity).getFishSize();
            int count = this.minCount + MathHelper.func_76141_d((float)((MathHelper.func_76131_a((float)size, (float)this.sizeStart, (float)this.sizeEnd) - this.sizeStart) / (this.sizeEnd - this.sizeStart) * (float)(this.maxCount - this.minCount)));
            if (count > stack.func_77976_d()) {
                LOGGER.warn("Stack size {} exceeds max. stack size {} of loot item {}", (Object)count, (Object)stack.func_77976_d(), (Object)stack);
            } else {
                stack.func_190920_e(count);
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<LootFunctionSetCountFromAnadia> {
        public Serializer() {
            super(new ResourceLocation("thebetweenlands", "set_count_from_anadia"), LootFunctionSetCountFromAnadia.class);
        }

        public void serialize(JsonObject object, LootFunctionSetCountFromAnadia functionClazz, JsonSerializationContext serializationContext) {
            object.addProperty("size_start", (Number)Float.valueOf(functionClazz.sizeStart));
            object.addProperty("size_end", (Number)Float.valueOf(functionClazz.sizeEnd));
            object.addProperty("min_count", (Number)functionClazz.minCount);
            object.addProperty("max_count", (Number)functionClazz.maxCount);
        }

        public LootFunctionSetCountFromAnadia deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new LootFunctionSetCountFromAnadia(conditionsIn, JsonUtils.func_151217_k((JsonObject)object, (String)"size_start"), JsonUtils.func_151217_k((JsonObject)object, (String)"size_end"), JsonUtils.func_151203_m((JsonObject)object, (String)"min_count"), JsonUtils.func_151203_m((JsonObject)object, (String)"max_count"));
        }
    }
}

