/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.projectiles.EntityFishingSpear;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.TranslationHelper;

public class ItemFishingSpear
extends Item
implements IAnimatorRepairable {
    public final byte type;

    public ItemFishingSpear(byte type) {
        this.field_77777_bU = 1;
        this.type = type;
        if (type == 2) {
            this.func_77656_e(128);
        } else {
            this.func_77656_e(64);
        }
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof ItemFishingSpear) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        this.func_77637_a(BLCreativeTabs.GEARS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        if (this.type == 2 && stack.func_77942_o() && stack.func_77978_p().func_74764_b("animated")) {
            tooltip.add(TranslationHelper.translateToLocal("tooltip.bl.fishing_spear_animated", new Object[0]) + stack.func_77978_p().func_74767_n("animated"));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeldItem) {
        if (!world.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("animated")) {
                stack.func_77978_p().func_74757_a("animated", false);
            }
        }
    }

    public boolean isAnimated(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("animated") && stack.func_77978_p().func_74767_n("animated");
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            float f;
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)i, (!stack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if ((!stack.func_190926_b() || flag) && (double)(f = ItemBow.func_185059_b((int)i) / 2.0f) >= 0.1) {
                if (!worldIn.field_72995_K) {
                    EntityFishingSpear entitySpear = new EntityFishingSpear(worldIn, (EntityLivingBase)entityplayer);
                    entitySpear.shoot((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 1.0f, f * 3.0f, 1.0f);
                    entitySpear.setItemStackDamage(stack.func_77952_i());
                    entitySpear.setType(this.type);
                    entitySpear.setAnimated(this.isAnimated(stack));
                    switch (this.type) {
                        case 0: {
                            entitySpear.setDamage(2.0);
                            break;
                        }
                        case 1: {
                            entitySpear.setDamage(3.0);
                            break;
                        }
                        case 2: {
                            entitySpear.setDamage(4.0);
                        }
                    }
                    worldIn.func_72838_d((Entity)entitySpear);
                }
                worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, (SoundEvent)SoundRegistry.SPEAR_THROW, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        entityplayer.field_71071_by.func_184437_d(stack);
                    }
                }
                entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairFuelCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairFuelCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairLifeCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairLifeCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }
}

