/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IRotSmellCapability;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.EntityFishingTackleBoxSeat;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.item.ITintedItem;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.registries.CapabilityRegistry;

public class ItemMobAnadia
extends ItemMob
implements ITintedItem {
    public <T extends Entity> ItemMobAnadia(int maxStackSize, @Nullable Class<T> defaultMob, @Nullable Consumer<T> defaultMobSetter) {
        super(1, defaultMob, defaultMobSetter);
        this.func_77637_a(BLCreativeTabs.ITEMS);
    }

    public int getDecayTime(ItemStack stack) {
        return 24000;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!attacker.func_130014_f_().field_72995_K && target instanceof EntitySwampHag && !target.func_184218_aH() && attacker instanceof EntityPlayer && attacker.func_130014_f_().func_180495_p(target.func_180425_c().func_177977_b()).func_185904_a().func_76230_c()) {
            EntityFishingTackleBoxSeat entitySeat = new EntityFishingTackleBoxSeat(attacker.func_130014_f_(), true);
            entitySeat.func_70107_b(target.field_70165_t, target.field_70163_u - 0.55, target.field_70161_v);
            attacker.func_130014_f_().func_72838_d((Entity)entitySeat);
            target.func_184205_a((Entity)entitySeat, true);
        }
        return false;
    }

    @Override
    protected EnumActionResult spawnCapturedEntity(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ, Entity entity, boolean isNewEntity) {
        if (entity instanceof EntityAnadia && !((EntityAnadia)entity).getFishColour().isAlive()) {
            return EnumActionResult.PASS;
        }
        return super.spawnCapturedEntity(player, world, pos, hand, facing, hitX, hitY, hitZ, entity, isNewEntity);
    }

    public void setRotten(World world, ItemStack stack, boolean rotten) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10) && stack.func_77978_p().func_74775_l("Entity").func_74771_c("fishColour") != 0) {
            if (rotten) {
                stack.func_77978_p().func_74775_l("Entity").func_74772_a("rottingTime", world.func_82737_E());
            } else {
                stack.func_77978_p().func_74775_l("Entity").func_74772_a("rottingTime", world.func_82737_E() + (long)this.getDecayTime(stack));
            }
        }
    }

    public boolean isRotten(World world, ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10) && stack.func_77978_p().func_74775_l("Entity").func_74771_c("fishColour") != 0 && stack.func_77978_p().func_74775_l("Entity").func_74764_b("rottingTime")) {
            long worldTime;
            long timeFished = stack.func_77978_p().func_74775_l("Entity").func_74763_f("rottingTime");
            return timeFished - (worldTime = world.func_82737_E()) <= 0L;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10) && stack.func_77978_p().func_74775_l("Entity").func_74771_c("fishColour") != 0 && stack.func_77978_p().func_74775_l("Entity").func_74771_c("fishColour") != 1 && stack.func_77978_p().func_74775_l("Entity").func_74764_b("rottingTime") && world.func_82737_E() >= stack.func_77978_p().func_74775_l("Entity").func_74763_f("rottingTime")) {
            stack.func_77978_p().func_74775_l("Entity").func_74774_a("fishColour", (byte)1);
        }
        if (this.isRotten(world, stack) & entity instanceof EntityPlayer && !world.field_72995_K) {
            ItemMobAnadia.addSmell((EntityLivingBase)entity);
        }
    }

    public static void addSmell(EntityLivingBase entity) {
        IRotSmellCapability cap = (IRotSmellCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_ROT_SMELL, null);
        if (cap != null && !cap.isSmellingBad()) {
            cap.setSmellingBad(Math.max(cap.getRemainingSmellyTicks(), 24000));
        }
    }

    @Override
    public void onCapturedByPlayer(EntityPlayer player, EnumHand hand, ItemStack stack, EntityLivingBase entity) {
        if (!player.func_130014_f_().field_72995_K) {
            EntityLivingBase living;
            if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10)) {
                stack.func_77978_p().func_74775_l("Entity").func_74772_a("rottingTime", player.func_130014_f_().func_82737_E() + (long)this.getDecayTime(stack));
            }
            if (entity instanceof EntityLivingBase && (living = entity) instanceof EntityAnadia && ((EntityAnadia)living).func_184207_aI()) {
                ((EntityAnadia)living).func_184226_ay();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Entity entity;
        if (worldIn != null && (entity = this.createCapturedEntity(worldIn, 0.0, 0.0, 0.0, stack, false)) instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (living instanceof EntityAnadia) {
                NBTTagCompound entityNbt = this.getEntityData(stack);
                if (entityNbt != null) {
                    tooltip.add(I18n.func_135052_a((String)living.func_70005_c_(), (Object[])new Object[0]));
                    if (entityNbt.func_74771_c("fishColour") != 0) {
                        if (entityNbt.func_74764_b("rottingTime")) {
                            long rottingTime = entityNbt.func_74763_f("rottingTime");
                            if (rottingTime - worldIn.func_82737_E() > 19200L) {
                                tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.rotting_1", (Object[])new Object[0]));
                            } else if (rottingTime - worldIn.func_82737_E() <= 19200L && rottingTime - worldIn.func_82737_E() > 14400L) {
                                tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.rotting_2", (Object[])new Object[0]));
                            } else if (rottingTime - worldIn.func_82737_E() <= 14400L && rottingTime - worldIn.func_82737_E() > 9600L) {
                                tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.rotting_3", (Object[])new Object[0]));
                            } else if (rottingTime - worldIn.func_82737_E() <= 9600L && rottingTime - worldIn.func_82737_E() > 4800L) {
                                tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.rotting_4", (Object[])new Object[0]));
                            } else if (rottingTime - worldIn.func_82737_E() <= 4800L && rottingTime - worldIn.func_82737_E() > 0L) {
                                tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.rotting_5", (Object[])new Object[0]));
                            } else if (rottingTime - worldIn.func_82737_E() <= 0L) {
                                tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.rotten", (Object[])new Object[0]));
                            }
                        }
                    } else {
                        tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.smoked", (Object[])new Object[0]));
                    }
                    tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.health", (Object[])new Object[]{MathHelper.func_76123_f((float)living.func_110143_aJ()), MathHelper.func_76123_f((float)living.func_110138_aP())}));
                    tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.size", (Object[])new Object[]{Float.valueOf(((EntityAnadia)living).getFishSize())}));
                    tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.speed", (Object[])new Object[]{living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()}));
                    tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.strength", (Object[])new Object[]{Math.floor((double)((EntityAnadia)living).getStrengthMods() + 0.5)}));
                    tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob_anadia.stamina", (Object[])new Object[]{Float.valueOf(((EntityAnadia)living).getStaminaMods())}));
                }
            } else {
                tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob.health", (Object[])new Object[]{MathHelper.func_76123_f((float)(living.func_110143_aJ() / 2.0f)), MathHelper.func_76123_f((float)(living.func_110138_aP() / 2.0f))}));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorMultiplier(ItemStack stack, int tintIndex) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10)) {
            long rottingTime;
            if (stack.func_77978_p().func_74775_l("Entity").func_74771_c("fishColour") == 0) {
                return 0x747479;
            }
            if (stack.func_77978_p().func_74775_l("Entity").func_74764_b("rottingTime") && (rottingTime = stack.func_77978_p().func_74775_l("Entity").func_74763_f("rottingTime")) - Minecraft.func_71410_x().field_71441_e.func_82737_E() <= 0L) {
                return 6271056;
            }
            if (stack.func_77978_p().func_74775_l("Entity").func_74771_c("fishColour") == 3) {
                return 12760027;
            }
            if (stack.func_77978_p().func_74775_l("Entity").func_74771_c("fishColour") == 4) {
                return 0x714147;
            }
            if (stack.func_77978_p().func_74775_l("Entity").func_74771_c("fishColour") == 5) {
                return 4281394;
            }
        }
        return 7436881;
    }
}

