/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.food;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.FoodStats;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.api.capability.IFallDamageReductionCapability;
import thebetweenlands.api.capability.IFoodSicknessCapability;
import thebetweenlands.api.capability.IInfestationIgnoreCapability;
import thebetweenlands.api.capability.IMudWalkerCapability;
import thebetweenlands.common.capability.foodsickness.FoodSickness;
import thebetweenlands.common.entity.mobs.EntityTinySludgeWormHelper;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.item.EnumBLDrinkableBrew;
import thebetweenlands.common.item.food.ItemBLFood;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemDrinkableBrew
extends ItemBLFood
implements ItemRegistry.IMultipleItemModelDefinition {
    public ItemDrinkableBrew() {
        super(0, 0.0f, false);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77848_i();
    }

    public int func_150905_g(ItemStack stack) {
        return EnumBLDrinkableBrew.byMetadata(stack.func_77960_j()).getHealAmount();
    }

    public float func_150906_h(ItemStack stack) {
        return EnumBLDrinkableBrew.byMetadata(stack.func_77960_j()).getSaturationModifier();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return ItemMisc.EnumItemMisc.WEEDWOOD_BOWL.create(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    @Override
    public boolean canGetSickOf(@Nullable EntityPlayer player, ItemStack stack) {
        return false;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        super.func_77849_c(stack, world, player);
        if (EnumBLDrinkableBrew.byMetadata(stack.func_77960_j()).hasBuff()) {
            this.applyBuffToPlayer(stack, world, player);
        }
        int healAmount = this.func_150905_g(stack);
        float saturation = this.func_150906_h(stack);
        if (healAmount == 0 && saturation > 0.0f) {
            FoodStats stats = player.func_71024_bL();
            int prevFoodLevel = stats.func_75116_a();
            stats.func_75122_a(1, saturation);
            stats.func_75114_a(prevFoodLevel);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (this.hasContainerItem(stack = super.func_77654_b(stack, worldIn, entityLiving))) {
            if (stack.func_190916_E() == 0) {
                return this.getContainerItem(stack);
            }
            if (entityLiving instanceof EntityPlayer) {
                ((EntityPlayer)entityLiving).field_71071_by.func_70441_a(this.getContainerItem(stack));
            }
        }
        return stack;
    }

    private void applyBuffToPlayer(ItemStack stack, World world, EntityPlayer player) {
        int meta = stack.func_77960_j();
        int duration = EnumBLDrinkableBrew.byMetadata(meta).getBuffDuration();
        switch (meta) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                IInfestationIgnoreCapability ignore;
                if (world.field_72995_K || (ignore = (IInfestationIgnoreCapability)player.getCapability(CapabilityRegistry.CAPABILITY_INFESTATION_IGNORE, null)) == null || ignore.isImmune()) break;
                ignore.setImmune(Math.max(ignore.getRemainingImmunityTicks(), duration));
                break;
            }
            case 3: {
                player.func_70690_d(ElixirEffectRegistry.EFFECT_RIPENING.createEffect(duration, 1));
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                IFallDamageReductionCapability reduce;
                if (world.field_72995_K || (reduce = (IFallDamageReductionCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FALL_DAMAGE_REDUCTION, null)) == null || reduce.isActive()) break;
                reduce.setActive(Math.max(reduce.getRemainingActiveTicks(), duration));
                break;
            }
            case 6: {
                player.func_70690_d(ElixirEffectRegistry.EFFECT_HUNTERSSENSE.createEffect(duration, 1));
                player.func_70690_d(ElixirEffectRegistry.EFFECT_CATSEYES.createEffect(duration, 1));
                break;
            }
            case 7: {
                player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, duration, 1));
                break;
            }
            case 8: {
                IMudWalkerCapability mudWalk;
                if (world.field_72995_K || (mudWalk = (IMudWalkerCapability)player.getCapability(CapabilityRegistry.CAPABILITY_MUD_WALKER, null)) == null || mudWalk.isActive()) break;
                mudWalk.setActive(Math.max(mudWalk.getRemainingActiveTicks(), duration));
                break;
            }
            case 9: {
                player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, duration, 1));
                break;
            }
            case 10: {
                IFoodSicknessCapability cap = (IFoodSicknessCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null);
                if (world.field_72995_K || cap == null) break;
                if (FoodSickness.getSicknessForHatred(cap.getFoodHatred((Item)this)) != FoodSickness.SICK) {
                    cap.increaseFoodHatred((Item)this, 0, FoodSickness.SICK.maxHatred);
                }
                for (int count = 0; count < 4; ++count) {
                    EntityTinySludgeWormHelper worm = new EntityTinySludgeWormHelper(world);
                    worm.func_70012_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, player.field_70177_z, player.field_70125_A);
                    worm.setOwnerId(player.func_110124_au());
                    world.func_72838_d((Entity)worm);
                }
                break;
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        int i = stack.func_77960_j();
        return super.func_77658_a() + "." + EnumBLDrinkableBrew.byMetadata(i).getTranslationKey();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            Stream.of(EnumBLDrinkableBrew.values()).forEach(s -> list.add((Object)new ItemStack((Item)this, 1, s.getMetadata())));
        }
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        for (EnumBLDrinkableBrew type : EnumBLDrinkableBrew.values()) {
            models.put(type.getMetadata(), new ResourceLocation("thebetweenlands", type.getBrewName()));
        }
        return models;
    }
}

