/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.api.item.IRenamableItem;
import thebetweenlands.client.handler.WorldRenderHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.capability.equipment.EquipmentHelper;
import thebetweenlands.common.inventory.InventoryPouch;
import thebetweenlands.common.item.EnumBLDyeColor;
import thebetweenlands.common.item.ITintedItem;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.KeyBindRegistry;

public class ItemLurkerSkinPouch
extends Item
implements IEquippable,
IRenamableItem,
ITintedItem {
    private static boolean isRenderingWorld;

    public ItemLurkerSkinPouch() {
        this.func_77625_d(1);
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.func_77656_e(3);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("pouch_size"), (stack, worldIn, entityIn) -> stack.func_77952_i());
        IEquippable.addEquippedPropertyOverrides(this);
    }

    public static ItemStack getFirstPouch(EntityPlayer player) {
        ItemStack stack;
        int i;
        IEquipmentCapability cap = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
        if (cap != null) {
            IInventory inv = cap.getInventory(EnumEquipmentInventory.MISC);
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() != ItemRegistry.LURKER_SKIN_POUCH) continue;
                return stack;
            }
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        for (i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            stack = playerInventory.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ItemRegistry.LURKER_SKIN_POUCH) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        int slots = 9 + stack.func_77952_i() * 9;
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.bl.lurker_skin_pouch.size", (Object[])new Object[]{slots}));
        list.add(I18n.func_135052_a((String)"tooltip.bl.lurker_skin_pouch.usage", (Object[])new Object[]{KeyBindRegistry.OPEN_POUCH.getDisplayName()}));
        if (stack.func_77952_i() < stack.func_77958_k()) {
            list.add(I18n.func_135052_a((String)"tooltip.bl.lurker_skin_pouch.upgrade", (Object[])new Object[0]));
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack heldItem;
        if (player.func_70093_af() && !(heldItem = player.func_184586_b(hand)).func_190926_b() && heldItem.func_77973_b() == this) {
            if (!world.field_72995_K) {
                IItemHandler itemHandler;
                InventoryPouch inventory = new InventoryPouch(heldItem, 9 + heldItem.func_77952_i() * 9, "Lurker Skin Pouch");
                TileEntity tile = world.func_175625_s(pos);
                if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) != null) {
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack stack = inventory.func_70301_a(i);
                        if (stack.func_190926_b()) continue;
                        stack = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                        inventory.func_70299_a(i, stack);
                    }
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                this.checkForLegacyPouch(stack);
                player.openGui((Object)TheBetweenlands.instance, 11, world, 0, 0, 0);
            } else {
                player.openGui((Object)TheBetweenlands.instance, 13, world, hand == EnumHand.MAIN_HAND ? 0 : 1, 0, 0);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private void checkForLegacyPouch(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("type")) {
            stack.func_77978_p().func_74768_a("type", 7);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack basePouch = new ItemStack((Item)this);
            items.add((Object)basePouch);
            items.add((Object)new ItemStack((Item)this, 1, basePouch.func_77958_k()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onFogColors(EntityViewRenderEvent.FogColors event) {
        isRenderingWorld = true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        isRenderingWorld = false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderPlayer(RenderLivingEvent.Specials.Post<EntityLivingBase> event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ItemLurkerSkinPouch.renderPouch((EntityPlayer)event.getEntity(), event.getX(), event.getY(), event.getZ(), WorldRenderHandler.getPartialTicks());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderPouch(EntityPlayer player, double x, double y, double z, float partialTicks) {
        IEquipmentCapability cap = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
        if (cap != null) {
            IInventory inv = cap.getInventory(EnumEquipmentInventory.MISC);
            ItemStack pouch = ItemStack.field_190927_a;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() != ItemRegistry.LURKER_SKIN_POUCH) continue;
                pouch = stack;
                break;
            }
            if (!pouch.func_190926_b()) {
                TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
                RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
                textureManager.func_110577_a(TextureMap.field_110575_b);
                ITextureObject texture = textureManager.func_110581_b(TextureMap.field_110575_b);
                texture.func_174936_b(false, false);
                IBakedModel model = renderItem.func_184393_a(pouch, null, null);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)x, (double)(y + 1.0), (double)z);
                if (!isRenderingWorld) {
                    GlStateManager.func_179114_b((float)(90.0f - player.field_70761_aq), (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GlStateManager.func_179114_b((float)(90.0f - (player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks)), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GlStateManager.func_179137_b((double)(player.func_70093_af() ? 0.25 : 0.0), (double)((player.func_70093_af() ? -0.15 : 0.0) - 0.2), (double)-0.25);
                float limbSwingAmount = player.field_184618_aE + (player.field_70721_aZ - player.field_184618_aE) * partialTicks;
                float swing = (float)Math.sin((player.field_184619_aG - limbSwingAmount * (1.0f - partialTicks)) / 1.4f) * limbSwingAmount;
                GlStateManager.func_179114_b((float)(swing * 25.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)(swing * 13.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(swing * -10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)0.0, (double)-0.1, (double)0.0);
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.02);
                GlStateManager.func_179139_a((double)0.4, (double)0.4, (double)0.5);
                renderItem.func_180454_a(pouch, model);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.37, (double)0.37, (double)0.5);
                renderItem.func_180454_a(pouch, model);
                GlStateManager.func_179121_F();
                GlStateManager.func_179121_F();
                textureManager.func_110577_a(TextureMap.field_110575_b);
                texture.func_174935_a();
            }
        }
    }

    @Override
    public EnumEquipmentInventory getEquipmentCategory(ItemStack stack) {
        return EnumEquipmentInventory.MISC;
    }

    @Override
    public boolean canEquipOnRightClick(ItemStack stack, EntityPlayer player, Entity target) {
        return false;
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityPlayer player, Entity target) {
        return target == player && EquipmentHelper.getEquipment(EnumEquipmentInventory.MISC, target, this).func_190926_b();
    }

    @Override
    public boolean canUnequip(ItemStack stack, EntityPlayer player, Entity target, IInventory inventory) {
        return true;
    }

    @Override
    public boolean canDrop(ItemStack stack, Entity entity, IInventory inventory) {
        return true;
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, IInventory inventory) {
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorMultiplier(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("type")) {
                int type = stack.func_77978_p().func_74762_e("type");
                return EnumBLDyeColor.byMetadata(type).getColorValue();
            }
            return EnumBLDyeColor.byMetadata(EnumBLDyeColor.CHAMPAGNE.getMetadata()).getColorValue();
        }
        return -1;
    }
}

