/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor.amphibious;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.IAmphibiousArmorUpgrade;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.armor.amphibious.AmphibiousArmorEffectsHelper;
import thebetweenlands.common.item.armor.amphibious.AmphibiousArmorUpgrades;
import thebetweenlands.common.item.armor.amphibious.ItemAmphibiousArmor;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemAmphibiousArmourUpgradeToggle
extends Item {
    AmphibiousArmorEffectsHelper armorEffectsHelper = new AmphibiousArmorEffectsHelper();
    public final Map<IAmphibiousArmorUpgrade, Boolean> ALLOWED_UPGRADES = new HashMap<IAmphibiousArmorUpgrade, Boolean>();

    public ItemAmphibiousArmourUpgradeToggle() {
        this.field_77777_bU = 1;
        this.func_77656_e(600);
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.initAllowedUpgradeMap();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.amphibious_ability.toggle", (Object[])new Object[0]), 0));
    }

    public boolean isValidUpgrade(IAmphibiousArmorUpgrade upgradeIn) {
        return this.ALLOWED_UPGRADES.get(upgradeIn) != null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        int legCount;
        ItemStack stack = player.func_184586_b(hand);
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        NBTTagCompound nbt = player.getEntityData();
        ArrayList<IAmphibiousArmorUpgrade> upgradeListChest = new ArrayList<IAmphibiousArmorUpgrade>();
        if (chest.func_77973_b() instanceof ItemAmphibiousArmor && chest.func_77973_b() == ItemRegistry.AMPHIBIOUS_CHESTPLATE && !this.getUpgradeList(chest, EntityEquipmentSlot.CHEST).isEmpty()) {
            for (IAmphibiousArmorUpgrade upgrade : this.getUpgradeList(chest, EntityEquipmentSlot.CHEST)) {
                if (!this.isValidUpgrade(upgrade)) continue;
                upgradeListChest.add(upgrade);
            }
        }
        if (legs.func_77973_b() instanceof ItemAmphibiousArmor && legs.func_77973_b() == ItemRegistry.AMPHIBIOUS_LEGGINGS && !this.getUpgradeList(legs, EntityEquipmentSlot.LEGS).isEmpty()) {
            for (IAmphibiousArmorUpgrade upgrade : this.getUpgradeList(legs, EntityEquipmentSlot.LEGS)) {
                if (!this.isValidUpgrade(upgrade)) continue;
                upgradeListChest.add(upgrade);
            }
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("scrollPos", -1);
        }
        if (player.func_70093_af()) {
            if (chest.func_77973_b() instanceof ItemAmphibiousArmor && chest.func_77973_b() == ItemRegistry.AMPHIBIOUS_CHESTPLATE || legs.func_77973_b() instanceof ItemAmphibiousArmor && legs.func_77973_b() == ItemRegistry.AMPHIBIOUS_LEGGINGS) {
                int scrollSize = upgradeListChest.size();
                if (!upgradeListChest.isEmpty()) {
                    if (stack.func_77978_p().func_74762_e("scrollPos") < scrollSize) {
                        stack.func_77978_p().func_74768_a("scrollPos", stack.func_77978_p().func_74762_e("scrollPos") + 1);
                    }
                    if (stack.func_77978_p().func_74762_e("scrollPos") >= scrollSize) {
                        stack.func_77978_p().func_74768_a("scrollPos", 0);
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aa_toggle.selected_effect", new Object[]{this.getUpgradeName((AmphibiousArmorUpgrades)upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")))}), true);
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (chest.func_77973_b() instanceof ItemAmphibiousArmor && chest.func_77973_b() == ItemRegistry.AMPHIBIOUS_CHESTPLATE && stack.func_77978_p().func_74762_e("scrollPos") != -1 && !upgradeListChest.isEmpty()) {
            int glideCount;
            int electricCount;
            int vortexCount;
            int urchinCount;
            if (upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")) == AmphibiousArmorUpgrades.URCHIN && (urchinCount = ((ItemAmphibiousArmor)chest.func_77973_b()).getUpgradeCount(chest, AmphibiousArmorUpgrades.URCHIN)) >= 1) {
                chest.func_77978_p().func_74757_a("urchinAuto", !chest.func_77978_p().func_74767_n("urchinAuto"));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aa_toggle.urchin_active", new Object[]{new TextComponentTranslation("" + chest.func_77978_p().func_74767_n("urchinAuto"), new Object[0])}), true);
            }
            if (upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")) == AmphibiousArmorUpgrades.FISH_VORTEX && (vortexCount = ((ItemAmphibiousArmor)chest.func_77973_b()).getUpgradeCount(chest, AmphibiousArmorUpgrades.FISH_VORTEX)) >= 1) {
                chest.func_77978_p().func_74757_a("vortexAuto", !chest.func_77978_p().func_74767_n("vortexAuto"));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aa_toggle.vortex_active", new Object[]{new TextComponentTranslation("" + chest.func_77978_p().func_74767_n("vortexAuto"), new Object[0])}), true);
            }
            if (upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")) == AmphibiousArmorUpgrades.ELECTRIC && (electricCount = ((ItemAmphibiousArmor)chest.func_77973_b()).getUpgradeCount(chest, AmphibiousArmorUpgrades.ELECTRIC)) >= 1) {
                chest.func_77978_p().func_74757_a("electricAuto", !chest.func_77978_p().func_74767_n("electricAuto"));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aa_toggle.electric_active", new Object[]{new TextComponentTranslation("" + chest.func_77978_p().func_74767_n("electricAuto"), new Object[0])}), true);
            }
            if (upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")) == AmphibiousArmorUpgrades.GLIDE && (glideCount = ((ItemAmphibiousArmor)chest.func_77973_b()).getUpgradeCount(chest, AmphibiousArmorUpgrades.GLIDE)) >= 1) {
                chest.func_77978_p().func_74757_a("glideAuto", !chest.func_77978_p().func_74767_n("glideAuto"));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aa_toggle.glide_active", new Object[]{new TextComponentTranslation("" + chest.func_77978_p().func_74767_n("glideAuto"), new Object[0])}), true);
            }
        }
        if (legs.func_77973_b() instanceof ItemAmphibiousArmor && legs.func_77973_b() == ItemRegistry.AMPHIBIOUS_LEGGINGS && stack.func_77978_p().func_74762_e("scrollPos") != -1 && !upgradeListChest.isEmpty() && upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")) == AmphibiousArmorUpgrades.ASCENT_BOOST && (legCount = ((ItemAmphibiousArmor)legs.func_77973_b()).getUpgradeCount(legs, AmphibiousArmorUpgrades.ASCENT_BOOST)) >= 1) {
            legs.func_77978_p().func_74757_a("ascentAuto", !legs.func_77978_p().func_74767_n("ascentAuto"));
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aa_toggle.ascent_active", new Object[]{new TextComponentTranslation("" + legs.func_77978_p().func_74767_n("ascentAuto"), new Object[0])}), true);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public List<IAmphibiousArmorUpgrade> getUpgradeList(ItemStack stack, EntityEquipmentSlot slotType) {
        ArrayList<IAmphibiousArmorUpgrade> nameList = new ArrayList<IAmphibiousArmorUpgrade>();
        for (IAmphibiousArmorUpgrade upgrade : AmphibiousArmorUpgrades.getUpgrades(slotType)) {
            int count = ((ItemAmphibiousArmor)stack.func_77973_b()).getUpgradeCount(stack, upgrade);
            if (count <= 0) continue;
            nameList.add(upgrade);
        }
        return nameList;
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }

    private TextComponentTranslation getUpgradeName(AmphibiousArmorUpgrades upgrade) {
        switch (upgrade) {
            case AQUA_GEM: 
            case BREATHING: 
            case BUOYANCY: 
            case CRIMSON_GEM: 
            case DECAY_DECREASE: 
            case GREEN_GEM: 
            case KNOCKBACK_RESISTANCE: 
            case MINING_SPEED: 
            case MOVEMENT_SPEED: 
            case THORNS: 
            case TOUGHNESS: 
            case VISIBILITY: {
                break;
            }
            case ASCENT_BOOST: {
                return new TextComponentTranslation("chat.aa_item.ascent", new Object[0]);
            }
            case ELECTRIC: {
                return new TextComponentTranslation("chat.aa_item.electric", new Object[0]);
            }
            case FISH_VORTEX: {
                return new TextComponentTranslation("chat.aa_item.vortex", new Object[0]);
            }
            case GLIDE: {
                return new TextComponentTranslation("chat.aa_item.glide", new Object[0]);
            }
            case URCHIN: {
                return new TextComponentTranslation("chat.aa_item.urchin_spikes", new Object[0]);
            }
        }
        return new TextComponentTranslation("", new Object[0]);
    }

    private void initAllowedUpgradeMap() {
        if (this.ALLOWED_UPGRADES.isEmpty()) {
            this.ALLOWED_UPGRADES.put(AmphibiousArmorUpgrades.getUpgrade(EntityEquipmentSlot.CHEST, new ItemStack(ItemRegistry.AA_UPGRADE_VORTEX)), true);
            this.ALLOWED_UPGRADES.put(AmphibiousArmorUpgrades.getUpgrade(EntityEquipmentSlot.CHEST, new ItemStack(ItemRegistry.AA_UPGRADE_URCHIN)), true);
            this.ALLOWED_UPGRADES.put(AmphibiousArmorUpgrades.getUpgrade(EntityEquipmentSlot.CHEST, new ItemStack(ItemRegistry.AA_UPGRADE_ELECTRIC)), true);
            this.ALLOWED_UPGRADES.put(AmphibiousArmorUpgrades.getUpgrade(EntityEquipmentSlot.CHEST, new ItemStack(ItemRegistry.AA_UPGRADE_GLIDE)), true);
        }
    }
}

