/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor.amphibious;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.IAmphibiousArmorUpgrade;
import thebetweenlands.client.render.model.armor.ModelAmphibiousArmor;
import thebetweenlands.client.render.model.armor.ModelBodyAttachment;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.inventory.InventoryAmphibiousArmor;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.armor.Item3DArmor;
import thebetweenlands.common.item.armor.amphibious.AmphibiousArmorEffectsHelper;
import thebetweenlands.common.item.armor.amphibious.AmphibiousArmorUpgrades;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemAmphibiousArmor
extends Item3DArmor {
    private static final Random UID_RNG = new Random();
    private static final String NBT_WORN_UPGRADE_MAP_KEY = "thebetweenlands.worn_amphibious_armor_upgrades";
    private static final String NBT_UPGRADE_MAP_KEY = "thebetweenlands.amphibious_armor_upgrades";
    private static final String NBT_DAMAGE_MAP_KEY = "thebetweenlands.amphibious_armor_damage";
    private static final String NBT_UPGRADE_FILTER_KEY = "thebetweenlands.amphibious_armor_upgrade_filters";
    private static final String NBT_AMPHIBIOUS_UPGRADE_HAD_NO_NBT_KEY = "thebetweenlands.amphibious_armor_upgrade_had_no_nbt";
    private static final String NBT_AMPHIBIOUS_UPGRADE_DAMAGE_KEY = "thebetweenlands.amphibious_armor_upgrade_damage";
    private static final String NBT_AMPHIBIOUS_UPGRADE_MAX_DAMAGE_KEY = "thebetweenlands.amphibious_armor_upgrade_max_damage";
    private static final String NBT_AMPHIBIOUS_UPGRADE_DAMAGE_UID_KEY = "thebetweenlands.amphibious_armor_upgrade_damage_uid";
    private static final String NBT_ASCENT_BOOST_TICKS = "thebetweenlands.ascent_boost_ticks";
    private static final String NBT_ASCENT_BOOST = "thebetweenlands.ascent_boost";
    private static final String NBT_URCHIN_AOE_COOLDOWN = "thebetweenlands.urchin_aoe_cooldown";
    private static final String NBT_ELECTRIC_COOLDOWN = "thebetweenlands.electric_cooldown";
    private EntityPlayerMP player;
    AmphibiousArmorEffectsHelper armorEffectsHelper = new AmphibiousArmorEffectsHelper();

    public ItemAmphibiousArmor(EntityEquipmentSlot slot) {
        super(BLMaterialRegistry.ARMOR_AMPHIBIOUS, 3, slot, "amphibious");
        this.setGemArmorTextureOverride(CircleGemType.AQUA, "amphibious_aqua");
        this.setGemArmorTextureOverride(CircleGemType.CRIMSON, "amphibious_crimson");
        this.setGemArmorTextureOverride(CircleGemType.GREEN, "amphibious_green");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBodyAttachment createModel() {
        return new ModelAmphibiousArmor();
    }

    public int getUpgradeSlotCount(ItemStack stack) {
        switch (this.field_77881_a) {
            case HEAD: 
            case FEET: {
                return 3;
            }
            case CHEST: 
            case LEGS: {
                return 5;
            }
        }
        return 0;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            this.player = (EntityPlayerMP)player;
            Map<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>> wornUpgrades = ItemAmphibiousArmor.getWornUpgradeCounts((EntityLivingBase)player);
            NBTTagCompound nbt = itemStack.func_77978_p();
            if (!wornUpgrades.isEmpty()) {
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                NBTTagList wornUpgradesNbt = new NBTTagList();
                for (Map.Entry<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>> upgrade : wornUpgrades.entrySet()) {
                    NBTTagCompound upgradeNbt = new NBTTagCompound();
                    upgradeNbt.func_74778_a("id", upgrade.getKey().getId().toString());
                    NBTTagList countsNbt = new NBTTagList();
                    for (Map.Entry<EntityEquipmentSlot, Integer> count : upgrade.getValue().entrySet()) {
                        NBTTagCompound countNbt = new NBTTagCompound();
                        countNbt.func_74778_a("slot", count.getKey().func_188450_d());
                        countNbt.func_74768_a("count", count.getValue().intValue());
                        countsNbt.func_74742_a((NBTBase)countNbt);
                    }
                    upgradeNbt.func_74782_a("counts", (NBTBase)countsNbt);
                    wornUpgradesNbt.func_74742_a((NBTBase)upgradeNbt);
                }
                nbt.func_74782_a(NBT_WORN_UPGRADE_MAP_KEY, (NBTBase)wornUpgradesNbt);
                itemStack.func_77982_d(nbt);
            } else if (nbt != null) {
                nbt.func_82580_o(NBT_WORN_UPGRADE_MAP_KEY);
            }
        }
        if (!player.func_175149_v()) {
            NonNullList armor = player.field_71071_by.field_70460_b;
            int armorPieces = 0;
            boolean fullyInWater = false;
            for (ItemStack anArmor : armor) {
                if (anArmor == null || !(anArmor.func_77973_b() instanceof ItemAmphibiousArmor)) continue;
                ++armorPieces;
            }
            if (player.func_70090_H()) {
                IBlockState blockState = player.field_70170_p.func_180495_p(new BlockPos(player.field_70165_t, player.func_174813_aQ().field_72337_e + 0.1, player.field_70161_v));
                fullyInWater = blockState.func_185904_a().func_76224_d();
            }
            NBTTagCompound nbt = player.getEntityData();
            if (itemStack.func_77973_b() == ItemRegistry.AMPHIBIOUS_CHESTPLATE) {
                if (!itemStack.func_77942_o()) {
                    itemStack.func_77982_d(new NBTTagCompound());
                    itemStack.func_77978_p().func_74757_a("vortexAuto", true);
                    itemStack.func_77978_p().func_74757_a("urchinAuto", true);
                    itemStack.func_77978_p().func_74757_a("electricAuto", true);
                    itemStack.func_77978_p().func_74757_a("glideAuto", true);
                    itemStack.func_77978_p().func_74757_a("ascentAuto", true);
                }
                int vortexCount = this.getUpgradeCount(itemStack, AmphibiousArmorUpgrades.FISH_VORTEX);
                int urchinCount = this.getUpgradeCount(itemStack, AmphibiousArmorUpgrades.URCHIN);
                int electricCount = this.getUpgradeCount(itemStack, AmphibiousArmorUpgrades.ELECTRIC);
                int glideCount = this.getUpgradeCount(itemStack, AmphibiousArmorUpgrades.GLIDE);
                long urchinAOECooldown = nbt.func_74763_f(NBT_URCHIN_AOE_COOLDOWN);
                long electricCooldown = nbt.func_74763_f(NBT_ELECTRIC_COOLDOWN);
                if (vortexCount >= 1 && itemStack.func_77978_p().func_74767_n("vortexAuto") && world.func_82737_E() % 200L == 0L && !world.field_72995_K) {
                    this.armorEffectsHelper.activateFishVortex(world, player, vortexCount);
                    this.damageUpgrade(itemStack, AmphibiousArmorUpgrades.FISH_VORTEX, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, false);
                }
                if (urchinCount >= 1 && itemStack.func_77978_p().func_74767_n("urchinAuto") && world.func_82737_E() % 10L == 0L && world.func_82737_E() >= urchinAOECooldown && !world.field_72995_K) {
                    this.armorEffectsHelper.activateUrchinSpikes(world, player, urchinCount, nbt);
                    this.damageUpgrade(itemStack, AmphibiousArmorUpgrades.URCHIN, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, false);
                }
                if (electricCount >= 1 && itemStack.func_77978_p().func_74767_n("electricAuto") && player.field_70172_ad == player.field_70771_an && world.func_82737_E() >= electricCooldown && !world.field_72995_K) {
                    this.armorEffectsHelper.activateElectricEntity(world, player, electricCount, nbt);
                    this.damageUpgrade(itemStack, AmphibiousArmorUpgrades.ELECTRIC, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, false);
                }
                if (glideCount >= 1 && itemStack.func_77978_p().func_74767_n("glideAuto") && player.func_70051_ag() && !player.field_70122_E && !player.field_70703_bu) {
                    player.field_70143_R = 0.0f;
                    player.field_70159_w *= 1.05;
                    player.field_70179_y *= 1.05;
                    player.field_70181_x *= 0.6 - (double)((float)glideCount * 0.1f);
                    if (player.field_70173_aa % 20 == 0) {
                        this.damageUpgrade(itemStack, AmphibiousArmorUpgrades.GLIDE, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, false);
                    }
                }
            }
            int ascentBoostTicks = nbt.func_74762_e(NBT_ASCENT_BOOST_TICKS);
            if (itemStack.func_77973_b() == ItemRegistry.AMPHIBIOUS_LEGGINGS) {
                if (this.getUpgradeCount(itemStack, AmphibiousArmorUpgrades.ASCENT_BOOST) >= 1) {
                    if (player.func_70093_af() && player.field_70122_E && !nbt.func_74767_n(NBT_ASCENT_BOOST)) {
                        nbt.func_74768_a(NBT_ASCENT_BOOST_TICKS, ++ascentBoostTicks);
                    } else if (!player.func_70093_af() && player.func_70090_H()) {
                        if (ascentBoostTicks > 10 && !nbt.func_74767_n(NBT_ASCENT_BOOST)) {
                            ascentBoostTicks = 30;
                            nbt.func_74768_a(NBT_ASCENT_BOOST_TICKS, ascentBoostTicks);
                            nbt.func_74757_a(NBT_ASCENT_BOOST, true);
                            player.field_70181_x += 0.75;
                            Vec3d lookVec = player.func_70040_Z().func_72432_b();
                            double speed = 1.2;
                            player.field_70159_w += lookVec.field_72450_a * speed;
                            player.field_70179_y += lookVec.field_72449_c * speed;
                            player.field_70181_x += lookVec.field_72448_b * 0.5;
                            this.damageUpgrade(itemStack, AmphibiousArmorUpgrades.ASCENT_BOOST, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, false);
                        }
                        ascentBoostTicks = Math.max(0, ascentBoostTicks - 1);
                        nbt.func_74768_a(NBT_ASCENT_BOOST_TICKS, ascentBoostTicks);
                    }
                } else {
                    nbt.func_74768_a(NBT_ASCENT_BOOST_TICKS, 0);
                }
            }
            if (ascentBoostTicks <= 0 || !player.func_70090_H()) {
                ascentBoostTicks = 0;
                nbt.func_74768_a(NBT_ASCENT_BOOST_TICKS, 0);
                nbt.func_74757_a(NBT_ASCENT_BOOST, false);
            }
            if (nbt.func_74767_n(NBT_ASCENT_BOOST) && player.func_70090_H() && player.field_70181_x < 2.0) {
                player.field_70181_x += 0.05;
            }
            if (itemStack.func_77973_b() == ItemRegistry.AMPHIBIOUS_HELMET) {
                if (player.func_70090_H()) {
                    int visibilityCount = this.getUpgradeCount(itemStack, AmphibiousArmorUpgrades.VISIBILITY);
                    if (visibilityCount >= 1 && fullyInWater) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 10, 0));
                    }
                } else if (this.getUpgradeCount(itemStack, AmphibiousArmorUpgrades.FISH_SIGHT) > 0 && player.field_70173_aa % 40 == 0) {
                    int radius = this.getUpgradeCount(itemStack, AmphibiousArmorUpgrades.FISH_SIGHT) * 8;
                    AxisAlignedBB aabb = new AxisAlignedBB(player.func_180425_c()).func_186662_g((double)radius);
                    for (EntityAnadia anadia : world.func_175647_a(EntityAnadia.class, aabb, a -> a.func_70092_e((float)player.func_180425_c().func_177958_n() + 0.5f, (float)player.func_180425_c().func_177956_o() + 0.5f, (float)player.func_180425_c().func_177952_p() + 0.5f) <= (double)(radius * radius))) {
                        if (anadia.func_184202_aL()) continue;
                        anadia.setGlowTimer(200);
                        this.damageUpgrade(itemStack, AmphibiousArmorUpgrades.FISH_SIGHT, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, false);
                    }
                }
            }
            if (itemStack.func_77973_b() == ItemRegistry.AMPHIBIOUS_BOOTS && player.func_70090_H() && fullyInWater) {
                int bladderCount;
                if (ascentBoostTicks <= 0 && !player.func_70093_af() && player.field_191988_bg == 0.0f) {
                    player.field_70181_x = Math.sin((float)player.field_70173_aa / 5.0f) * 0.016;
                }
                if (player.field_191988_bg != 0.0f) {
                    if (player.field_191988_bg > 0.0f) {
                        Vec3d lookVec = player.func_70040_Z().func_72432_b();
                        double speed = 0.01 + 0.0125 * (double)armorPieces;
                        player.field_70159_w += lookVec.field_72450_a * (double)player.field_191988_bg * speed;
                        player.field_70179_y += lookVec.field_72449_c * (double)player.field_191988_bg * speed;
                        if (!player.func_70093_af() || lookVec.field_72448_b < 0.0) {
                            player.field_70181_x += lookVec.field_72448_b * (double)player.field_191988_bg * speed;
                        }
                        player.func_71024_bL().func_75113_a(0.0024f);
                    }
                    if (!player.func_70093_af()) {
                        player.field_70181_x += 0.02;
                    }
                }
                if ((bladderCount = ItemAmphibiousArmor.getUpgradeCount((EntityLivingBase)player, AmphibiousArmorUpgrades.BUOYANCY)) > 0) {
                    double speedMod = (double)bladderCount * 0.01;
                    if (player.field_191988_bg != 0.0f) {
                        speedMod *= 0.5;
                    }
                    if (player.func_70093_af()) {
                        player.field_70181_x -= speedMod;
                    } else if (player.field_70703_bu) {
                        player.field_70181_x += speedMod + 0.02;
                    }
                }
            }
            int breathingCount = Math.min(this.getUpgradeCount(itemStack, AmphibiousArmorUpgrades.BREATHING), 2);
            if (player.func_70090_H()) {
                boolean hasBreathingUpgrade = false;
                if (armorPieces >= 4) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 10));
                    if (breathingCount >= 2) {
                        player.func_70050_g(300);
                    } else if (player.field_70173_aa % (10 + breathingCount * 10) == 0) {
                        player.func_70050_g(player.func_70086_ai() - 1);
                    }
                    hasBreathingUpgrade = true;
                } else if (breathingCount > 0) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 10));
                    if (player.field_70173_aa % (4 + breathingCount) == 0) {
                        player.func_70050_g(player.func_70086_ai() - 1);
                    }
                    hasBreathingUpgrade = true;
                }
                if (hasBreathingUpgrade && player.func_70086_ai() <= -20) {
                    player.func_70050_g(0);
                    for (int i = 0; i < 8; ++i) {
                        Random rand = world.field_73012_v;
                        float rx = rand.nextFloat() - rand.nextFloat();
                        float ry = rand.nextFloat() - rand.nextFloat();
                        float rz = rand.nextFloat() - rand.nextFloat();
                        player.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, player.field_70165_t + (double)rx, player.field_70163_u + (double)ry, player.field_70161_v + (double)rz, player.field_70159_w, player.field_70181_x, player.field_70179_y, new int[0]);
                    }
                    player.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        for (AmphibiousArmorUpgrades upgrade : AmphibiousArmorUpgrades.values()) {
            int count = this.getUpgradeCount(stack, upgrade);
            if (count <= 0) continue;
            Map<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>> counts = ItemAmphibiousArmor.getWornUpgradeCounts(stack);
            int wornCount = 0;
            if (counts.containsKey(upgrade)) {
                for (Map.Entry<EntityEquipmentSlot, Integer> entry : counts.get(upgrade).entrySet()) {
                    wornCount += entry.getValue().intValue();
                }
            }
            System.out.println(upgrade.getId() + ": " + count + " / " + wornCount);
        }
        if (player.func_70093_af()) {
            player.openGui((Object)TheBetweenlands.instance, 34, world, 0, 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == this.field_77881_a) {
            for (IAmphibiousArmorUpgrade upgrade : AmphibiousArmorUpgrades.getUpgrades(this.field_77881_a)) {
                int count = this.getUpgradeCount(stack, upgrade);
                if (count <= 0) continue;
                upgrade.applyAttributeModifiers(this.field_77881_a, stack, count, ItemAmphibiousArmor.getWornUpgradeCounts(stack), (Multimap<String, AttributeModifier>)modifiers);
            }
        }
        return modifiers;
    }

    public void setDamage(ItemStack stack, int damage) {
        for (AmphibiousArmorUpgrades upgrade : AmphibiousArmorUpgrades.values()) {
            this.damageUpgrade(stack, upgrade, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, true);
        }
        if (this.getDamage(stack) >= stack.func_77958_k()) {
            InventoryAmphibiousArmor inv = new InventoryAmphibiousArmor(stack, "");
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack upgradeItem = inv.func_70301_a(i).func_77946_l();
                if (upgradeItem.func_190926_b()) continue;
                int itemDamage = this.getUpgradeDamage(stack, i);
                ItemAmphibiousArmor.setUpgradeItemStoredDamage(upgradeItem, itemDamage, upgradeItem.func_77958_k());
                if (this.player.field_71071_by.func_70441_a(upgradeItem)) continue;
                this.player.func_71019_a(upgradeItem, false);
            }
        }
        super.setDamage(stack, damage);
    }

    public void setUpgradeFilter(ItemStack stack, int slot, ItemStack filter) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        if (filter.func_190926_b()) {
            nbt.func_82580_o("thebetweenlands.amphibious_armor_upgrade_filters." + slot);
        } else {
            NBTTagCompound filterNbt = nbt.func_74775_l("thebetweenlands.amphibious_armor_upgrade_filters." + slot);
            filter = filter.func_77946_l().func_77979_a(1);
            ItemAmphibiousArmor.setUpgradeItemStoredDamage(filter, 0, 0);
            filter.func_77955_b(filterNbt);
            nbt.func_74782_a("thebetweenlands.amphibious_armor_upgrade_filters." + slot, (NBTBase)filterNbt);
        }
    }

    public ItemStack getUpgradeFilter(ItemStack stack, int slot) {
        NBTTagCompound filterNbt;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && !(filterNbt = nbt.func_74775_l("thebetweenlands.amphibious_armor_upgrade_filters." + slot)).func_82582_d()) {
            return new ItemStack(filterNbt);
        }
        return ItemStack.field_190927_a;
    }

    public void setUpgradeCounts(ItemStack stack, IInventory inv) {
        NBTTagCompound upgradesMap = new NBTTagCompound();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            IAmphibiousArmorUpgrade upgrade;
            ItemStack upgradeItem = inv.func_70301_a(i);
            if (upgradeItem.func_190926_b() || (upgrade = AmphibiousArmorUpgrades.getUpgrade(this.field_77881_a, upgradeItem)) == null) continue;
            String idStr = upgrade.getId().toString();
            upgradesMap.func_74768_a(idStr, upgradesMap.func_74762_e(idStr) + 1);
        }
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74782_a(NBT_UPGRADE_MAP_KEY, (NBTBase)upgradesMap);
    }

    public static int getUpgradeCount(EntityLivingBase entity, IAmphibiousArmorUpgrade upgrade) {
        int count = 0;
        for (ItemStack stack : entity.func_184193_aE()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemAmphibiousArmor)) continue;
            count += ((ItemAmphibiousArmor)stack.func_77973_b()).getUpgradeCount(stack, upgrade);
        }
        return count;
    }

    public static Map<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>> getWornUpgradeCounts(EntityLivingBase entity) {
        HashMap<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>> upgrades = new HashMap<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>>();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (stack = entity.func_184582_a(slot)).func_190926_b() || !(stack.func_77973_b() instanceof ItemAmphibiousArmor)) continue;
            for (IAmphibiousArmorUpgrade upgrade : AmphibiousArmorUpgrades.getUpgrades(slot)) {
                int count = ((ItemAmphibiousArmor)stack.func_77973_b()).getUpgradeCount(stack, upgrade);
                if (count <= 0) continue;
                HashMap<EntityEquipmentSlot, Integer> counts = (HashMap<EntityEquipmentSlot, Integer>)upgrades.get(upgrade);
                if (counts == null) {
                    counts = new HashMap<EntityEquipmentSlot, Integer>();
                    upgrades.put(upgrade, counts);
                }
                counts.put(slot, count);
            }
        }
        return upgrades;
    }

    public static Map<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>> getWornUpgradeCounts(ItemStack stack) {
        HashMap<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>> wornUpgrades = new HashMap<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>>();
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b(NBT_WORN_UPGRADE_MAP_KEY, 9)) {
            NBTTagList wornUpgradesNbt = nbt.func_150295_c(NBT_WORN_UPGRADE_MAP_KEY, 10);
            for (int i = 0; i < wornUpgradesNbt.func_74745_c(); ++i) {
                NBTTagCompound upgradeNbt = wornUpgradesNbt.func_150305_b(i);
                IAmphibiousArmorUpgrade upgrade = AmphibiousArmorUpgrades.getUpgrade(new ResourceLocation(upgradeNbt.func_74779_i("id")));
                if (upgrade == null) continue;
                NBTTagList countsNbt = upgradeNbt.func_150295_c("counts", 10);
                HashMap<EntityEquipmentSlot, Integer> counts = new HashMap<EntityEquipmentSlot, Integer>();
                for (int j = 0; j < countsNbt.func_74745_c(); ++j) {
                    NBTTagCompound countNbt = countsNbt.func_150305_b(j);
                    counts.put(EntityEquipmentSlot.func_188451_a((String)countNbt.func_74779_i("slot")), countNbt.func_74762_e("count"));
                }
                wornUpgrades.put(upgrade, counts);
            }
        }
        return wornUpgrades;
    }

    public int getUpgradeCount(ItemStack stack, IAmphibiousArmorUpgrade upgrade) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74775_l(NBT_UPGRADE_MAP_KEY).func_74762_e(upgrade.getId().toString());
        }
        return 0;
    }

    public static boolean damageUpgrade(EntityLivingBase entity, IAmphibiousArmorUpgrade upgrade, int amount, IAmphibiousArmorUpgrade.DamageEvent damageEvent, boolean damageAll) {
        ItemStack stack;
        boolean damaged = false;
        Iterator iterator = entity.func_184193_aE().iterator();
        while (iterator.hasNext() && ((stack = (ItemStack)iterator.next()).func_190926_b() || !(stack.func_77973_b() instanceof ItemAmphibiousArmor) || !(damaged |= ((ItemAmphibiousArmor)stack.func_77973_b()).damageUpgrade(stack, upgrade, amount, damageEvent, damageAll)) || damageAll)) {
        }
        return damaged;
    }

    public boolean damageUpgrade(ItemStack stack, IAmphibiousArmorUpgrade upgrade, int amount, IAmphibiousArmorUpgrade.DamageEvent damageEvent, boolean damageAll) {
        if (damageEvent == IAmphibiousArmorUpgrade.DamageEvent.NONE) {
            return false;
        }
        boolean damaged = false;
        InventoryAmphibiousArmor inv = new InventoryAmphibiousArmor(stack, "");
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            int maxDamage;
            IAmphibiousArmorUpgrade itemUpgrade;
            ItemStack upgradeItem = inv.func_70301_a(i);
            if (upgradeItem.func_190926_b() || (itemUpgrade = AmphibiousArmorUpgrades.getUpgrade(this.field_77881_a, upgradeItem)) != upgrade || damageEvent != IAmphibiousArmorUpgrade.DamageEvent.ALL && !itemUpgrade.isApplicableDamageEvent(damageEvent)) continue;
            int damage = this.getUpgradeDamage(stack, i);
            if (damage + amount > (maxDamage = this.getUpgradeMaxDamage(stack, i))) {
                if (itemUpgrade.canBreak()) {
                    if (this.player != null && !this.player.field_70170_p.field_72995_K) {
                        System.out.println(this.player.func_180425_c());
                        this.player.field_70170_p.func_184133_a(null, this.player.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.AMBIENT, 1.0f, 1.0f);
                        this.player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aa_upgrade_broke", new Object[]{upgradeItem.func_82833_r()}), false);
                    }
                    upgradeItem.func_190918_g(1);
                    inv.func_70299_a(i, upgradeItem);
                    this.setUpgradeDamage(stack, i, 0, itemUpgrade.getMaxDamage());
                }
            } else {
                this.setUpgradeDamage(stack, i, damage + amount);
            }
            damaged = true;
            if (damageAll) continue;
            return true;
        }
        return damaged;
    }

    public void setUpgradeDamage(ItemStack stack, int slot, int damage) {
        this.setUpgradeDamage(stack, slot, damage, -1);
    }

    public void setUpgradeDamage(ItemStack stack, int slot, int damage, int maxDamage) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        String key = "thebetweenlands.amphibious_armor_damage." + slot;
        NBTTagCompound damageNbt = nbt.func_74775_l(key);
        if (maxDamage < 0) {
            maxDamage = damageNbt.func_74762_e("maxDamage");
        } else {
            damageNbt.func_74768_a("maxDamage", maxDamage);
        }
        damageNbt.func_74768_a("damage", MathHelper.func_76125_a((int)damage, (int)0, (int)maxDamage));
        nbt.func_74782_a(key, (NBTBase)damageNbt);
    }

    public int getUpgradeDamage(ItemStack stack, int slot) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            String key = "thebetweenlands.amphibious_armor_damage." + slot;
            NBTTagCompound damageNbt = nbt.func_74775_l(key);
            return damageNbt.func_74762_e("damage");
        }
        return 0;
    }

    public int getUpgradeMaxDamage(ItemStack stack, int slot) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            String key = "thebetweenlands.amphibious_armor_damage." + slot;
            NBTTagCompound damageNbt = nbt.func_74775_l(key);
            return damageNbt.func_74762_e("maxDamage");
        }
        return 0;
    }

    public static int getUpgradeItemStoredDamage(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74762_e(NBT_AMPHIBIOUS_UPGRADE_DAMAGE_KEY);
        }
        return 0;
    }

    public static int getUpgradeItemMaxStoredDamage(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74762_e(NBT_AMPHIBIOUS_UPGRADE_MAX_DAMAGE_KEY);
        }
        return 0;
    }

    public static void setUpgradeItemStoredDamage(ItemStack stack, int damage, int maxDamage) {
        boolean hadNbt = stack.func_77978_p() != null;
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        if (!nbt.func_150297_b(NBT_AMPHIBIOUS_UPGRADE_DAMAGE_KEY, 3)) {
            nbt.func_74757_a(NBT_AMPHIBIOUS_UPGRADE_HAD_NO_NBT_KEY, !hadNbt);
        }
        if (damage > 0) {
            nbt.func_74768_a(NBT_AMPHIBIOUS_UPGRADE_DAMAGE_KEY, damage);
            nbt.func_74768_a(NBT_AMPHIBIOUS_UPGRADE_MAX_DAMAGE_KEY, maxDamage);
            nbt.func_74772_a(NBT_AMPHIBIOUS_UPGRADE_DAMAGE_UID_KEY, UID_RNG.nextLong());
        } else {
            boolean hadNoNbt = nbt.func_74767_n(NBT_AMPHIBIOUS_UPGRADE_HAD_NO_NBT_KEY);
            nbt.func_82580_o(NBT_AMPHIBIOUS_UPGRADE_HAD_NO_NBT_KEY);
            nbt.func_82580_o(NBT_AMPHIBIOUS_UPGRADE_DAMAGE_KEY);
            nbt.func_82580_o(NBT_AMPHIBIOUS_UPGRADE_MAX_DAMAGE_KEY);
            nbt.func_82580_o(NBT_AMPHIBIOUS_UPGRADE_DAMAGE_UID_KEY);
            if (hadNoNbt && nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }
}

