/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor.amphibious;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IBLBoss;
import thebetweenlands.common.entity.EntityFishVortex;
import thebetweenlands.common.entity.EntityShock;
import thebetweenlands.common.entity.EntityUrchinSpikeAOE;

public class AmphibiousArmorEffectsHelper {
    public static final String NBT_URCHIN_AOE_COOLDOWN = "thebetweenlands.urchin_aoe_cooldown";
    public static final String NBT_ELECTRIC_COOLDOWN = "thebetweenlands.electric_cooldown";

    protected AxisAlignedBB proximityBox(EntityPlayer player, double xSize, double ySize, double zSize) {
        return new AxisAlignedBB(player.func_180425_c()).func_72314_b(xSize, ySize, zSize);
    }

    public void activateFishVortex(World world, EntityPlayer player, int vortexCount) {
        List list = this.findNearbyEntities(world, player, this.proximityBox(player, 8.0, 4.0, 8.0));
        for (int entityCount = 0; entityCount < Math.min(vortexCount, list.size()); ++entityCount) {
            EntityLivingBase entity = this.pickRandomEntityFromList(list);
            if (entity == null || entity instanceof IBLBoss || entity instanceof EntityPlayer) continue;
            this.spawnFishVortex(world, entity);
            list.remove(0);
        }
    }

    public void activateUrchinSpikes(World world, EntityPlayer player, int urchinCount, NBTTagCompound nbt) {
        EntityLivingBase entity;
        List list = this.findNearbyEntities(world, player, this.proximityBox(player, 2.0, 2.0, 2.0));
        if (!list.isEmpty() && (entity = (EntityLivingBase)list.get(0)) != null && !(entity instanceof EntityPlayer)) {
            this.spawnUrchinSpikes(world, player, urchinCount);
            nbt.func_74772_a(NBT_URCHIN_AOE_COOLDOWN, world.func_82737_E() + 50L);
        }
    }

    public void activateElectricEntity(World world, EntityPlayer player, int electricCount, NBTTagCompound nbt) {
        if (player.func_70643_av() != null && !(player.func_70643_av() instanceof EntityPlayer)) {
            this.spawnElectricEntity(world, player, player.func_70643_av(), electricCount);
            nbt.func_74772_a(NBT_ELECTRIC_COOLDOWN, world.func_82737_E() + 50L);
        }
    }

    private void spawnFishVortex(World world, EntityLivingBase entity) {
        EntityFishVortex vortex = new EntityFishVortex(world);
        vortex.func_70107_b(entity.field_70165_t, entity.field_70163_u + 0.25, entity.field_70161_v);
        world.func_72838_d((Entity)vortex);
        entity.func_184205_a((Entity)vortex, true);
    }

    public void spawnUrchinSpikes(World world, EntityPlayer player, int damage) {
        EntityUrchinSpikeAOE urchinSpikes = new EntityUrchinSpikeAOE(world, player, damage);
        urchinSpikes.func_70107_b(player.field_70165_t, player.field_70163_u + (double)player.field_70131_O * 0.5, player.field_70161_v);
        world.func_72838_d((Entity)urchinSpikes);
        urchinSpikes.shootSpikes();
    }

    public void spawnElectricEntity(World world, EntityPlayer player, EntityLivingBase entity, int electricCount) {
        EntityShock electric = new EntityShock(world, (Entity)player, entity, electricCount, entity.func_70026_G() || entity.func_70090_H() || world.func_175727_C(entity.func_180425_c().func_177984_a()));
        world.func_72838_d((Entity)electric);
    }

    private List findNearbyEntities(World world, EntityPlayer player, AxisAlignedBB box) {
        return world.func_175647_a(EntityLivingBase.class, box, e -> e instanceof IMob);
    }

    private EntityLivingBase pickRandomEntityFromList(List<EntityLivingBase> list) {
        Collections.shuffle(list);
        return list.get(0);
    }
}

