/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import thebetweenlands.common.registries.ItemRegistry;

public enum EnumBLDrinkableBrew implements IStringSerializable
{
    NETTLE_SOUP(0, "nettle_soup", -16040693, ItemRegistry.DRINKABLE_BREW, 2, 0.3f, false, 0),
    NETTLE_TEA(1, "nettle_tea", -14260705, ItemRegistry.DRINKABLE_BREW, 0, 0.2f, false, 0),
    PHEROMONE_EXTRACT(2, "pheromone_extract", -9611660, ItemRegistry.DRINKABLE_BREW, 0, 0.0f, true, 2400),
    SWAMP_BROTH(3, "swamp_broth", -12035264, ItemRegistry.DRINKABLE_BREW, 0, 0.2f, true, 400),
    STURDY_STOCK(4, "sturdy_stock", -9416136, ItemRegistry.DRINKABLE_BREW, 0, 2.0f, false, 0),
    PEAR_CORDIAL(5, "pear_cordial", -1251377, ItemRegistry.DRINKABLE_BREW, 0, 0.2f, true, 400),
    SHAMANS_BREW(6, "shamans_brew", -2397090, ItemRegistry.DRINKABLE_BREW, 0, 0.2f, true, 400),
    LAKE_BROTH(7, "lake_broth", -11045788, ItemRegistry.DRINKABLE_BREW, 0, 0.2f, true, 400),
    SHELL_STOCK(8, "shell_stock", -5724073, ItemRegistry.DRINKABLE_BREW, 0, 0.2f, true, 400),
    FROG_LEG_EXTRACT(9, "frog_leg_extract", -12361417, ItemRegistry.DRINKABLE_BREW, 0, 0.2f, true, 400),
    WITCH_TEA(10, "witch_tea", -12762302, ItemRegistry.DRINKABLE_BREW, 0, 0.2f, true, 0);

    private static final EnumBLDrinkableBrew[] META_LOOKUP;
    private final int meta;
    private final String name;
    private final int healAmount;
    private final float saturationModifier;
    private final boolean hasBuff;
    private final int buffDuration;
    private final int colorValue;
    private final float[] colorComponentValues;
    private Item brewItem;

    private EnumBLDrinkableBrew(int metaIn, String nameIn, int colorValueIn, Item item, int healAmountIn, float saturationModifierIn, boolean hasBuffIn, int buffDurationIn) {
        this.meta = metaIn;
        this.name = nameIn;
        this.colorValue = colorValueIn;
        int i = (colorValueIn & 0xFF0000) >> 16;
        int j = (colorValueIn & 0xFF00) >> 8;
        int k = (colorValueIn & 0xFF) >> 0;
        this.colorComponentValues = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
        this.brewItem = item;
        this.healAmount = healAmountIn;
        this.saturationModifier = saturationModifierIn;
        this.hasBuff = hasBuffIn;
        this.buffDuration = buffDurationIn;
    }

    public int getMetadata() {
        return this.meta;
    }

    public ItemStack getBrewItemStack() {
        return this.brewItem != null ? new ItemStack(this.brewItem, 1, this.meta) : ItemStack.field_190927_a;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public boolean hasBuff() {
        return this.hasBuff;
    }

    public int getBuffDuration() {
        return this.buffDuration;
    }

    public String getBrewName() {
        return this.name;
    }

    public String getTranslationKey() {
        return this.name;
    }

    public int getColorValue() {
        return this.colorValue;
    }

    public float[] getColorComponentValues() {
        return this.colorComponentValues;
    }

    public static EnumBLDrinkableBrew byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    static {
        META_LOOKUP = new EnumBLDrinkableBrew[EnumBLDrinkableBrew.values().length];
        EnumBLDrinkableBrew[] enumBLDrinkableBrewArray = EnumBLDrinkableBrew.values();
        int n = enumBLDrinkableBrewArray.length;
        for (int i = 0; i < n; ++i) {
            EnumBLDrinkableBrew enumbrew;
            EnumBLDrinkableBrew.META_LOOKUP[enumbrew.getMetadata()] = enumbrew = enumBLDrinkableBrewArray[i];
        }
    }
}

