/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.common.entity.projectiles.EntityAngryPebble;
import thebetweenlands.common.registries.ItemRegistry;

public class EntitySilkyPebble
extends EntityAngryPebble {
    public EntitySilkyPebble(World world) {
        super(world);
    }

    public EntitySilkyPebble(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void boomEvent(ExplosionEvent.Detonate event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        World world = event.getWorld();
        Explosion explosion = event.getExplosion();
        EntityLivingBase placedBy = explosion.func_94613_c();
        if (placedBy instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placedBy;
            List entityList = event.getAffectedEntities();
            List blockPosList = event.getAffectedBlocks();
            if (entityList.stream().anyMatch(entity -> entity instanceof EntitySilkyPebble)) {
                Iterator it = blockPosList.iterator();
                while (it.hasNext()) {
                    BlockPos pos = (BlockPos)it.next();
                    IBlockState state = world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    TileEntity te = world.func_175625_s(pos);
                    if (!block.canSilkHarvest(event.getWorld(), pos, state, player)) continue;
                    it.remove();
                    block.onBlockExploded(event.getWorld(), pos, explosion);
                    ItemStack pebble = new ItemStack(ItemRegistry.SILKY_PEBBLE, 1);
                    pebble.func_77966_a(Enchantments.field_185306_r, 1);
                    block.func_180657_a(event.getWorld(), player, pos, state, te, pebble);
                }
            }
        }
    }

    @Override
    protected void explode() {
        boolean blockDamage = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        this.field_70170_p.func_72876_a((Entity)(this.field_70192_c != null ? this.field_70192_c : this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, blockDamage);
    }
}

