/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IRotSmellCapability;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleGasCloud;
import thebetweenlands.common.entity.EntitySplodeshroom;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityChiromawDroppings
extends Entity {
    private static final DataParameter<Boolean> HAS_EXPLODED = EntityDataManager.func_187226_a(EntitySplodeshroom.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> AOE_SIZE_XZ = EntityDataManager.func_187226_a(EntitySplodeshroom.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> AOE_SIZE_Y = EntityDataManager.func_187226_a(EntitySplodeshroom.class, (DataSerializer)DataSerializers.field_187193_c);
    public float prevRotationTicks = 0.0f;
    public float rotationTicks = 0.0f;
    protected EntityLivingBase thrower;
    public Entity ignoreEntity;
    private int ignoreTime;

    public EntityChiromawDroppings(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_184224_h(true);
    }

    public EntityChiromawDroppings(World world, EntityLivingBase throwerIn, double x, double y, double z) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
        this.func_184224_h(true);
        this.thrower = throwerIn;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(HAS_EXPLODED, (Object)false);
        this.field_70180_af.func_187214_a(AOE_SIZE_XZ, (Object)Float.valueOf(4.0f));
        this.field_70180_af.func_187214_a(AOE_SIZE_Y, (Object)Float.valueOf(0.5f));
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnDroppingsParticles() {
        double d0 = this.field_70165_t - (double)0.075f;
        double d1 = this.field_70163_u + this.field_70181_x;
        double d2 = this.field_70161_v - (double)0.075f;
        double d3 = this.field_70165_t + (double)0.075f;
        double d4 = this.field_70161_v + (double)0.075f;
        double d5 = this.field_70165_t;
        double d6 = this.field_70163_u + this.field_70181_x + 0.25;
        double d7 = this.field_70161_v;
        BLParticles.CHIROMAW_DROPPINGS.spawn(this.field_70170_p, d0, d1, d4, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f), this.field_70181_x + (double)(0.1f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
        BLParticles.CHIROMAW_DROPPINGS.spawn(this.field_70170_p, d3, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f), this.field_70181_x + (double)(0.1f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
        BLParticles.CHIROMAW_DROPPINGS.spawn(this.field_70170_p, d3, d1, d4, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f), this.field_70181_x + (double)(0.1f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
        BLParticles.CHIROMAW_DROPPINGS.spawn(this.field_70170_p, d0, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f), this.field_70181_x + (double)(0.1f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
        BLParticles.CHIROMAW_DROPPINGS.spawn(this.field_70170_p, d5, d6, d7, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f), this.field_70181_x + (double)(0.1f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
        BLParticles.CHIROMAW_DROPPINGS.spawn(this.field_70170_p, d0, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f), this.field_70181_x + (double)(0.1f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)0.08f * d1 * (double)(this.field_70146_Z.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevRotationTicks = this.rotationTicks;
        this.rotationTicks += 15.0f;
        float wrap = MathHelper.func_76142_g((float)this.rotationTicks) - this.rotationTicks;
        this.rotationTicks += wrap;
        this.prevRotationTicks += wrap;
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getHasExploded()) {
                if (this.func_130014_f_().func_82737_E() % 5L == 0L) {
                    this.checkAreaOfEffect();
                }
                if (this.getAOESizeXZ() > 0.5f) {
                    this.setAOESizeXZ(this.getAOESizeXZ() - 0.01f);
                }
                if (this.getAOESizeXZ() <= 0.5f) {
                    this.func_70106_y();
                }
            }
        } else if (!this.getHasExploded() && this.field_70173_aa % 4 == 0) {
            this.spawnDroppingsParticles();
        }
        if (this.getHasExploded()) {
            this.setBoundingBoxSize();
        }
        if (this.func_130014_f_().field_72995_K && this.getHasExploded()) {
            this.spawnCloudParticle();
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        Vec3d poopVector = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d poopMovementVector = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(poopVector, poopMovementVector);
        poopVector = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        poopMovementVector = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            poopMovementVector = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entityCollidedWith = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double collisionDistance = 0.0;
        boolean miss = false;
        for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
            double inpactDistance;
            Entity entityInList = (Entity)list.get(entityCount);
            if (!entityInList.func_70067_L()) continue;
            if (entityInList == this.ignoreEntity) {
                miss = true;
                continue;
            }
            if (this.thrower != null && this.field_70173_aa < 2 && this.ignoreEntity == null) {
                this.ignoreEntity = entityInList;
                miss = true;
                continue;
            }
            miss = false;
            AxisAlignedBB axisalignedbb = entityInList.func_174813_aQ().func_186662_g((double)0.3f);
            RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(poopVector, poopMovementVector);
            if (raytraceresult1 == null || !((inpactDistance = poopVector.func_72436_e(raytraceresult1.field_72307_f)) < collisionDistance) && collisionDistance != 0.0) continue;
            entityCollidedWith = entityInList;
            collisionDistance = inpactDistance;
        }
        if (this.ignoreEntity != null) {
            if (miss) {
                this.ignoreTime = 2;
            } else if (this.ignoreTime-- <= 0) {
                this.ignoreEntity = null;
            }
        }
        if (entityCollidedWith != null) {
            raytraceresult = new RayTraceResult(entityCollidedWith);
        }
        if (raytraceresult != null) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(raytraceresult.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(raytraceresult.func_178782_a());
            } else if (!ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onImpact(raytraceresult);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float fallAmount = 0.99f;
        float fallAmountWithGravity = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int particleCount = 0; particleCount < 4; ++particleCount) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            fallAmount = 0.8f;
        }
        if (this.getHasExploded()) {
            fallAmount = 0.0f;
        }
        this.field_70159_w *= (double)fallAmount;
        this.field_70181_x *= (double)fallAmount;
        this.field_70179_y *= (double)fallAmount;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)fallAmountWithGravity;
        }
        if (raytraceresult != null && this.getHasExploded() && this.field_70163_u < raytraceresult.field_72307_f.field_72448_b) {
            this.field_70163_u = raytraceresult.field_72307_f.field_72448_b;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Nullable
    protected Entity checkAreaOfEffect() {
        Entity entity = null;
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
            List list = this.func_130014_f_().func_72872_a(EntityPlayer.class, this.func_174813_aQ());
            for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
                EntityPlayer player;
                entity = (Entity)list.get(entityCount);
                if (entity == null || !(entity instanceof EntityPlayer) || (player = (EntityPlayer)entity).func_175149_v() || player.func_184812_l_()) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60));
                player.func_70690_d(ElixirEffectRegistry.EFFECT_DECAY.createEffect(40, 1));
                IRotSmellCapability capSmell = (IRotSmellCapability)player.getCapability(CapabilityRegistry.CAPABILITY_ROT_SMELL, null);
                if (capSmell == null || capSmell.isSmellingBad()) continue;
                capSmell.setSmellingBad(Math.max(capSmell.getRemainingSmellyTicks(), 24000));
            }
        }
        return entity;
    }

    protected float getGravityVelocity() {
        if (!this.getHasExploded()) {
            return 0.03f;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float smoothedAngle(float partialTicks) {
        return this.prevRotationTicks + (this.rotationTicks - this.prevRotationTicks) * partialTicks;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected void onImpact(RayTraceResult result) {
        if (!(this.getHasExploded() || result.field_72313_a == null || result.field_72313_a != RayTraceResult.Type.BLOCK && (result.field_72313_a != RayTraceResult.Type.ENTITY || result.field_72308_g instanceof EntityChiromawDroppings || result.field_72308_g == this.thrower) || this.func_130014_f_().field_72995_K)) {
            this.setHasExploded(true);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_SPLAT, SoundCategory.HOSTILE, 1.0f, 1.0f + (this.func_130014_f_().field_73012_v.nextFloat() - this.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
        }
    }

    protected void setBoundingBoxSize() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t - (double)this.getAOESizeXZ() * 0.5, this.field_70163_u, this.field_70161_v - (double)this.getAOESizeXZ() * 0.5, this.field_70165_t + (double)this.getAOESizeXZ() * 0.5, this.field_70163_u + (double)this.getAOESizeY(), this.field_70161_v + (double)this.getAOESizeXZ() * 0.5);
        this.func_174826_a(axisalignedbb);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (AOE_SIZE_XZ.equals(key)) {
            this.setAOESizeXZ(this.getAOESizeXZ());
        }
        if (AOE_SIZE_Y.equals(key)) {
            this.setAOESizeY(this.getAOESizeY());
        }
        super.func_184206_a(key);
    }

    private void setHasExploded(boolean hasExploded) {
        this.field_70180_af.func_187227_b(HAS_EXPLODED, (Object)hasExploded);
    }

    public boolean getHasExploded() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EXPLODED);
    }

    private void setAOESizeXZ(float aoeSizeXZ) {
        this.field_70180_af.func_187227_b(AOE_SIZE_XZ, (Object)Float.valueOf(aoeSizeXZ));
    }

    public float getAOESizeXZ() {
        return ((Float)this.field_70180_af.func_187225_a(AOE_SIZE_XZ)).floatValue();
    }

    private void setAOESizeY(float aoeSizeY) {
        this.field_70180_af.func_187227_b(AOE_SIZE_Y, (Object)Float.valueOf(aoeSizeY));
    }

    public float getAOESizeY() {
        return ((Float)this.field_70180_af.func_187225_a(AOE_SIZE_Y)).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCloudParticle() {
        double x = this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
        double y = this.field_70163_u + 0.1;
        double z = this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
        double mx = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 12.0f;
        double my = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f * 0.1f;
        double mz = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 12.0f;
        int[] color = new int[]{100, 100, 0, 255};
        ParticleGasCloud hazeParticle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(null)).withMotion(mx, my, mz)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f)).withScale(8.0f));
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_HEAT_HAZE, hazeParticle);
        ParticleGasCloud particle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(null)).withMotion(mx, my, mz)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f)).withScale(4.0f));
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_TEXTURED, particle);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }
}

