/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.item.tools.ItemBLFishingRod;

public class EntityBLFishHook
extends EntityFishHook
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Boolean> IS_BAITED = EntityDataManager.func_187226_a(EntityBLFishHook.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean field_146051_au;
    private int ticksInGround;
    private EntityPlayer angler;
    private int ticksInAir;
    private State currentState = State.FLYING;
    protected double interpTargetX;
    protected double interpTargetY;
    protected double interpTargetZ;
    protected int newPosRotationIncrements;

    @SideOnly(value=Side.CLIENT)
    public EntityBLFishHook(World world, EntityPlayer player, double x, double y, double z) {
        super(world, player, x, y, z);
        this.init(player);
        this.func_70107_b(x, y, z);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public EntityBLFishHook(World world, EntityPlayer player) {
        super(world, player);
        this.init(player);
        this.shoot(player);
    }

    public EntityBLFishHook(World world) {
        super(world, new EntityPlayer(world, new GameProfile(UUID.randomUUID(), "[FishHookDummy]")){

            public boolean func_175149_v() {
                return false;
            }

            public boolean func_184812_l_() {
                return false;
            }
        });
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70177_z = 0.0f;
        this.field_70125_A = 0.0f;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    private void init(EntityPlayer player) {
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
        this.angler = player;
        this.angler.field_71104_cf = this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_BAITED, (Object)false);
    }

    public EntityPlayer func_190619_l() {
        return this.angler;
    }

    public void func_191516_a(int speed) {
    }

    public void func_191517_b(int luck) {
    }

    public void shoot(EntityPlayer angler) {
        float f = angler.field_70127_C + (angler.field_70125_A - angler.field_70127_C);
        float f1 = angler.field_70126_B + (angler.field_70177_z - angler.field_70126_B);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        double d0 = angler.field_70169_q + (angler.field_70165_t - angler.field_70169_q) - (double)f3 * 0.3;
        double d1 = angler.field_70167_r + (angler.field_70163_u - angler.field_70167_r) + (double)angler.func_70047_e();
        double d2 = angler.field_70166_s + (angler.field_70161_v - angler.field_70166_s) - (double)f2 * 0.3;
        this.func_70012_b(d0, d1, d2, f1, f);
        this.field_70159_w = -f3;
        this.field_70181_x = MathHelper.func_76131_a((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f);
        this.field_70179_y = -f2;
        float f6 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70159_w *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        this.field_70181_x *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        this.field_70179_y *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        float f7 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f7) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    public void func_70071_h_() {
        EntityPlayer angler;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        if (this.field_70173_aa < 2) {
            return;
        }
        this.func_70030_z();
        if (this.currentState != State.FLYING && this.newPosRotationIncrements > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.interpTargetX - this.field_70165_t) / (double)this.newPosRotationIncrements;
            double d1 = this.field_70163_u + (this.interpTargetY - this.field_70163_u) / (double)this.newPosRotationIncrements;
            double d2 = this.field_70161_v + (this.interpTargetZ - this.field_70161_v) / (double)this.newPosRotationIncrements;
            --this.newPosRotationIncrements;
            this.func_70107_b(d0, d1, d2);
        }
        if ((angler = this.func_190619_l()) == null || angler.field_71104_cf != this) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.field_146051_au) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() == Material.field_151586_h) {
                f = BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.field_146043_c != null) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.field_70159_w *= 0.3;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.3;
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!(this.field_146051_au || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null && this.field_146043_c.field_70128_L) {
                        this.field_146043_c = null;
                        this.currentState = State.FLYING;
                    }
                    return;
                }
                if (!this.field_70170_p.field_72995_K && this.currentState == State.BOBBING) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                    double d0 = this.field_70163_u + this.field_70181_x - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.field_70181_x -= d0 * (double)this.field_70146_Z.nextFloat() * 0.2;
                }
            }
            if (iblockstate.func_185904_a() != Material.field_151586_h) {
                this.field_70181_x -= 0.03;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateRotation();
            this.field_70159_w *= 0.92;
            this.field_70181_x *= 0.92;
            this.field_70179_y *= 0.92;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void checkCollision() {
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
            this.field_146051_au = true;
        }
    }

    private boolean shouldStopFishing() {
        EntityPlayer angler = this.func_190619_l();
        if (angler == null) {
            return true;
        }
        ItemStack stack = angler.func_184614_ca();
        ItemStack stack1 = angler.func_184592_cb();
        boolean mainHandHeld = stack.func_77973_b() instanceof ItemBLFishingRod;
        boolean offHandHeld = stack1.func_77973_b() instanceof ItemBLFishingRod;
        if (!angler.field_70128_L && angler.func_70089_S() && (mainHandHeld || offHandHeld) && (int)this.func_70032_d((Entity)angler) <= 32) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void updateRotation() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    public void setBaited(boolean hasBait) {
        this.field_70180_af.func_187227_b(IS_BAITED, (Object)hasBait);
    }

    public boolean getBaited() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BAITED);
    }

    public int func_146034_e() {
        if (!this.field_70170_p.field_72995_K && this.func_190619_l() != null) {
            int i = 1;
            if (this.field_146043_c == null) {
                this.func_184527_k();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
            }
            if (this.field_146043_c != null) {
                this.func_184527_k();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                if (this.field_146043_c instanceof EntityAnadia) {
                    i = (int)Math.floor((double)((EntityAnadia)this.field_146043_c).getStrengthMods() + 0.5);
                }
            }
            if (this.field_146051_au) {
                i = 2;
            }
            return i;
        }
        return 0;
    }

    protected void func_184527_k() {
        EntityPlayer angler = this.func_190619_l();
        if (angler != null) {
            double d0 = angler.field_70165_t - this.field_70165_t;
            double d1 = angler.field_70163_u - this.field_70163_u;
            double d2 = angler.field_70161_v - this.field_70161_v;
            if (this.field_146043_c instanceof EntityAnadia) {
                EntityAnadia anadia = (EntityAnadia)this.field_146043_c;
                if (anadia.getStaminaTicks() > 0) {
                    if (!anadia.isObstructed()) {
                        anadia.setStaminaTicks(anadia.getStaminaTicks() - 2);
                    }
                    if (anadia.isObstructed()) {
                        anadia.setEscapeTicks(anadia.getEscapeTicks() - 16);
                    }
                    if (anadia.isTreasureFish() && anadia.isObstructedTreasure()) {
                        if (!anadia.getTreasureUnlocked()) {
                            anadia.playTreasureCollectedSound(angler);
                        }
                        anadia.setAsLootFish(true);
                    }
                    if (anadia.getStaminaTicks() % 40 == 0) {
                        angler.func_71024_bL().func_75113_a(8.0f);
                    }
                }
                this.field_146043_c.field_70159_w += d0 * (0.045 - (double)anadia.getStrengthMods() * 0.005);
                this.field_146043_c.field_70181_x += d1 * (0.045 - (double)anadia.getStrengthMods() * 0.005);
                this.field_146043_c.field_70179_y += d2 * (0.045 - (double)anadia.getStrengthMods() * 0.005);
            } else if (this.field_146043_c != null) {
                this.field_146043_c.field_70159_w += d0 * 0.02;
                this.field_146043_c.field_70181_x += d1 * 0.02;
                this.field_146043_c.field_70179_y += d2 * 0.02;
            } else {
                this.field_70159_w += d0 * 0.06;
                this.field_70181_x += d1 * 0.06;
                this.field_70179_y += d2 * 0.06;
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        EntityPlayer angler = this.func_190619_l();
        if (angler != null) {
            angler.field_71104_cf = null;
        }
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        EntityPlayer angler = this.func_190619_l();
        buffer.writeBoolean(angler != null);
        if (angler != null) {
            buffer.writeInt(angler.func_145782_y());
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        if (buffer.readBoolean()) {
            int entityId = buffer.readInt();
            Entity angler = this.field_70170_p.func_73045_a(entityId);
            if (angler instanceof EntityPlayer) {
                ((EntityPlayer)angler).field_71104_cf = this;
                this.angler = (EntityPlayer)angler;
            } else {
                this.angler = null;
            }
        }
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

