/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.movement;

import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import thebetweenlands.common.entity.movement.IPathObstructionAwareEntity;

public class ObstructionAwareWalkNodeProcessor<T extends EntityLiving>
extends WalkNodeProcessor {
    protected T obstructionAwareEntity;
    protected boolean startFromGround = true;
    protected boolean checkObstructions = true;
    protected int pathingSizeOffsetX;
    protected int pathingSizeOffsetY;
    protected int pathingSizeOffsetZ;
    protected EnumSet<EnumFacing> pathableFacings = EnumSet.of(EnumFacing.DOWN);

    public void setObstructionAwareEntity(T obstructionAwareEntity) {
        this.obstructionAwareEntity = obstructionAwareEntity;
    }

    public void setStartPathOnGround(boolean startFromGround) {
        this.startFromGround = startFromGround;
    }

    public void setCheckObstructions(boolean checkObstructions) {
        this.checkObstructions = checkObstructions;
    }

    public void setCanPathWalls(boolean canPathWalls) {
        if (canPathWalls) {
            this.pathableFacings.add(EnumFacing.NORTH);
            this.pathableFacings.add(EnumFacing.EAST);
            this.pathableFacings.add(EnumFacing.SOUTH);
            this.pathableFacings.add(EnumFacing.WEST);
        } else {
            this.pathableFacings.remove(EnumFacing.NORTH);
            this.pathableFacings.remove(EnumFacing.EAST);
            this.pathableFacings.remove(EnumFacing.SOUTH);
            this.pathableFacings.remove(EnumFacing.WEST);
        }
    }

    public void setCanPathCeiling(boolean canPathCeiling) {
        if (canPathCeiling) {
            this.pathableFacings.add(EnumFacing.UP);
        } else {
            this.pathableFacings.remove(EnumFacing.UP);
        }
    }

    public void func_186315_a(IBlockAccess sourceIn, EntityLiving mob) {
        super.func_186315_a(sourceIn, mob);
        this.pathingSizeOffsetX = Math.max(1, MathHelper.func_76141_d((float)(this.field_186326_b.field_70130_N / 2.0f + 1.0f)));
        this.pathingSizeOffsetY = Math.max(1, MathHelper.func_76141_d((float)(this.field_186326_b.field_70131_O + 1.0f)));
        this.pathingSizeOffsetZ = Math.max(1, MathHelper.func_76141_d((float)(this.field_186326_b.field_70130_N / 2.0f + 1.0f)));
    }

    public PathPoint func_186318_b() {
        int startPosY;
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            startPosY = (int)this.field_186326_b.func_174813_aQ().field_72338_b;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), startPosY, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            Block block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                blockpos$mutableblockpos.func_181079_c(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), ++startPosY, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
                block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            }
        } else if (this.field_186326_b.field_70122_E || !this.startFromGround) {
            startPosY = MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5));
        } else {
            BlockPos checkPos = new BlockPos((Entity)this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(checkPos).func_185904_a() == Material.field_151579_a || this.field_176169_a.func_180495_p(checkPos).func_177230_c().func_176205_b(this.field_176169_a, checkPos)) && checkPos.func_177956_o() > 0) {
                checkPos = checkPos.func_177977_b();
            }
            startPosY = checkPos.func_177984_a().func_177956_o();
        }
        BlockPos startPosXZ = new BlockPos((Entity)this.field_186326_b);
        PathNodeType nodeType = this.getPathNodeType(this.field_186326_b, startPosXZ.func_177958_n(), startPosY, startPosXZ.func_177952_p());
        if (this.field_186326_b.func_184643_a(nodeType) < 0.0f) {
            HashSet<BlockPos> startPosOptions = new HashSet<BlockPos>();
            startPosOptions.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)startPosY, this.field_186326_b.func_174813_aQ().field_72339_c));
            startPosOptions.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)startPosY, this.field_186326_b.func_174813_aQ().field_72334_f));
            startPosOptions.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)startPosY, this.field_186326_b.func_174813_aQ().field_72339_c));
            startPosOptions.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)startPosY, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos startPosOption : startPosOptions) {
                PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, startPosOption.func_177958_n(), startPosOption.func_177956_o(), startPosOption.func_177952_p());
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(startPosOption.func_177958_n(), startPosOption.func_177956_o(), startPosOption.func_177952_p());
            }
        }
        return this.func_176159_a(startPosXZ.func_177958_n(), startPosY, startPosXZ.func_177952_p());
    }

    private boolean shouldAvoidPathOptions(PathPoint[] options) {
        return options == null || options.length == 0 || (options[0] == null || options[0].field_186287_m == PathNodeType.OPEN || options[0].field_186286_l != 0.0f) && (options.length <= 1 || options[1] == null || options[1].field_186287_m == PathNodeType.OPEN || options[1].field_186286_l != 0.0f);
    }

    private boolean isPassableWithExemptions(IBlockAccess blockAccess, int x, int y, int z, @Nullable EnumSet<EnumFacing> exemptions, @Nullable EnumSet<EnumFacing> requirement, @Nullable EnumSet<EnumFacing> found) {
        if (requirement != null && found == null) {
            found = EnumSet.noneOf(EnumFacing.class);
        }
        for (int xo = 0; xo < this.field_176168_c; ++xo) {
            for (int yo = 0; yo < this.field_176165_d; ++yo) {
                for (int zo = 0; zo < this.field_176166_e; ++zo) {
                    PathNodeType nodeType = this.getPathNodeType(blockAccess, x + xo, y + yo, z + zo, exemptions, found);
                    if (nodeType == PathNodeType.OPEN || !(this.field_186326_b.func_184643_a(nodeType) >= 0.0f)) continue;
                    if (requirement != null) {
                        for (EnumFacing facing : requirement) {
                            if (!found.contains(facing)) continue;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        int k;
        EnumSet<EnumFacing> found;
        int k2;
        int openedNodeCount = 0;
        int stepHeight = 0;
        PathNodeType nodeTypeAbove = this.getPathNodeType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(nodeTypeAbove) >= 0.0f) {
            stepHeight = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos posDown = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double height = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)posDown).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)posDown).field_72337_e);
        PathPoint[] pathsPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
        PathPoint[] pathsNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, height, EnumFacing.WEST, this.checkObstructions);
        PathPoint[] pathsPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, height, EnumFacing.EAST, this.checkObstructions);
        PathPoint[] pathsNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
        for (k2 = 0; k2 < pathsPZ.length; ++k2) {
            if (pathsPZ[k2] == null || pathsPZ[k2].field_75842_i || !(pathsPZ[k2].func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[openedNodeCount++] = pathsPZ[k2];
        }
        for (k2 = 0; k2 < pathsNX.length; ++k2) {
            if (pathsNX[k2] == null || pathsNX[k2].field_75842_i || !(pathsNX[k2].func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[openedNodeCount++] = pathsNX[k2];
        }
        for (k2 = 0; k2 < pathsPX.length; ++k2) {
            if (pathsPX[k2] == null || pathsPX[k2].field_75842_i || !(pathsPX[k2].func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[openedNodeCount++] = pathsPX[k2];
        }
        for (k2 = 0; k2 < pathsNZ.length; ++k2) {
            if (pathsNZ[k2] == null || pathsNZ[k2].field_75842_i || !(pathsNZ[k2].func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[openedNodeCount++] = pathsNZ[k2];
        }
        PathPoint[] pathsNY = null;
        if (this.checkObstructions || this.pathableFacings.size() > 1) {
            boolean hasValidPath = false;
            if (this.pathableFacings.size() > 1) {
                found = EnumSet.noneOf(EnumFacing.class);
                this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.DOWN), null, found);
                hasValidPath = this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.DOWN), found, null);
            }
            if (hasValidPath) {
                pathsNY = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.DOWN, this.checkObstructions);
                for (int k3 = 0; k3 < pathsNY.length; ++k3) {
                    if (pathsNY[k3] == null || pathsNY[k3].field_75842_i || !(pathsNY[k3].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsNY[k3];
                }
            }
        }
        PathPoint[] pathsPY = null;
        if (this.pathableFacings.size() > 1) {
            found = EnumSet.noneOf(EnumFacing.class);
            this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.DOWN), null, found);
            if (this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.DOWN), found, null)) {
                pathsPY = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.UP, this.checkObstructions);
                for (int k4 = 0; k4 < pathsPY.length; ++k4) {
                    if (pathsPY[k4] == null || pathsPY[k4].field_75842_i || !(pathsPY[k4].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsPY[k4];
                }
            }
        }
        boolean avoidPathNZ = this.shouldAvoidPathOptions(pathsNZ);
        boolean avoidPathPZ = this.shouldAvoidPathOptions(pathsPZ);
        boolean avoidPathPX = this.shouldAvoidPathOptions(pathsPX);
        boolean avoidPathNX = this.shouldAvoidPathOptions(pathsNX);
        if (avoidPathNZ && avoidPathNX) {
            PathPoint[] pathsNXNZ = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
            for (k = 0; k < pathsNXNZ.length; ++k) {
                if (pathsNXNZ[k] == null || pathsNXNZ[k].field_75842_i || !(pathsNXNZ[k].func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[openedNodeCount++] = pathsNXNZ[k];
            }
        }
        if (avoidPathNZ && avoidPathPX) {
            PathPoint[] pathsPXNZ = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
            for (k = 0; k < pathsPXNZ.length; ++k) {
                if (pathsPXNZ[k] == null || pathsPXNZ[k].field_75842_i || !(pathsPXNZ[k].func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[openedNodeCount++] = pathsPXNZ[k];
            }
        }
        if (avoidPathPZ && avoidPathNX) {
            PathPoint[] pathsNXPZ = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
            for (k = 0; k < pathsNXPZ.length; ++k) {
                if (pathsNXPZ[k] == null || pathsNXPZ[k].field_75842_i || !(pathsNXPZ[k].func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[openedNodeCount++] = pathsNXPZ[k];
            }
        }
        if (avoidPathPZ && avoidPathPX) {
            PathPoint[] pathsPXPZ = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
            for (k = 0; k < pathsPXPZ.length; ++k) {
                if (pathsPXPZ[k] == null || pathsPXPZ[k].field_75842_i || !(pathsPXPZ[k].func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[openedNodeCount++] = pathsPXPZ[k];
            }
        }
        if (this.pathableFacings.size() > 1) {
            int k5;
            boolean avoidPathPY = this.shouldAvoidPathOptions(pathsPY);
            boolean avoidPathNY = this.shouldAvoidPathOptions(pathsNY);
            if (avoidPathNY && avoidPathNX && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.EAST), null, null)) {
                PathPoint[] pathsNYNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.WEST, this.checkObstructions);
                for (k5 = 0; k5 < pathsNYNX.length; ++k5) {
                    if (pathsNYNX[k5] == null || pathsNYNX[k5].field_75842_i || !(pathsNYNX[k5].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNX[k5];
                }
            }
            if (avoidPathNY && avoidPathPX && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.WEST), null, null)) {
                PathPoint[] pathsNYPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.EAST, this.checkObstructions);
                for (k5 = 0; k5 < pathsNYPX.length; ++k5) {
                    if (pathsNYPX[k5] == null || pathsNYPX[k5].field_75842_i || !(pathsNYPX[k5].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPX[k5];
                }
            }
            if (avoidPathNY && avoidPathNZ && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.SOUTH), null, null)) {
                PathPoint[] pathsNYNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
                for (k5 = 0; k5 < pathsNYNZ.length; ++k5) {
                    if (pathsNYNZ[k5] == null || pathsNYNZ[k5].field_75842_i || !(pathsNYNZ[k5].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNZ[k5];
                }
            }
            if (avoidPathNY && avoidPathPZ && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.UP, EnumFacing.NORTH), null, null)) {
                PathPoint[] pathsNYPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
                for (k5 = 0; k5 < pathsNYPZ.length; ++k5) {
                    if (pathsNYPZ[k5] == null || pathsNYPZ[k5].field_75842_i || !(pathsNYPZ[k5].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPZ[k5];
                }
            }
            if (avoidPathPY && avoidPathNX && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.DOWN, EnumFacing.EAST), null, null)) {
                PathPoint[] pathsPYNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.WEST, this.checkObstructions);
                for (k5 = 0; k5 < pathsPYNX.length; ++k5) {
                    if (pathsPYNX[k5] == null || pathsPYNX[k5].field_75842_i || !(pathsPYNX[k5].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNX[k5];
                }
            }
            if (avoidPathPY && avoidPathPX && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.DOWN, EnumFacing.WEST), null, null)) {
                PathPoint[] pathsPYPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.EAST, this.checkObstructions);
                for (k5 = 0; k5 < pathsPYPX.length; ++k5) {
                    if (pathsPYPX[k5] == null || pathsPYPX[k5].field_75842_i || !(pathsPYPX[k5].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPX[k5];
                }
            }
            if (avoidPathPY && avoidPathNZ && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.DOWN, EnumFacing.SOUTH), null, null)) {
                PathPoint[] pathsPYNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, this.checkObstructions);
                for (k5 = 0; k5 < pathsPYNZ.length; ++k5) {
                    if (pathsPYNZ[k5] == null || pathsPYNZ[k5].field_75842_i || !(pathsPYNZ[k5].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNZ[k5];
                }
            }
            if (avoidPathPY && avoidPathPZ && this.isPassableWithExemptions(this.field_176169_a, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c, EnumSet.of(EnumFacing.DOWN, EnumFacing.NORTH), null, null)) {
                PathPoint[] pathsPYPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, this.checkObstructions);
                for (k5 = 0; k5 < pathsPYPZ.length; ++k5) {
                    if (pathsPYPZ[k5] == null || pathsPYPZ[k5].field_75842_i || !(pathsPYPZ[k5].func_75829_a(targetPoint) < maxDistance)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPZ[k5];
                }
            }
        }
        return openedNodeCount;
    }

    @Nullable
    private PathPoint[] getSafePoints(int x, int y, int z, int stepHeight, double height, EnumFacing facing, boolean allowBlocked) {
        PathPoint directPathPoint = null;
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos posDown = pos.func_177977_b();
        double blockHeight = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)posDown).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)posDown).field_72337_e);
        if (blockHeight - height > 1.125) {
            return new PathPoint[0];
        }
        PathNodeType nodeType = this.getPathNodeType(this.field_186326_b, x, y, z);
        float malus = ((IPathObstructionAwareEntity)this.obstructionAwareEntity).getPathingMalus((EntityLiving)this.obstructionAwareEntity, nodeType, pos);
        double halfWidth = (double)this.field_186326_b.field_70130_N / 2.0;
        PathPoint[] result = new PathPoint[1];
        if (malus >= 0.0f && (allowBlocked || nodeType != PathNodeType.BLOCKED)) {
            directPathPoint = this.func_176159_a(x, y, z);
            directPathPoint.field_186287_m = nodeType;
            directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
            if (directPathPoint.field_186287_m == PathNodeType.BLOCKED) {
                result = new PathPoint[2];
                result[1] = directPathPoint;
                directPathPoint = null;
            }
        }
        if (nodeType == PathNodeType.WALKABLE) {
            result[0] = directPathPoint;
            return result;
        }
        if (directPathPoint == null && stepHeight > 0 && nodeType != PathNodeType.FENCE && nodeType != PathNodeType.TRAPDOOR && facing.func_176740_k() != EnumFacing.Axis.Y) {
            PathPoint[] pointsAbove = this.getSafePoints(x, y + 1, z, stepHeight - 1, height, facing, false);
            PathPoint pathPoint = directPathPoint = pointsAbove.length > 0 ? pointsAbove[0] : null;
            if (directPathPoint != null && (directPathPoint.field_186287_m == PathNodeType.OPEN || directPathPoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f) {
                double offsetX = (double)(x - facing.func_82601_c()) + 0.5;
                double offsetZ = (double)(z - facing.func_82599_e()) + 0.5;
                AxisAlignedBB checkAabb = new AxisAlignedBB(offsetX - halfWidth, (double)y + 0.001, offsetZ - halfWidth, offsetX + halfWidth, (double)((float)y + this.field_186326_b.field_70131_O), offsetZ + halfWidth);
                AxisAlignedBB blockAabb = this.field_176169_a.func_180495_p(pos).func_185900_c(this.field_176169_a, pos);
                AxisAlignedBB enclosingAabb = checkAabb.func_72321_a(0.0, blockAabb.field_72337_e - 0.002, 0.0);
                if (this.field_186326_b.field_70170_p.func_184143_b(enclosingAabb)) {
                    directPathPoint = null;
                }
            }
        }
        if (nodeType == PathNodeType.OPEN) {
            float bridingMalus;
            AxisAlignedBB checkAabb = new AxisAlignedBB((double)x - halfWidth + 0.5, (double)y + 0.001, (double)z - halfWidth + 0.5, (double)x + halfWidth + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + halfWidth + 0.5);
            if (this.field_186326_b.field_70170_p.func_184143_b(checkAabb)) {
                result[0] = null;
                return result;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f) {
                for (EnumFacing pathableFacing : this.pathableFacings) {
                    PathNodeType nodeTypeAtFacing = this.getPathNodeType(this.field_186326_b, x + pathableFacing.func_82601_c() * this.pathingSizeOffsetX, y + (pathableFacing == EnumFacing.DOWN ? -1 : (pathableFacing == EnumFacing.UP ? this.pathingSizeOffsetY : 0)), z + pathableFacing.func_82599_e() * this.pathingSizeOffsetZ);
                    if (nodeTypeAtFacing != PathNodeType.BLOCKED) continue;
                    directPathPoint = this.func_176159_a(x, y, z);
                    directPathPoint.field_186287_m = PathNodeType.WALKABLE;
                    directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
                    result[0] = directPathPoint;
                    return result;
                }
            }
            boolean cancelFallDown = false;
            PathPoint fallPathPoint = null;
            int fallDistance = 0;
            int preFallY = y;
            while (y > 0 && nodeType == PathNodeType.OPEN) {
                if (fallDistance++ >= this.field_186326_b.func_82143_as() || --y == 0) {
                    cancelFallDown = true;
                    break;
                }
                nodeType = this.getPathNodeType(this.field_186326_b, x, y, z);
                malus = this.field_186326_b.func_184643_a(nodeType);
                if (nodeType != PathNodeType.OPEN && malus >= 0.0f) {
                    fallPathPoint = this.func_176159_a(x, y, z);
                    fallPathPoint.field_186287_m = nodeType;
                    fallPathPoint.field_186286_l = Math.max(fallPathPoint.field_186286_l, malus);
                    break;
                }
                if (!(malus < 0.0f)) continue;
                cancelFallDown = true;
            }
            boolean hasPathUp = false;
            if (this.pathableFacings.size() > 1) {
                nodeType = this.getPathNodeType(this.field_186326_b, x, preFallY, z);
                malus = this.field_186326_b.func_184643_a(nodeType);
                if (nodeType != PathNodeType.OPEN && malus >= 0.0f) {
                    if (fallPathPoint != null) {
                        result = new PathPoint[2];
                        result[1] = fallPathPoint;
                    }
                    result[0] = directPathPoint = this.func_176159_a(x, preFallY, z);
                    directPathPoint.field_186287_m = nodeType;
                    directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
                    hasPathUp = true;
                }
            }
            if (fallPathPoint != null) {
                if (!hasPathUp) {
                    result[0] = directPathPoint = fallPathPoint;
                } else {
                    result = new PathPoint[]{directPathPoint, fallPathPoint};
                }
            }
            if (fallPathPoint != null && (bridingMalus = ((IPathObstructionAwareEntity)this.obstructionAwareEntity).getBridgePathingMalus((EntityLiving)this.obstructionAwareEntity, new BlockPos(x, preFallY, z), fallPathPoint)) >= 0.0f) {
                result = new PathPoint[2];
                result[0] = directPathPoint;
                PathPoint bridgePathPoint = this.func_176159_a(x, preFallY, z);
                bridgePathPoint.field_186287_m = PathNodeType.WALKABLE;
                bridgePathPoint.field_186286_l = Math.max(bridgePathPoint.field_186286_l, bridingMalus);
                result[1] = bridgePathPoint;
            }
            if (cancelFallDown && !hasPathUp) {
                result[0] = null;
                if (result.length == 2) {
                    result[1] = null;
                }
                return result;
            }
        }
        result[0] = directPathPoint;
        return result;
    }

    private PathNodeType getPathNodeType(EntityLiving entitylivingIn, int x, int y, int z) {
        return this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    public PathNodeType func_186330_a(IBlockAccess blockaccessIn, int x, int y, int z) {
        return this.getPathNodeType(blockaccessIn, x, y, z, EnumSet.noneOf(EnumFacing.class), null);
    }

    protected PathNodeType getPathNodeType(IBlockAccess blockaccessIn, int x, int y, int z, @Nullable EnumSet<EnumFacing> exemptions, @Nullable EnumSet<EnumFacing> found) {
        PathNodeType nodeType = this.func_189553_b(blockaccessIn, x, y, z);
        if (nodeType == PathNodeType.OPEN && y >= 1) {
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
            block0: for (EnumFacing pathableFacing : this.pathableFacings) {
                if (exemptions != null && exemptions.contains(pathableFacing)) continue;
                int checkHeight = pathableFacing.func_176740_k() != EnumFacing.Axis.Y ? Math.min(4, this.pathingSizeOffsetY - 1) : 0;
                int cx = x + pathableFacing.func_82601_c() * this.pathingSizeOffsetX;
                int cy = y + (pathableFacing == EnumFacing.DOWN ? -1 : (pathableFacing == EnumFacing.UP ? this.pathingSizeOffsetY : 0));
                int cz = z + pathableFacing.func_82599_e() * this.pathingSizeOffsetZ;
                for (int yo = 0; yo <= checkHeight; ++yo) {
                    pos.func_181079_c(cx, cy + yo, cz);
                    Block block = blockaccessIn.func_180495_p((BlockPos)pos).func_177230_c();
                    PathNodeType offsetNodeType = this.func_189553_b(blockaccessIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    PathNodeType pathNodeType = nodeType = offsetNodeType != PathNodeType.WALKABLE && offsetNodeType != PathNodeType.OPEN && offsetNodeType != PathNodeType.WATER && offsetNodeType != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
                    if (offsetNodeType == PathNodeType.DAMAGE_FIRE || block == Blocks.field_189877_df) {
                        nodeType = PathNodeType.DAMAGE_FIRE;
                    }
                    if (offsetNodeType == PathNodeType.DAMAGE_CACTUS) {
                        nodeType = PathNodeType.DAMAGE_CACTUS;
                    }
                    if (nodeType != PathNodeType.WALKABLE) continue;
                    if (found == null) break block0;
                    found.add(pathableFacing);
                    break block0;
                }
            }
            pos.func_185344_t();
        }
        nodeType = this.func_193578_a(blockaccessIn, x, y, z, nodeType);
        return nodeType;
    }

    public PathNodeType func_186319_a(IBlockAccess blockaccessIn, int x, int y, int z, EntityLiving entity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        BlockPos pos = new BlockPos((Entity)entity);
        EnumSet<PathNodeType> applicablePathNodeTypes = EnumSet.noneOf(PathNodeType.class);
        PathNodeType centerPathNodeType = this.func_193577_a(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, applicablePathNodeTypes, PathNodeType.BLOCKED, pos);
        if (applicablePathNodeTypes.contains(PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType selectedPathNodeType = PathNodeType.BLOCKED;
        for (PathNodeType applicablePathNodeType : applicablePathNodeTypes) {
            float p2;
            if (entity.func_184643_a(applicablePathNodeType) < 0.0f) {
                return applicablePathNodeType;
            }
            float p1 = entity.func_184643_a(applicablePathNodeType);
            if (!(p1 > (p2 = entity.func_184643_a(selectedPathNodeType))) && (p1 != p2 || selectedPathNodeType == PathNodeType.WALKABLE && applicablePathNodeType == PathNodeType.OPEN) && (p1 != p2 || selectedPathNodeType != PathNodeType.OPEN || applicablePathNodeType != PathNodeType.WALKABLE)) continue;
            selectedPathNodeType = applicablePathNodeType;
        }
        if (centerPathNodeType == PathNodeType.OPEN && entity.func_184643_a(selectedPathNodeType) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return selectedPathNodeType;
    }
}

