/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.movement;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FlightMoveHelper
extends EntityMoveHelper {
    protected int courseChangeCooldown;
    protected boolean blocked = false;

    public FlightMoveHelper(EntityLiving entity) {
        super(entity);
    }

    public void func_75641_c() {
        IAttributeInstance entityMoveSpeedAttribute = this.field_75648_a.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        double entityMoveSpeed = entityMoveSpeedAttribute != null ? entityMoveSpeedAttribute.func_111126_e() : 1.0;
        double speed = this.getFlightSpeed() * entityMoveSpeed;
        if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
            double dx = this.field_75646_b - this.field_75648_a.field_70165_t;
            double dy = this.field_75647_c - this.field_75648_a.field_70163_u;
            double dz = this.field_75644_d - this.field_75648_a.field_70161_v;
            double dist = dx * dx + dy * dy + dz * dz;
            if (this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.getCourseChangeCooldown();
                if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, dist = (double)MathHelper.func_76133_a((double)dist))) {
                    if (dist < (double)this.field_75648_a.field_70130_N + speed) {
                        speed *= dist / ((double)this.field_75648_a.field_70130_N + speed);
                    }
                    if (dist < 0.01) {
                        this.field_75648_a.func_191989_p(0.0f);
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    } else {
                        this.field_75648_a.field_70159_w += dx / dist * speed;
                        this.field_75648_a.field_70181_x += dy / dist * speed;
                        this.field_75648_a.field_70179_y += dz / dist * speed;
                        float yaw = (float)(MathHelper.func_181159_b((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                        this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, yaw, 90.0f);
                        this.field_75648_a.func_70659_e((float)speed);
                    }
                    this.blocked = false;
                } else {
                    this.blocked = true;
                }
                if (this.blocked) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            }
        } else if (this.field_188491_h == EntityMoveHelper.Action.STRAFE) {
            float forward = this.field_188489_f;
            float strafe = this.field_188490_g;
            float dist = MathHelper.func_76129_c((float)(forward * forward + strafe * strafe));
            float rotX = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
            float rotZ = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
            float strafeX = strafe * rotZ - forward * rotX;
            float strafeZ = forward * rotZ + strafe * rotX;
            this.field_75648_a.field_70159_w += (double)(strafeX / dist) * speed * 0.15;
            this.field_75648_a.field_70179_y += (double)(strafeZ / dist) * speed * 0.15;
            this.field_75648_a.func_70659_e((float)speed);
            this.field_75648_a.func_191989_p(this.field_188489_f);
            this.field_75648_a.func_184646_p(this.field_188490_g);
            this.field_188491_h = EntityMoveHelper.Action.WAIT;
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    protected int getCourseChangeCooldown() {
        return this.field_75648_a.func_70681_au().nextInt(5) + 2;
    }

    protected boolean isNotColliding(double x, double y, double z, double step) {
        if (this.field_75648_a.field_70145_X) {
            return true;
        }
        double stepX = (x - this.field_75648_a.field_70165_t) / step;
        double stepY = (y - this.field_75648_a.field_70163_u) / step;
        double stepZ = (z - this.field_75648_a.field_70161_v) / step;
        AxisAlignedBB aabb = this.field_75648_a.func_174813_aQ();
        int i = 1;
        while ((double)i < step) {
            if (this.isBlocked(aabb = aabb.func_72317_d(stepX, stepY, stepZ))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isBlocked(AxisAlignedBB aabb) {
        return false;
    }

    protected double getFlightSpeed() {
        return this.field_75645_e;
    }

    public static BlockPos getGroundHeight(World world, BlockPos pos, int maxIter, BlockPos fallback) {
        int i;
        if (world.func_175678_i(pos)) {
            return world.func_175645_m(pos);
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (i = 0; i < maxIter; ++i) {
            mutablePos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - i, pos.func_177952_p());
            if (!world.func_175623_d((BlockPos)mutablePos)) break;
        }
        if (i < maxIter) {
            return new BlockPos(pos.func_177958_n(), pos.func_177956_o() - i, pos.func_177952_p());
        }
        return fallback;
    }
}

