/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.item.equipment.ItemRingOfSummoning;

public class EntityMummyArm
extends EntityCreature
implements IEntityBL,
IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> OWNER_ID = EntityDataManager.func_187226_a(EntityMummyArm.class, (DataSerializer)DataSerializers.field_187192_b);
    private Entity owner;
    private UUID ownerUUID;
    public int attackSwing = 0;
    private int spawnTicks = 0;
    private int despawnTicks = 0;
    private int deathTicks = 0;
    private double yOffset = 0.0;

    public EntityMummyArm(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.7f);
    }

    public EntityMummyArm(World world, EntityPlayer player) {
        super(world);
        this.func_70105_a(0.7f, 0.7f);
        this.setPlayerOwner(player);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER_ID, (Object)-1);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance diff, IEntityLivingData data) {
        this.field_70177_z = this.field_70170_p.field_73012_v.nextFloat() * 360.0f;
        return data;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void setPlayerOwner(@Nullable EntityPlayer owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.func_110124_au();
        this.func_184212_Q().func_187227_b(OWNER_ID, (Object)(owner == null ? -1 : owner.func_145782_y()));
    }

    public boolean hasPlayerOwner() {
        return this.ownerUUID != null;
    }

    @Nullable
    public Entity getPlayerOwner() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.owner != null && this.owner.func_110124_au().equals(this.ownerUUID)) {
                return this.owner;
            }
            this.owner = this.ownerUUID == null ? null : this.getEntityByUUID(this.ownerUUID);
            return this.owner;
        }
        if (this.owner != null && this.owner.func_145782_y() != ((Integer)this.func_184212_Q().func_187225_a(OWNER_ID)).intValue()) {
            return this.owner;
        }
        int id = (Integer)this.func_184212_Q().func_187225_a(OWNER_ID);
        this.owner = id < 0 ? null : this.field_70170_p.func_73045_a(id);
        return this.owner;
    }

    private Entity getEntityByUUID(UUID uuid) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos pos = this.func_180425_c().func_177979_c(1);
        IBlockState blockState = this.field_70170_p.func_180495_p(pos);
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer player;
            if (blockState.func_177230_c() == Blocks.field_150350_a || this.hasPlayerOwner() && !blockState.isSideSolid((IBlockAccess)this.field_70170_p, pos, EnumFacing.UP)) {
                this.func_70106_y();
            }
            Entity owner = this.getPlayerOwner();
            if (this.hasPlayerOwner() && (owner == null || (double)owner.func_70032_d((Entity)this) > 32.0)) {
                this.func_70606_j(0.0f);
            } else if (owner instanceof EntityPlayer && !ItemRingOfSummoning.isRingActive((Entity)(player = (EntityPlayer)owner))) {
                this.func_70606_j(0.0f);
            }
            if (this.despawnTicks >= 150) {
                this.func_70606_j(0.0f);
            } else if (this.spawnTicks >= 40) {
                ++this.despawnTicks;
            }
        }
        if (this.deathTicks > 0) {
            this.yOffset = (float)(-this.deathTicks) / 40.0f;
        } else if (this.spawnTicks >= 40) {
            this.yOffset = 0.0;
        }
        if (this.func_70089_S()) {
            if (this.spawnTicks >= 4) {
                List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
                for (EntityLivingBase target : targets) {
                    boolean isValidTarget = this.hasPlayerOwner() ? target != this && target != this.getPlayerOwner() && (target instanceof EntityMob || target instanceof IMob) : target instanceof EntityPlayer;
                    if (!isValidTarget) continue;
                    target.func_70110_aj();
                    if (target.field_70172_ad >= 10) continue;
                    Entity owner = this.getPlayerOwner();
                    Object damageSource = owner != null ? new EntityDamageSourceIndirect("mob", (Entity)this, owner) : DamageSource.func_76358_a((EntityLivingBase)this);
                    target.func_70097_a(damageSource, (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    if (this.attackSwing > 0) continue;
                    this.attackSwing = 20;
                }
            }
            if (this.spawnTicks < 40) {
                ++this.spawnTicks;
                this.yOffset = -1.0f + (float)this.spawnTicks / 40.0f;
            } else {
                this.yOffset = 0.0;
            }
            if (this.attackSwing > 0) {
                --this.attackSwing;
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(this.yOffset < 0.0 ? 2 : 8) == 0 && blockState.func_177230_c() != Blocks.field_150350_a) {
            double px = this.field_70165_t;
            double py = this.field_70163_u;
            double pz = this.field_70161_v;
            int amount = 2 + this.field_70146_Z.nextInt(this.yOffset < 0.0 ? 8 : 3);
            for (int i = 0; i < amount; ++i) {
                double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                double motionY = this.field_70146_Z.nextDouble() * 0.1 + 0.1;
                double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)blockState)});
            }
        }
    }

    public void func_191986_a(float strafe, float up, float forward) {
    }

    public void func_70108_f(Entity entity) {
    }

    protected void func_82167_n(Entity entity) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70033_W() {
        return this.yOffset;
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (!this.field_70170_p.field_72995_K && this.deathTicks >= 40) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.ownerUUID != null) {
            nbt.func_186854_a("ownerUUID", this.ownerUUID);
        }
        nbt.func_74768_a("spawnTicks", this.spawnTicks);
        nbt.func_74768_a("despawnTicks", this.despawnTicks);
        nbt.func_74768_a("deathTicks", this.deathTicks);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_186855_b("ownerUUID")) {
            this.ownerUUID = nbt.func_186857_a("ownerUUID");
        }
        this.spawnTicks = nbt.func_74762_e("spawnTicks");
        this.despawnTicks = nbt.func_74762_e("despawnTicks");
        this.deathTicks = nbt.func_74762_e("deathTicks");
    }

    public void writeSpawnData(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.writeBoolean(this.ownerUUID != null);
        if (this.ownerUUID != null) {
            packet.func_179252_a(this.ownerUUID);
        }
    }

    public void readSpawnData(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        this.ownerUUID = packet.readBoolean() ? packet.func_179253_g() : null;
    }
}

