/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMultipartDummy
extends Entity {
    protected float sizePadding = 0.01f;
    public static final DataParameter<String> PARENT_PART_NAME = EntityDataManager.func_187226_a(EntityMultipartDummy.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> PARENT_OWNER_ID = EntityDataManager.func_187226_a(EntityMultipartDummy.class, (DataSerializer)DataSerializers.field_187192_b);
    private int cachedPartOwnerId = -1;
    private String cachedParentPartName = "";
    private MultiPartEntityPart parent = null;

    public EntityMultipartDummy(World world) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
    }

    public EntityMultipartDummy(World world, MultiPartEntityPart parent) {
        this(world);
        this.parent = parent;
        this.func_70107_b(parent.field_70165_t, parent.field_70163_u, parent.field_70161_v);
    }

    public void updatePositioning() {
        if (!this.field_70170_p.field_72995_K && this.parent != null) {
            this.field_70180_af.func_187227_b(PARENT_OWNER_ID, (Object)(this.parent.field_70259_a instanceof Entity ? ((Entity)this.parent.field_70259_a).func_145782_y() : -1));
            this.field_70180_af.func_187227_b(PARENT_PART_NAME, (Object)this.parent.field_146032_b);
        }
        if (this.field_70170_p.field_72995_K) {
            Entity parentOwner;
            int partOwnerId = (Integer)this.field_70180_af.func_187225_a(PARENT_OWNER_ID);
            String parentPartName = (String)this.field_70180_af.func_187225_a(PARENT_PART_NAME);
            if (!(partOwnerId < 0 || parentPartName.length() <= 0 || this.cachedPartOwnerId == partOwnerId && this.cachedParentPartName.equals(parentPartName) || (parentOwner = this.field_70170_p.func_73045_a(partOwnerId)) == null)) {
                for (Entity part : parentOwner.func_70021_al()) {
                    if (!(part instanceof MultiPartEntityPart) || !parentPartName.equals(((MultiPartEntityPart)part).field_146032_b)) continue;
                    this.parent = (MultiPartEntityPart)part;
                    this.cachedPartOwnerId = partOwnerId;
                    this.cachedParentPartName = parentPartName;
                }
            }
        }
        if (!(this.parent != null && this.parent.field_70259_a instanceof Entity && this.parent.func_70089_S() && ((Entity)this.parent.field_70259_a).func_70089_S())) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        } else {
            this.func_70105_a(this.parent.field_70130_N + this.sizePadding, this.parent.field_70131_O + this.sizePadding);
            this.func_70634_a(this.parent.field_70165_t, this.parent.field_70163_u - (double)(this.sizePadding / 2.0f), this.parent.field_70161_v);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PARENT_PART_NAME, (Object)"");
        this.field_70180_af.func_187214_a(PARENT_OWNER_ID, (Object)-1);
    }

    public MultiPartEntityPart getParent() {
        return this.parent;
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70142_S = this.field_70165_t;
        this.field_70167_r = this.field_70137_T = this.field_70163_u;
        this.field_70166_s = this.field_70136_U = this.field_70161_v;
        this.updatePositioning();
        this.field_70148_d = false;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.parent != null) {
            return this.parent.func_184230_a(player, hand);
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.parent != null) {
            return this.parent.func_70097_a(source, amount);
        }
        return false;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean func_174814_R() {
        return true;
    }

    public boolean func_82150_aj() {
        return true;
    }

    public boolean func_190530_aW() {
        if (this.parent != null) {
            return this.parent.func_190530_aW();
        }
        return true;
    }

    public boolean func_70075_an() {
        if (this.parent != null) {
            return this.parent.func_70075_an();
        }
        return true;
    }

    public boolean func_70067_L() {
        if (this.parent != null) {
            return this.parent.func_70067_L();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        if (this.parent != null) {
            return this.parent.func_184177_bl();
        }
        return super.func_184177_bl();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        if (this.parent != null) {
            return this.parent.func_145770_h(x, y, z);
        }
        return super.func_145770_h(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        if (this.parent != null) {
            return this.parent.func_70112_a(distance);
        }
        return super.func_70112_a(distance);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }
}

