/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.EntityFishBait;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.ai.EntityAINearestAttackableSmellyTarget;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.mobs.EntityAngler;
import thebetweenlands.common.entity.mobs.EntityDragonFly;
import thebetweenlands.common.entity.mobs.EntityFreshwaterUrchin;
import thebetweenlands.common.entity.mobs.EntityJellyfish;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.MathUtils;

public class EntityLurker
extends EntityCreature
implements IEntityBL,
IMob,
IAnimals {
    private static final DataParameter<Boolean> IS_LEAPING = EntityDataManager.func_187226_a(EntityLurker.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SHOULD_MOUTH_BE_OPEN = EntityDataManager.func_187226_a(EntityLurker.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> MOUTH_MOVE_SPEED = EntityDataManager.func_187226_a(EntityLurker.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final int MOUTH_OPEN_TICKS = 20;
    private int attackTime;
    private float prevRotationPitchBody;
    private float rotationPitchBody;
    private float prevTailYaw;
    private float tailYaw;
    private float prevTailPitch;
    private float tailPitch;
    private float prevMouthOpenTicks;
    private float mouthOpenTicks;
    private int ticksUntilBiteDamage = -1;
    private Entity entityBeingBit;
    private int anger;
    public int huntingTimer;
    private boolean prevInWater;
    private int leapRiseTime;
    private int leapFallTime;
    private EntityMoveHelper moveHelperWater;
    private EntityMoveHelper moveHelperLand;
    private PathNavigateGround pathNavigatorGround;
    private PathNavigateSwimmer pathNavigatorWater;
    public AIFindBait aiFindBait;

    public EntityLurker(World world) {
        super(world);
        this.field_70728_aV = 5;
        this.func_184644_a(PathNodeType.WATER, 30.0f);
        this.moveHelperWater = new LurkerMoveHelper(this);
        this.moveHelperLand = new EntityMoveHelper((EntityLiving)this);
        this.pathNavigatorGround = new PathNavigateGround((EntityLiving)this, this.field_70170_p);
        this.pathNavigatorGround.func_179693_d(true);
        this.pathNavigatorWater = new PathNavigateSwimmer((EntityLiving)this, this.field_70170_p);
        this.updateMovementAndPathfinding();
        this.func_70105_a(1.6f, 0.9f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic(this, 1.5){

            public boolean func_75250_a() {
                return super.func_75250_a() && EntityLurker.this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL;
            }
        });
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7, 80));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.aiFindBait = new AIFindBait(this, 8.0);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFindBait);
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, new EntityAINearestAttackableSmellyTarget<EntityPlayer>(this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDragonFly.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAngler.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(this, EntityAnadia.class, true){

            public boolean func_75250_a() {
                return super.func_75250_a() && EntityLurker.this.huntingTimer <= 0;
            }
        });
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(this, EntityJellyfish.class, true){

            public boolean func_75250_a() {
                return super.func_75250_a() && EntityLurker.this.huntingTimer <= 0;
            }
        });
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(this, EntityFreshwaterUrchin.class, true){

            public boolean func_75250_a() {
                return super.func_75250_a() && EntityLurker.this.huntingTimer <= 0;
            }
        });
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LEAPING, (Object)false);
        this.field_70180_af.func_187214_a(SHOULD_MOUTH_BE_OPEN, (Object)false);
        this.field_70180_af.func_187214_a(MOUTH_MOVE_SPEED, (Object)Float.valueOf(1.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(55.0);
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public boolean func_70090_H() {
        return this.func_130014_f_().func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
    }

    private Block getRelativeBlock(int offsetY) {
        return this.func_130014_f_().func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + offsetY, MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70090_H()) {
            if (!this.func_130014_f_().field_72995_K && this.field_70181_x < 0.0 && this.isLeaping()) {
                this.setIsLeaping(false);
            }
        } else if (this.func_130014_f_().field_72995_K) {
            if (this.prevInWater && this.isLeaping()) {
                this.breachWater();
            }
        } else if (this.field_70122_E) {
            this.setIsLeaping(false);
        } else {
            this.field_70159_w *= 0.4;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.4;
        }
        if (this.isLeaping()) {
            ++this.leapRiseTime;
            if (!this.func_130014_f_().field_72995_K) {
                this.field_70177_z += 10.0f;
            }
        } else {
            if (this.leapRiseTime > 0 && this.leapFallTime == this.leapRiseTime) {
                this.leapRiseTime = 0;
                this.leapFallTime = 0;
            }
            if (this.leapFallTime < this.leapRiseTime) {
                ++this.leapFallTime;
            }
        }
        float magnitude = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * (float)(!this.field_70122_E ? 1 : 0);
        float motionPitch = MathHelper.func_76131_a((float)((float)Math.atan2(magnitude, this.field_70181_x) / (float)Math.PI * 180.0f - 90.0f), (float)-10.0f, (float)10.0f);
        if (magnitude > 1.0f) {
            magnitude = 1.0f;
        }
        float newRotationPitch = this.isLeaping() ? 90.0f : (this.leapFallTime > 0 ? -45.0f : MathHelper.func_76131_a((float)((this.rotationPitchBody - motionPitch) * magnitude * 4.0f * (float)(this.field_70171_ac ? 1 : 0)), (float)-30.0f, (float)30.0f));
        this.tailPitch += (this.rotationPitchBody - newRotationPitch) * 0.75f;
        this.rotationPitchBody += (newRotationPitch - this.rotationPitchBody) * 0.3f;
        if (Math.abs(this.rotationPitchBody) < 0.05f) {
            this.rotationPitchBody = 0.0f;
        }
    }

    private void breachWater() {
        int ring = 2;
        int waterColorMultiplier = this.getWaterColor();
        while (ring-- > 0) {
            int particleCount = ring * 12 + 20 + this.field_70146_Z.nextInt(10);
            for (int p = 0; p < particleCount; ++p) {
                float theta = (float)p / (float)particleCount * ((float)Math.PI * 2);
                float dx = MathHelper.func_76134_b((float)theta);
                float dz = MathHelper.func_76126_a((float)theta);
                double x = this.field_70165_t + (double)(dx * (float)ring * 1.0f) * MathUtils.linearTransformd(this.field_70146_Z.nextDouble(), 0.0, 1.0, 0.6, 1.2) + this.field_70146_Z.nextDouble() * 0.3 - 0.15;
                double y = this.field_70163_u - this.field_70146_Z.nextDouble() * 0.2;
                double z = this.field_70161_v + (double)(dz * (float)ring * 1.0f) * MathUtils.linearTransformd(this.field_70146_Z.nextDouble(), 0.0, 1.0, 0.6, 1.2) + this.field_70146_Z.nextDouble() * 0.3 - 0.15;
                double motionX = dx * MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, 0.03f, 0.2f);
                double motionY = (double)((float)ring * 0.3f) + this.field_70146_Z.nextDouble() * 0.1;
                double motionZ = dz * MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, 0.03f, 0.2f);
                BLParticles.SPLASH.spawn(this.func_130014_f_(), x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(motionX, motionY, motionZ)).withColor(waterColorMultiplier));
            }
        }
    }

    private int getWaterColor() {
        int blockX = MathHelper.func_76128_c((double)this.field_70165_t);
        int blockZ = MathHelper.func_76128_c((double)this.field_70161_v);
        int y = 0;
        while (this.getRelativeBlock(y--) == Blocks.field_150350_a && this.field_70163_u - (double)y > 0.0) {
        }
        int blockY = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72338_b + (double)y));
        IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(blockX, blockY, blockZ));
        if (blockState.func_185904_a().func_76224_d()) {
            int r = 255;
            int g = 255;
            int b = 255;
            if (blockState.func_177230_c() == BlockRegistry.SWAMP_WATER) {
                r = 147;
                g = 132;
                b = 83;
            } else if (blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150358_i) {
                r = 49;
                g = 70;
                b = 245;
            } else if (blockState.func_177230_c() == Blocks.field_150353_l || blockState.func_177230_c() == Blocks.field_150356_k) {
                r = 207;
                g = 85;
                b = 16;
            }
            int multiplier = blockState.func_185909_g((IBlockAccess)this.func_130014_f_(), new BlockPos(blockX, blockY, blockZ)).func_151643_b(1);
            return 0xFF000000 | r * (multiplier >> 16 & 0xFF) / 255 << 16 | g * (multiplier >> 8 & 0xFF) / 255 << 8 | b * (multiplier & 0xFF) / 255;
        }
        return -1;
    }

    protected void updateMovementAndPathfinding() {
        this.field_70765_h = this.func_70090_H() ? this.moveHelperWater : this.moveHelperLand;
        this.field_70699_by = this.func_70090_H() && !this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72337_e + 0.25, this.field_70161_v)) ? this.pathNavigatorWater : this.pathNavigatorGround;
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return;
        }
        super.func_70624_b(entity);
    }

    public void func_70071_h_() {
        float movementSpeed;
        EntityLivingBase target;
        this.updateMovementAndPathfinding();
        if (!this.func_130014_f_().field_72995_K && (target = this.func_70638_az()) instanceof EntityDragonFly && this.attackTime <= 0 && (double)target.func_70032_d((Entity)this) < 3.2 && target.func_174813_aQ().field_72337_e >= this.func_174813_aQ().field_72338_b && target.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72337_e && this.ticksUntilBiteDamage == -1) {
            this.setShouldMouthBeOpen(true);
            this.setMouthMoveSpeed(10.0f);
            this.ticksUntilBiteDamage = 10;
            this.attackTime = 20;
            this.entityBeingBit = target;
            if (this.isLeaping() && target instanceof EntityDragonFly) {
                target.func_184205_a((Entity)this, true);
                this.func_70624_b((EntityLivingBase)((EntityDragonFly)target));
            }
        }
        this.prevRotationPitchBody = this.rotationPitchBody;
        this.prevTailPitch = this.tailPitch;
        this.prevTailYaw = this.tailYaw;
        while (this.rotationPitchBody - this.prevRotationPitchBody < -180.0f) {
            this.prevRotationPitchBody -= 360.0f;
        }
        while (this.rotationPitchBody - this.prevRotationPitchBody >= 180.0f) {
            this.prevRotationPitchBody += 360.0f;
        }
        while (this.tailPitch - this.prevTailPitch < -180.0f) {
            this.prevTailPitch -= 360.0f;
        }
        while (this.tailPitch - this.prevTailPitch >= 180.0f) {
            this.prevTailPitch += 360.0f;
        }
        while (this.tailYaw - this.prevTailYaw < -180.0f) {
            this.prevTailYaw -= 360.0f;
        }
        while (this.tailYaw - this.prevTailYaw >= 180.0f) {
            this.prevTailYaw += 360.0f;
        }
        this.prevMouthOpenTicks = this.mouthOpenTicks;
        this.prevInWater = this.field_70171_ac;
        super.func_70071_h_();
        if (this.shouldMouthBeOpen()) {
            if (this.mouthOpenTicks < 20.0f) {
                this.mouthOpenTicks += this.getMouthMoveSpeed();
            }
            if (this.mouthOpenTicks > 20.0f) {
                this.mouthOpenTicks = 20.0f;
            }
        } else {
            if (this.mouthOpenTicks > 0.0f) {
                this.mouthOpenTicks -= this.getMouthMoveSpeed();
            }
            if (this.mouthOpenTicks < 0.0f) {
                this.mouthOpenTicks = 0.0f;
            }
        }
        if (this.ticksUntilBiteDamage > -1) {
            --this.ticksUntilBiteDamage;
            if (this.ticksUntilBiteDamage == -1) {
                this.setShouldMouthBeOpen(false);
                if (this.entityBeingBit != null) {
                    if (!this.entityBeingBit.field_70128_L) {
                        EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, this.entityBeingBit);
                        if (this.func_184187_bx() == this.entityBeingBit) {
                            this.func_184187_bx().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), ((EntityLivingBase)this.entityBeingBit).func_110138_aP());
                        }
                    }
                    this.entityBeingBit = null;
                }
            }
        }
        if ((movementSpeed = MathHelper.func_76133_a((double)((this.field_70169_q - this.field_70165_t) * (this.field_70169_q - this.field_70165_t) + (this.field_70167_r - this.field_70163_u) * (this.field_70167_r - this.field_70163_u) + (this.field_70166_s - this.field_70161_v) * (this.field_70166_s - this.field_70161_v)))) > 1.0f) {
            movementSpeed = 1.0f;
        } else if ((double)movementSpeed < 0.08) {
            movementSpeed = 0.0f;
        }
        if (Math.abs(this.tailYaw) < 90.0f) {
            this.tailYaw += this.field_70760_ar - this.field_70761_aq;
        }
        if (Math.abs(this.tailPitch) < 90.0f) {
            this.tailPitch += this.prevRotationPitchBody - this.rotationPitchBody;
        }
        this.tailPitch *= 0.5f;
        this.tailYaw *= 1.0f - movementSpeed;
        if (!this.field_70170_p.field_72995_K && this.huntingTimer > 0) {
            --this.huntingTimer;
        }
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.1f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.9f;
                this.field_70181_x *= (double)0.9f;
                this.field_70179_y *= (double)0.9f;
                if (this.func_70638_az() == null) {
                    this.field_70181_x -= 0.005;
                }
            } else {
                super.func_191986_a(strafe, up, forward);
            }
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        --this.attackTime;
        if (this.anger > 0) {
            --this.anger;
            if (this.anger == 0) {
                this.func_70624_b(null);
            }
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        float distance = entityIn.func_70032_d((Entity)this);
        if (this.entityBeingBit != null || this.func_184187_bx() != null || entityIn.func_184187_bx() != null) {
            return false;
        }
        if (this.field_70171_ac && entityIn instanceof EntityDragonFly && !this.isLeaping() && distance < 5.0f) {
            this.setIsLeaping(true);
            double distanceX = entityIn.field_70165_t - this.field_70165_t;
            double distanceZ = entityIn.field_70161_v - this.field_70161_v;
            float magnitude = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
            this.field_70159_w += distanceX / (double)magnitude * 0.8;
            this.field_70181_x += 0.9;
            this.field_70179_y += distanceZ / (double)magnitude * 0.8;
        }
        if (this.attackTime <= 0 && (double)distance < 3.5 && entityIn.func_174813_aQ().field_72337_e >= this.func_174813_aQ().field_72338_b && entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72337_e && this.ticksUntilBiteDamage == -1) {
            this.setShouldMouthBeOpen(true);
            this.setMouthMoveSpeed(10.0f);
            this.ticksUntilBiteDamage = 10;
            this.attackTime = 10;
            this.entityBeingBit = entityIn;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source) || source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        Entity attacker = source.func_76346_g();
        if (attacker instanceof EntityPlayer) {
            List nearLurkers = this.func_130014_f_().func_72872_a(EntityLurker.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
            for (EntityLurker fellowLurker : nearLurkers) {
                fellowLurker.showDeadlyAffectionTowards(attacker);
            }
        }
        return super.func_70097_a(source, damage);
    }

    private void showDeadlyAffectionTowards(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)entity);
            this.anger = 200 + this.field_70146_Z.nextInt(100);
        }
    }

    public boolean isLeaping() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LEAPING);
    }

    public void setIsLeaping(boolean isLeaping) {
        this.field_70180_af.func_187227_b(IS_LEAPING, (Object)isLeaping);
    }

    public boolean shouldMouthBeOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_MOUTH_BE_OPEN);
    }

    public void setShouldMouthBeOpen(boolean shouldMouthBeOpen) {
        this.field_70180_af.func_187227_b(SHOULD_MOUTH_BE_OPEN, (Object)shouldMouthBeOpen);
    }

    public float getMouthMoveSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MOUTH_MOVE_SPEED)).floatValue();
    }

    public void setMouthMoveSpeed(float mouthMoveSpeed) {
        this.field_70180_af.func_187227_b(MOUTH_MOVE_SPEED, (Object)Float.valueOf(mouthMoveSpeed));
    }

    public void setHuntingTimer(int cooldownIn) {
        this.huntingTimer = cooldownIn;
    }

    public float getRotationPitch(float partialRenderTicks) {
        return this.rotationPitchBody * partialRenderTicks + this.prevRotationPitchBody * (1.0f - partialRenderTicks);
    }

    public float getMouthOpen(float partialRenderTicks) {
        return (this.mouthOpenTicks * partialRenderTicks + this.prevMouthOpenTicks * (1.0f - partialRenderTicks)) / 20.0f;
    }

    public float getTailYaw(float partialRenderTicks) {
        return this.tailYaw * partialRenderTicks + this.prevTailYaw * (1.0f - partialRenderTicks);
    }

    public float getTailPitch(float partialRenderTicks) {
        return this.tailPitch * partialRenderTicks + this.prevTailPitch * (1.0f - partialRenderTicks);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.LURKER_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        this.setShouldMouthBeOpen(true);
        this.ticksUntilBiteDamage = 10;
        return SoundRegistry.LURKER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.LURKER_DEATH;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.LURKER;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74777_a("Anger", (short)this.anger);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        if (tagCompound.func_74764_b("Anger")) {
            this.anger = tagCompound.func_74765_d("Anger");
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    public class AIFindBait
    extends EntityAIBase {
        private final EntityLurker lurker;
        private double searchRange;
        public EntityFishBait bait = null;

        public AIFindBait(EntityLurker lurkerIn, double searchRangeIn) {
            this.lurker = lurkerIn;
            this.searchRange = searchRangeIn;
        }

        public boolean func_75250_a() {
            return this.lurker.huntingTimer <= 0 && this.bait == null;
        }

        public void func_75249_e() {
            if (this.bait == null) {
                this.bait = this.getClosestBait(this.searchRange);
            }
        }

        public boolean func_75253_b() {
            return this.lurker.huntingTimer <= 0 && this.bait != null && !this.bait.field_70128_L;
        }

        public void func_75246_d() {
            if (!this.lurker.field_70170_p.field_72995_K && this.func_75253_b() && this.bait != null) {
                float distance = this.bait.func_70032_d((Entity)this.lurker);
                double x = this.bait.field_70165_t;
                double y = this.bait.field_70163_u;
                double z = this.bait.field_70161_v;
                if (this.bait.func_174874_s()) {
                    if (distance >= 1.0f) {
                        this.lurker.func_70671_ap().func_75650_a(x, y, z, 20.0f, 8.0f);
                        this.moveToItem(this.bait);
                    }
                    if (distance <= 3.0f) {
                        this.lurker.func_70605_aq().func_75642_a(x, y, z, this.lurker.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 2.0);
                        this.bait.func_92059_d().func_190918_g(1);
                        if (this.bait.func_92059_d().func_190916_E() <= 0) {
                            this.bait.func_70106_y();
                        }
                        this.lurker.setHuntingTimer(2400);
                        this.func_75251_c();
                    }
                }
            }
        }

        public void func_75251_c() {
            this.bait = null;
        }

        public EntityFishBait getClosestBait(double distance) {
            List list = this.lurker.func_130014_f_().func_72872_a(EntityFishBait.class, this.lurker.func_174813_aQ().func_72314_b(distance, distance, distance));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityFishBait bait = (EntityFishBait)((Object)iterator.next());
                if (bait.field_70173_aa < bait.lifespan && bait.func_70090_H() && bait.func_184202_aL()) continue;
                iterator.remove();
            }
            if (list.isEmpty()) {
                return null;
            }
            if (!list.isEmpty()) {
                Collections.shuffle(list);
            }
            return (EntityFishBait)((Object)list.get(0));
        }

        public void moveToItem(EntityFishBait bait) {
            Path pathentity = this.lurker.func_70661_as().func_75505_d();
            if (pathentity != null) {
                this.lurker.func_70661_as().func_75492_a(bait.field_70165_t, bait.field_70163_u, bait.field_70161_v, this.lurker.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 2.0);
            }
        }
    }

    static class LurkerMoveHelper
    extends EntityMoveHelper {
        private final EntityLurker lurker;

        public LurkerMoveHelper(EntityLurker lurker) {
            super((EntityLiving)lurker);
            this.lurker = lurker;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.lurker.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.lurker.field_70165_t;
                double d1 = this.field_75647_c - this.lurker.field_70163_u;
                double d2 = this.field_75644_d - this.lurker.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.lurker.field_70761_aq = this.lurker.field_70177_z = this.func_75639_a(this.lurker.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.lurker.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.lurker.func_70659_e(this.lurker.func_70689_ay() + (f1 - this.lurker.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.lurker.field_70173_aa + this.lurker.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.lurker.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.lurker.field_70177_z * ((float)Math.PI / 180));
                this.lurker.field_70159_w += d4 * d5;
                this.lurker.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.lurker.field_70173_aa + this.lurker.func_145782_y()) * 0.75) * 0.05;
                this.lurker.field_70181_x += d4 * (d6 + d5) * 0.25;
                if (Math.abs(this.lurker.field_70181_x) < 0.35) {
                    this.lurker.field_70181_x = this.lurker.field_70181_x + (double)this.lurker.func_70689_ay() * d1 * 0.1 * (2.0 + (d1 > 0.0 ? 0.4 : 0.0) + (double)(this.lurker.field_70123_F ? 20 : 0));
                }
                EntityLookHelper entitylookhelper = this.lurker.func_70671_ap();
                double d7 = this.lurker.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.lurker.func_70047_e() + this.lurker.field_70163_u + d1 / d3;
                double d9 = this.lurker.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.lurker.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
            } else {
                this.lurker.func_70659_e(0.0f);
            }
        }
    }
}

