/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IRingOfGatheringMinion;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.client.render.model.ControlledAnimation;
import thebetweenlands.common.entity.EntityTameableBL;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityGiantToad
extends EntityTameableBL
implements IEntityBL,
IRingOfGatheringMinion,
IAnimals {
    private static final DataParameter<Byte> DW_SWIM_STROKE = EntityDataManager.func_187226_a(EntityGiantToad.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> DW_TAMED = EntityDataManager.func_187226_a(EntityGiantToad.class, (DataSerializer)DataSerializers.field_187198_h);
    private int temper = 0;
    private int ticksOnGround = 0;
    private int strokeTicks = 0;
    private boolean prevOnGround;
    private ControlledAnimation leapingAnim = new ControlledAnimation(4);
    private ControlledAnimation swimmingAnim = new ControlledAnimation(8);
    private ControlledAnimation waterStanceAnim = new ControlledAnimation(4);

    public EntityGiantToad(World world) {
        super(world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_70105_a(1.6f, 1.5f);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 8;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.05);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_SWIM_STROKE, (Object)0);
        this.field_70180_af.func_187214_a(DW_TAMED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Temper", this.temper);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.temper = nbt.func_74762_e("Temper");
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70071_h_() {
        this.prevOnGround = this.field_70122_E;
        if (this.func_184207_aI()) {
            this.func_174826_a(this.func_174813_aQ().func_186666_e(this.func_174813_aQ().field_72338_b + (double)this.field_70131_O + (double)this.func_184179_bs().field_70131_O));
        }
        super.func_70071_h_();
        this.func_174826_a(this.func_174813_aQ().func_186666_e(this.func_174813_aQ().field_72338_b + (double)this.field_70131_O));
        this.ticksOnGround = this.field_70122_E ? ++this.ticksOnGround : 0;
        if (!this.field_70170_p.field_72995_K) {
            if (this.strokeTicks > 0) {
                --this.strokeTicks;
                this.field_70180_af.func_187227_b(DW_SWIM_STROKE, (Object)1);
            } else {
                this.field_70180_af.func_187227_b(DW_SWIM_STROKE, (Object)0);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            this.func_70050_g(20);
            Path path = this.func_70661_as().func_75505_d();
            if (path != null && !path.func_75879_b() && !this.func_70610_aX()) {
                double speedMultiplier;
                float distance;
                float angle;
                float z;
                float x;
                PathPoint nextHopSpot;
                int index;
                if (this.field_70171_ac) {
                    index = path.func_75873_e();
                    if (index < path.func_75874_d()) {
                        nextHopSpot = path.func_75877_a(index);
                        x = (float)((double)nextHopSpot.field_75839_a - this.field_70165_t);
                        z = (float)((double)nextHopSpot.field_75838_c - this.field_70161_v);
                        angle = (float)Math.atan2(z, x);
                        distance = (float)Math.sqrt(x * x + z * z);
                        if (distance > 1.0f) {
                            if (this.strokeTicks == 0) {
                                speedMultiplier = Math.min(distance, 4.0f) / 4.0f * 0.8f + 0.2f;
                                this.field_70159_w += speedMultiplier * (double)0.8f * (double)MathHelper.func_76134_b((float)angle);
                                this.field_70179_y += speedMultiplier * (double)0.8f * (double)MathHelper.func_76126_a((float)angle);
                                this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                                this.strokeTicks = 40;
                            } else if (this.field_70123_F) {
                                this.field_70159_w += 0.01 * (double)MathHelper.func_76134_b((float)angle);
                                this.field_70179_y += 0.01 * (double)MathHelper.func_76126_a((float)angle);
                            }
                        } else {
                            path.func_75875_a();
                        }
                    }
                } else if (this.field_70122_E && (index = path.func_75873_e()) < path.func_75874_d()) {
                    nextHopSpot = path.func_75877_a(index);
                    x = (float)((double)nextHopSpot.field_75839_a - this.field_70165_t);
                    z = (float)((double)nextHopSpot.field_75838_c - this.field_70161_v);
                    angle = (float)Math.atan2(z, x);
                    distance = (float)Math.sqrt(x * x + z * z);
                    if (distance > 1.0f) {
                        if (this.ticksOnGround > 20) {
                            speedMultiplier = Math.min(distance, 2.0f) / 2.0f * 0.8f + 0.2f;
                            this.field_70181_x += speedMultiplier * 0.6 + MathHelper.func_151237_a((double)(((double)nextHopSpot.field_75837_b - this.field_70163_u) / 6.0), (double)0.0, (double)0.3);
                            this.field_70159_w += speedMultiplier * 0.5 * (double)MathHelper.func_76134_b((float)angle);
                            this.field_70179_y += speedMultiplier * 0.5 * (double)MathHelper.func_76126_a((float)angle);
                            ForgeHooks.onLivingJump((EntityLivingBase)this);
                        } else if (this.field_70123_F) {
                            this.field_70159_w += 0.01 * (double)MathHelper.func_76134_b((float)angle);
                            this.field_70179_y += 0.01 * (double)MathHelper.func_76126_a((float)angle);
                        }
                    } else {
                        path.func_75875_a();
                    }
                }
            }
            if (this.func_184207_aI()) {
                float attackDamage;
                EntityDamageSourceIndirect damageSource;
                List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(0.6, 0.6, 0.6));
                EntityLivingBase closestTarget = null;
                float lastAngDiff = 0.0f;
                Entity controllingPassenger = this.func_184179_bs();
                for (EntityLivingBase target : targets) {
                    float x;
                    float z;
                    float angle;
                    float angDiff;
                    float angDiffWrapped;
                    if (target.func_70643_av() != controllingPassenger && (!(controllingPassenger instanceof EntityLivingBase) || ((EntityLivingBase)controllingPassenger).func_70643_av() != target) || !((angDiffWrapped = Math.min(angDiff = (float)Math.abs((double)(this.field_70177_z % 360.0f) - Math.toDegrees(angle = (float)Math.atan2(z = (float)(target.field_70161_v - this.field_70161_v), x = (float)(target.field_70165_t - this.field_70165_t))) % 360.0 + 90.0) % 360.0f, Math.abs(360.0f - angDiff))) <= 50.0f) || !(angDiffWrapped < lastAngDiff) && closestTarget != null) continue;
                    closestTarget = target;
                    lastAngDiff = angDiffWrapped;
                }
                if (closestTarget != null && closestTarget.func_70097_a((DamageSource)(damageSource = new EntityDamageSourceIndirect("mob", (Entity)this, controllingPassenger)), attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) {
                    boolean doesJump = true;
                    if (this.field_70146_Z.nextInt(35) == 0 && closestTarget.func_70652_k((Entity)this)) {
                        doesJump = false;
                    }
                    float x = (float)(closestTarget.field_70165_t - this.field_70165_t);
                    float z = (float)(closestTarget.field_70161_v - this.field_70161_v);
                    if (doesJump && (this.field_70122_E && this.ticksOnGround >= 5 || this.field_70171_ac && this.strokeTicks == 0)) {
                        float angle = (float)Math.atan2(z, x);
                        if (!this.field_70171_ac) {
                            this.field_70181_x += 0.4;
                        }
                        this.field_70159_w += 0.5 * (double)MathHelper.func_76134_b((float)angle);
                        this.field_70179_y += 0.5 * (double)MathHelper.func_76126_a((float)angle);
                        if (this.field_70171_ac) {
                            this.strokeTicks = 20;
                            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                        } else {
                            ForgeHooks.onLivingJump((EntityLivingBase)this);
                        }
                        this.field_70122_E = false;
                    }
                    closestTarget.func_70653_a((Entity)this, attackDamage / 2.5f, (double)(-x), (double)(-z));
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.waterStanceAnim.updateTimer();
            if (this.field_70171_ac) {
                this.waterStanceAnim.increaseTimer();
            } else {
                this.waterStanceAnim.decreaseTimer();
            }
            this.leapingAnim.updateTimer();
            if (this.field_70171_ac || this.field_70122_E || this.prevOnGround) {
                this.leapingAnim.decreaseTimer();
            } else {
                this.leapingAnim.increaseTimer();
            }
            this.swimmingAnim.updateTimer();
            if ((Byte)this.field_70180_af.func_187225_a(DW_SWIM_STROKE) == 1) {
                if (this.strokeTicks < 20) {
                    ++this.strokeTicks;
                }
            } else {
                this.strokeTicks = 0;
            }
            if (this.field_70171_ac && (Byte)this.field_70180_af.func_187225_a(DW_SWIM_STROKE) == 1 && this.strokeTicks < 12) {
                this.swimmingAnim.increaseTimer();
            } else {
                this.swimmingAnim.decreaseTimer();
            }
        }
    }

    public float getLeapProgress(float partialRenderTicks) {
        return this.leapingAnim.getAnimationProgressSinSqrt(partialRenderTicks);
    }

    public float getSwimProgress(float partialRenderTicks) {
        return Math.min((1.0f - (float)Math.pow(1.0f - this.swimmingAnim.getAnimationFraction(partialRenderTicks), 2.0)) * 2.5f * this.swimmingAnim.getAnimationFraction(partialRenderTicks), 1.0f);
    }

    public float getWaterStanceProgress(float partialRenderTicks) {
        return this.waterStanceAnim.getAnimationProgressSinSqrt(partialRenderTicks);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.GIANT_TOAD_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.GIANT_TOAD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.GIANT_TOAD_DEATH;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean holdsEquipment;
        boolean bl = holdsEquipment = hand == EnumHand.MAIN_HAND && !player.func_184586_b(hand).func_190926_b() && (player.func_184586_b(hand).func_77973_b() instanceof IEquippable || player.func_184586_b(hand).func_77973_b() == ItemRegistry.AMULET_SLOT);
        if (holdsEquipment) {
            return true;
        }
        boolean holdsWings = ItemMisc.EnumItemMisc.DRAGONFLY_WING.isItemOf(player.func_184586_b(hand));
        if (!(this.func_184207_aI() || !this.func_70909_n() || holdsWings && !(this.func_110143_aJ() >= this.func_110138_aP()) || player.func_70093_af() || this.field_70170_p.field_72995_K)) {
            player.func_184220_m((Entity)this);
            return true;
        }
        if (holdsWings) {
            if (!this.func_70909_n()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.temper += this.field_70146_Z.nextInt(4) + 1;
                    if (this.temper >= 30 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        this.func_193101_c(player);
                        this.temper = 0;
                    } else {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184586_b(hand).func_190918_g(1);
                        if (player.func_184586_b(hand).func_190916_E() <= 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    }
                }
                return true;
            }
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    this.func_70691_i(4.0f);
                    player.func_184586_b(hand).func_190918_g(1);
                    if (player.func_184586_b(hand).func_190916_E() <= 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity = source.func_76346_g();
        return (!this.func_184207_aI() || this.func_184179_bs() == null || !this.func_184179_bs().equals((Object)entity)) && super.func_70097_a(source, damage);
    }

    protected boolean func_70610_aX() {
        return this.func_184207_aI() || super.func_70610_aX();
    }

    public void func_191986_a(float strafing, float up, float forward) {
        Entity controllingPassenger = this.func_184179_bs();
        if (this.func_184207_aI() && controllingPassenger != null && controllingPassenger instanceof EntityLivingBase) {
            this.field_70126_B = this.field_70177_z = controllingPassenger.field_70177_z;
            this.field_70125_A = controllingPassenger.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafing = ((EntityLivingBase)controllingPassenger).field_70702_br * 0.5f;
            forward = ((EntityLivingBase)controllingPassenger).field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            boolean onWaterSurface = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))).func_185904_a().func_76224_d();
            if (!this.field_70171_ac || !onWaterSurface) {
                if (this.field_70122_E && forward != 0.0f && !this.field_70170_p.field_72995_K && this.ticksOnGround > 4) {
                    this.field_70181_x += 0.5;
                    this.field_70159_w += (double)(forward / 1.5f * MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z + 90.0f))));
                    this.field_70179_y += (double)(forward / 1.5f * MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z + 90.0f))));
                    this.field_70159_w += (double)(strafing / 2.0f * MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z))));
                    this.field_70179_y += (double)(strafing / 2.0f * MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z))));
                    ForgeHooks.onLivingJump((EntityLivingBase)this);
                }
            } else {
                if (this.field_70181_x < 0.0 && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 0.9)), MathHelper.func_76128_c((double)this.field_70161_v))).func_185904_a().func_76224_d()) {
                    this.field_70181_x *= (double)0.05f;
                }
                if (this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.1)), MathHelper.func_76128_c((double)this.field_70161_v))).func_185904_a().func_76224_d()) {
                    this.field_70181_x += (double)0.02f;
                }
                if (!this.field_70170_p.field_72995_K && this.field_70123_F) {
                    this.field_70181_x += 0.2;
                    this.strokeTicks = 0;
                }
                if (!this.field_70170_p.field_72995_K && forward > 0.0f && forward != 0.0f && this.strokeTicks == 0) {
                    this.field_70159_w += (double)(forward / 1.25f * MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z + 90.0f))));
                    this.field_70179_y += (double)(forward / 1.25f * MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z + 90.0f))));
                    this.field_70159_w += (double)(strafing / 1.25f * MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z))));
                    this.field_70179_y += (double)(strafing / 1.25f * MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z))));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                    this.strokeTicks = 20;
                }
            }
            if (!this.field_70170_p.field_72995_K && forward > 0.0f) {
                this.field_70159_w += 0.05 * (double)MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z + 90.0f)));
                this.field_70179_y += 0.05 * (double)MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z + 90.0f)));
            }
            super.func_191986_a(0.0f, 0.0f, 0.0f);
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafing, up, forward);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnToadParticles(boolean isHeart) {
        EnumParticleTypes enumparticletypes = isHeart ? EnumParticleTypes.HEART : EnumParticleTypes.SMOKE_NORMAL;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.strokeTicks = 0;
        }
        if (id == 7) {
            this.spawnToadParticles(true);
        } else if (id == 6) {
            this.spawnToadParticles(false);
            this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_184186_bw() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        distance = Math.max(0.0f, distance - 6.0f);
        super.func_180430_e(distance, damageMultiplier);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.TOAD;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    @Override
    public NBTTagCompound returnToRing(UUID userId) {
        return this.func_189511_e(new NBTTagCompound());
    }

    @Override
    public boolean returnFromRing(Entity user, NBTTagCompound nbt) {
        double prevX = this.field_70165_t;
        double prevY = this.field_70163_u;
        double prevZ = this.field_70161_v;
        float prevYaw = this.field_70177_z;
        float prevPitch = this.field_70125_A;
        this.func_70020_e(nbt);
        this.func_70012_b(prevX, prevY, prevZ, prevYaw, prevPitch);
        if (!this.func_70089_S()) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70170_p.func_72838_d((Entity)this);
        return true;
    }

    @Override
    public boolean shouldReturnOnUnload(boolean isOwnerLoggedIn) {
        return IRingOfGatheringMinion.super.shouldReturnOnUnload(isOwnerLoggedIn) && !this.func_70906_o();
    }

    @Override
    public UUID getRingOwnerId() {
        return this.func_184753_b();
    }
}

