/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleUrchinSpike;
import thebetweenlands.common.entity.EntityProximitySpawner;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityFreshwaterUrchin
extends EntityProximitySpawner {
    private static final DataParameter<Integer> SPIKE_COOLDOWN = EntityDataManager.func_187226_a(EntityFreshwaterUrchin.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SPIKE_BOX_SIZE = EntityDataManager.func_187226_a(EntityFreshwaterUrchin.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean shootSpikes;
    public int MAX_SPIKE_TIMER = 10;
    public static final byte EVENT_ATTACK = 66;
    public DamageSource urchinSpikesDamageSource = new EntityDamageSource("bl.urchin_spikes", (Entity)this);

    public EntityFreshwaterUrchin(World world) {
        super(world);
        this.func_70105_a(0.6875f, 0.4375f);
        this.func_184644_a(PathNodeType.WATER, 4.0f);
        this.field_70138_W = 1.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.CRUNCH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.CRUNCH;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 10.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 40));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPIKE_COOLDOWN, (Object)80);
        this.field_70180_af.func_187214_a(SPIKE_BOX_SIZE, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.05);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == BlockRegistry.SWAMP_WATER;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public int getSpikeGrowTimer() {
        return (Integer)this.field_70180_af.func_187225_a(SPIKE_COOLDOWN);
    }

    public void setSpikeGrowTimer(int count) {
        this.field_70180_af.func_187227_b(SPIKE_COOLDOWN, (Object)count);
    }

    public int getSpikeBoxTimer() {
        return (Integer)this.field_70180_af.func_187225_a(SPIKE_BOX_SIZE);
    }

    public void setSpikeBoxTimer(int count) {
        this.field_70180_af.func_187227_b(SPIKE_BOX_SIZE, (Object)count);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.FRESHWATER_URCHIN;
    }

    public void func_70106_y() {
        if (!this.func_130014_f_().field_72995_K && this.func_94060_bK() instanceof EntityLurker) {
            EntityLurker lurker = (EntityLurker)this.func_94060_bK();
            lurker.setHuntingTimer(2400);
        }
        super.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            this.checkAOEDamage();
            if (this.getSpikeGrowTimer() < 80) {
                this.setSpikeGrowTimer(this.getSpikeGrowTimer() + 1);
            }
            if (this.getSpikeGrowTimer() >= 80 && this.func_130014_f_().func_82737_E() % 5L == 0L) {
                this.checkAreaHere();
            }
            if (this.shootSpikes) {
                if (this.getSpikeBoxTimer() < this.MAX_SPIKE_TIMER) {
                    this.setSpikeBoxTimer(this.getSpikeBoxTimer() + 1);
                }
                if (this.getSpikeBoxTimer() >= this.MAX_SPIKE_TIMER) {
                    this.shootSpikes = false;
                    this.setSpikeBoxTimer(0);
                }
            }
        }
    }

    private void checkAOEDamage() {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
            List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.spikesBox());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityLivingBase entity = (EntityLivingBase)iterator.next();
                if (!(entity != null && entity instanceof EntityFreshwaterUrchin || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_184812_l_())) continue;
                iterator.remove();
            }
            if (list.isEmpty()) {
                return;
            }
            if (!list.isEmpty()) {
                EntityLivingBase entity = (EntityLivingBase)list.get(0);
                if (entity.field_70172_ad <= 0) {
                    entity.func_70097_a(this.urchinSpikesDamageSource, 2.0f);
                    this.shootSpikes = false;
                    this.setSpikeBoxTimer(0);
                }
            }
        }
    }

    public void checkAreaHere() {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && this.func_70090_H()) {
            List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.proximityBox());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityLivingBase entity = (EntityLivingBase)iterator.next();
                if (!(entity != null && entity instanceof EntityFreshwaterUrchin || entity instanceof EntityAnadia || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_184812_l_())) continue;
                iterator.remove();
            }
            if (list.isEmpty()) {
                return;
            }
            if (!list.isEmpty()) {
                EntityLivingBase entity = (EntityLivingBase)list.get(0);
                if (this.canSneakPast() && entity.func_70093_af()) {
                    return;
                }
                if (this.checkSight() && !this.func_70685_l((Entity)entity)) {
                    return;
                }
                this.shootSpikes();
                if (!this.field_70128_L && this.isSingleUse()) {
                    this.func_70106_y();
                }
            }
        }
    }

    private void shootSpikes() {
        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.URCHIN_SHOOT, SoundCategory.NEUTRAL, 1.0f, 1.5f + (this.func_130014_f_().field_73012_v.nextFloat() - this.func_130014_f_().field_73012_v.nextFloat()) * 0.5f);
        this.setSpikeGrowTimer(0);
        this.shootSpikes = true;
        this.func_130014_f_().func_72960_a((Entity)this, (byte)66);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 66) {
            Vec3d frontCenter = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            for (int i = 0; i < 64; ++i) {
                Random rnd = this.field_70170_p.field_73012_v;
                float rx = rnd.nextFloat() * 4.0f - 2.0f;
                float ry = rnd.nextFloat() * 4.0f - 2.0f;
                float rz = rnd.nextFloat() * 4.0f - 2.0f;
                Vec3d vec = new Vec3d((double)rx, (double)ry, (double)rz);
                vec = vec.func_72432_b();
                ParticleUrchinSpike particle = (ParticleUrchinSpike)BLParticles.URCHIN_SPIKE.spawn(this.field_70170_p, frontCenter.field_72450_a, frontCenter.field_72448_b - 0.25, frontCenter.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(vec.field_72450_a * (double)0.175f, vec.field_72448_b * (double)0.15f + (double)0.35f, vec.field_72449_c * (double)0.175f)).withScale(0.2f));
                particle.setUseSound(this.field_70146_Z.nextInt(15) == 0);
            }
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> entityClass) {
        return entityClass != EntityFreshwaterUrchin.class;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76369_e) {
            return false;
        }
        Entity attacker = source.func_76364_f();
        if (attacker instanceof EntityLivingBase && attacker.field_70172_ad <= 0 && ((EntityLivingBase)attacker).func_184614_ca().func_190926_b() && !(attacker instanceof EntityFreshwaterUrchin)) {
            attacker.func_70097_a(this.urchinSpikesDamageSource, 2.0f);
        }
        return super.func_70097_a(source, damage);
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.1f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.75;
                this.field_70181_x *= 0.75;
                this.field_70179_y *= 0.75;
                this.field_70181_x -= 0.006;
            } else {
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.field_70181_x -= 0.2;
            }
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    @Override
    protected float getProximityHorizontal() {
        return 2.0f;
    }

    @Override
    protected float getProximityVertical() {
        return 1.0f;
    }

    @Override
    public AxisAlignedBB proximityBox() {
        return new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5).func_72314_b((double)this.getProximityHorizontal(), (double)this.getProximityVertical(), (double)this.getProximityHorizontal()).func_72317_d(0.0, (double)(this.getProximityVertical() + this.field_70131_O), 0.0);
    }

    public AxisAlignedBB spikesBox() {
        float x = this.getProximityHorizontal() / (float)this.MAX_SPIKE_TIMER * (float)this.getSpikeBoxTimer();
        float y = this.getProximityVertical() / (float)this.MAX_SPIKE_TIMER * (float)this.getSpikeBoxTimer();
        float z = this.getProximityHorizontal() / (float)this.MAX_SPIKE_TIMER * (float)this.getSpikeBoxTimer();
        return new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5).func_72314_b((double)x, (double)y, (double)z).func_72317_d(0.0, (double)y, 0.0);
    }

    @Override
    protected boolean canSneakPast() {
        return true;
    }

    @Override
    protected boolean checkSight() {
        return true;
    }

    @Override
    protected Entity getEntitySpawned() {
        return null;
    }

    @Override
    protected int getEntitySpawnCount() {
        return 0;
    }

    @Override
    protected boolean isSingleUse() {
        return false;
    }

    @Override
    protected int maxUseCount() {
        return 0;
    }
}

