/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityPreventUnmount;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.client.render.model.ControlledAnimation;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.mobs.EntityChiromawGreeblingRider;
import thebetweenlands.common.entity.mobs.EntityFlyingMob;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.entity.projectiles.EntityBLArrow;
import thebetweenlands.common.entity.projectiles.EntityChiromawDroppings;
import thebetweenlands.common.item.tools.bow.EnumArrowType;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationChiromawMatriarchNest;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class EntityChiromawMatriarch
extends EntityFlyingMob
implements IEntityBL,
IEntityPreventUnmount {
    private static final DataParameter<Boolean> IS_NESTING = EntityDataManager.func_187226_a(EntityChiromawMatriarch.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RETURN_TO_NEST = EntityDataManager.func_187226_a(EntityChiromawMatriarch.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_LANDING = EntityDataManager.func_187226_a(EntityChiromawMatriarch.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SPINNING = EntityDataManager.func_187226_a(EntityChiromawMatriarch.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TARGET_ENTITY_ID = EntityDataManager.func_187226_a(EntityChiromawMatriarch.class, (DataSerializer)DataSerializers.field_187192_b);
    public int broodCount;
    public double pickupHeight;
    public int droppingTimer;
    @Nullable
    private BlockPos boundOrigin;
    public float previousSpinAngle;
    public float spinAngle;
    public float animTime;
    public float prevAnimTime;
    public float flapSpeed = 0.5f;
    public int flapTicks;
    public int landingAbortTime;
    private boolean returnFast;
    public final ControlledAnimation landingTimer = new ControlledAnimation(10);
    public final ControlledAnimation nestingTimer = new ControlledAnimation(20);
    public final ControlledAnimation spinningTimer = new ControlledAnimation(10);

    public EntityChiromawMatriarch(World world) {
        super(world);
        this.func_70105_a(1.75f, 2.0f);
        this.setIsNesting(false);
        this.field_70728_aV = 150;
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
        this.func_184644_a(PathNodeType.FENCE, -8.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_NESTING, (Object)false);
        this.field_70180_af.func_187214_a(RETURN_TO_NEST, (Object)false);
        this.field_70180_af.func_187214_a(IS_LANDING, (Object)false);
        this.field_70180_af.func_187214_a(IS_SPINNING, (Object)false);
        this.field_70180_af.func_187214_a(TARGET_ENTITY_ID, (Object)-1);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPickUpAndDropAttack(this, 2.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIReturnToNest(this, 1.25, 2.15));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIMoveRandom(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChangeNest(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIPoop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIFindNearestTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true, 16.0).func_190882_b(160));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIFindNearestTarget<EntityVillager>((EntityCreature)this, EntityVillager.class, true, 16.0).func_190882_b(160));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIFindNearestTarget<EntityChiromawGreeblingRider>((EntityCreature)this, EntityChiromawGreeblingRider.class, true, 16.0).func_190882_b(160));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() == null) {
            if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.func_70106_y();
            }
            if (this.getBroodCount() <= 0) {
                this.setReturnToNest(!this.getReturnToNest());
                this.setBroodCount(240);
            }
            if (this.getBroodCount() > 0) {
                this.setBroodCount(this.getBroodCount() - 1);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null) {
            if (this.getIsNesting()) {
                this.setIsNesting(false);
            }
            if (this.getReturnToNest()) {
                this.setReturnToNest(false);
            }
            if (this.getBroodCount() < 240) {
                this.setBroodCount(240);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase target = this.func_70638_az();
            this.field_70180_af.func_187227_b(TARGET_ENTITY_ID, (Object)(target != null ? target.func_145782_y() : -1));
        }
        if (this.field_70703_bu && this.func_70090_H()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 1.0);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && this.getBoundOrigin() != null) {
            this.setBoundOrigin(this.field_70170_p.func_175645_m(this.getBoundOrigin()));
        }
        if (!this.func_130014_f_().field_72995_K && this.getIsLanding()) {
            if (this.landingAbortTime > 0) {
                --this.landingAbortTime;
            }
            if (this.landingAbortTime <= 0) {
                if (this.getIsLanding()) {
                    this.setIsLanding(false);
                }
                if (this.getReturnToNest()) {
                    this.setReturnToNest(false);
                }
                if (this.getBroodCount() < 240) {
                    this.setBroodCount(240);
                }
            }
        }
        if (this.getBroodCount() > 0 && this.func_70638_az() == null && this.getReturnToNest() && !this.getIsNesting() && this.getNestBox() != null && this.func_174813_aQ().func_72326_a(this.getNestBox())) {
            double d0 = (double)this.getBoundOrigin().func_177958_n() + 0.5 - this.field_70165_t;
            double d1 = (double)this.getBoundOrigin().func_177956_o() - this.field_70163_u;
            double d2 = (double)this.getBoundOrigin().func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(d0) - this.field_70159_w) * 3.0E-10;
            this.field_70181_x += (Math.signum(d1) - this.field_70181_x) * 0.03125;
            this.field_70179_y += (Math.signum(d2) - this.field_70179_y) * 3.0E-10;
            if (this.func_174813_aQ().field_72338_b > this.getNestBox().field_72338_b + 0.0625 && Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) < 0.1 && !this.func_130014_f_().field_72995_K && !this.getIsLanding()) {
                this.setIsLanding(true);
                this.landingAbortTime = 40;
            }
            if (this.func_174813_aQ().field_72338_b <= this.getNestBox().field_72338_b + 0.0625 && !this.func_130014_f_().field_72995_K) {
                if (this.getIsLanding()) {
                    this.setIsLanding(false);
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_LAND, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.func_130014_f_().field_73012_v.nextFloat() - this.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
                }
                if (!this.getIsNesting()) {
                    this.setIsNesting(true);
                }
                this.func_70107_b((double)this.getBoundOrigin().func_177958_n() + 0.5, this.getBoundOrigin().func_177956_o(), (double)this.getBoundOrigin().func_177952_p() + 0.5);
            }
        }
        if (this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).isSideSolid((IBlockAccess)this.func_130014_f_(), this.func_180425_c().func_177977_b(), EnumFacing.UP) && !this.getIsLanding() && !this.getIsNesting()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v, 1.0);
        }
        if (this.getIsSpinning()) {
            if (this.func_130014_f_().field_72995_K) {
                this.previousSpinAngle = this.spinAngle;
                if (this.spinAngle <= 330.0f) {
                    this.spinAngle += 30.0f;
                }
                if (this.spinAngle >= 360.0f) {
                    this.spinAngle = 0.0f;
                }
            }
            this.field_70181_x += (double)0.05f;
        }
        if (this.field_70170_p.field_72995_K) {
            this.nestingTimer.updateTimer();
            this.landingTimer.updateTimer();
            this.spinningTimer.updateTimer();
            if (this.getIsNesting()) {
                this.nestingTimer.increaseTimer();
                this.landingTimer.decreaseTimer();
                this.spinningTimer.decreaseTimer();
            } else if (this.getIsLanding()) {
                this.landingTimer.increaseTimer();
                this.nestingTimer.decreaseTimer();
                this.spinningTimer.decreaseTimer();
            } else if (this.getIsSpinning()) {
                this.spinningTimer.increaseTimer();
                this.landingTimer.decreaseTimer();
                this.nestingTimer.decreaseTimer();
            } else {
                this.landingTimer.decreaseTimer();
                this.nestingTimer.decreaseTimer();
                this.spinningTimer.decreaseTimer();
            }
        }
    }

    public EntityLivingBase func_70638_az() {
        Entity target;
        int targetId;
        if (this.field_70170_p.field_72995_K && (targetId = ((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY_ID)).intValue()) >= 0 && (target = this.field_70170_p.func_73045_a(targetId)) instanceof EntityLivingBase) {
            return (EntityLivingBase)target;
        }
        return super.func_70638_az();
    }

    public void func_70024_g(double x, double y, double z) {
        if (this.getIsNesting()) {
            this.field_70159_w = 0.0;
            this.field_70181_x += y;
            this.field_70179_y = 0.0;
            this.field_70160_al = false;
        } else {
            this.field_70159_w += x;
            this.field_70181_x += y;
            this.field_70179_y += z;
            this.field_70160_al = true;
        }
    }

    private boolean homeisOccupied() {
        if (this.getNestBox() != null) {
            Entity entity = null;
            List entityList = this.func_130014_f_().func_72839_b((Entity)this, this.getNestBox());
            if (!entityList.isEmpty()) {
                for (int entityCount = 0; entityCount < entityList.size(); ++entityCount) {
                    entity = (Entity)entityList.get(entityCount);
                    if (entity == null || !(entity instanceof EntityChiromawMatriarch)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            ++this.flapTicks;
            if (!this.func_174814_R() && !this.getIsNesting()) {
                float flapAngle1 = MathHelper.func_76134_b((float)((float)this.flapTicks * this.flapSpeed));
                float flapAngle2 = MathHelper.func_76134_b((float)((float)(this.flapTicks + 1) * this.flapSpeed));
                if (flapAngle1 <= 0.3f && flapAngle2 > 0.3f) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getFlySound(), this.func_184176_by(), this.getIsLanding() ? 0.25f : 0.5f, this.getIsLanding() ? 1.5f + this.field_70146_Z.nextFloat() * 0.3f : 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                }
            }
            this.prevAnimTime = this.animTime;
            float flaptimer = 0.079f;
            if (this.getIsLanding()) {
                this.animTime += flaptimer * 2.0f;
            }
            this.animTime = this.getIsNesting() ? 0.0f : (this.animTime += flaptimer);
            if (this.func_175446_cd()) {
                this.animTime = 0.5f;
            }
        }
    }

    protected void func_70619_bc() {
        if (this.getIsNesting() && !this.func_130014_f_().field_72995_K) {
            if (!this.func_130014_f_().func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v)).func_185915_l()) {
                this.setIsNesting(false);
            } else if (this.func_70638_az() != null) {
                this.setIsNesting(false);
            }
        }
    }

    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (entity instanceof EntityLivingBase) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.6;
            double offSetZ = Math.cos(a) * 0.6;
            entity.func_70107_b(this.field_70165_t - offSetX, this.field_70163_u - (double)entity.field_70131_O + (double)(MathHelper.func_76126_a((float)((float)this.field_70173_aa * 0.5f)) * 0.3f), this.field_70161_v - offSetZ);
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean getReturnToNest() {
        return (Boolean)this.field_70180_af.func_187225_a(RETURN_TO_NEST);
    }

    public void setReturnToNest(boolean broody) {
        this.field_70180_af.func_187227_b(RETURN_TO_NEST, (Object)broody);
    }

    public boolean getIsLanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LANDING);
    }

    public void setIsLanding(boolean landing) {
        this.field_70180_af.func_187227_b(IS_LANDING, (Object)landing);
    }

    public void setBroodCount(int count) {
        this.broodCount = count;
    }

    public int getBroodCount() {
        return this.broodCount;
    }

    public void setDroppingTimer(int count) {
        this.droppingTimer = count;
    }

    public int getDroppingTimer() {
        return this.droppingTimer;
    }

    public boolean getIsNesting() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_NESTING);
    }

    public void setIsNesting(boolean nesting) {
        this.field_70180_af.func_187227_b(IS_NESTING, (Object)nesting);
    }

    public boolean getIsSpinning() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SPINNING);
    }

    public void setIsSpinning(boolean spinning) {
        this.field_70180_af.func_187227_b(IS_SPINNING, (Object)spinning);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.CHIROMAW_MATRIARCH;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.CHIROMAW_MATRIARCH_LIVING;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.CHIROMAW_MATRIARCH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.CHIROMAW_MATRIARCH_DEATH;
    }

    protected SoundEvent getFlySound() {
        return SoundRegistry.CHIROMAW_MATRIARCH_FLAP;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.095);
    }

    public boolean func_70652_k(Entity entityIn) {
        return EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, entityIn);
    }

    public boolean func_70686_a(Class entity) {
        return EntityChiromawMatriarch.class != entity;
    }

    public int func_70641_bl() {
        return 1;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.field_70170_p.field_72995_K) {
            this.setBoundOrigin(this.func_180425_c());
        }
        return livingdata;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("BoundX")) {
            this.boundOrigin = new BlockPos(compound.func_74762_e("BoundX"), compound.func_74762_e("BoundY"), compound.func_74762_e("BoundZ"));
        }
        this.setBroodCount(compound.func_74762_e("BroodCount"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.boundOrigin != null) {
            compound.func_74768_a("BoundX", this.boundOrigin.func_177958_n());
            compound.func_74768_a("BoundY", this.boundOrigin.func_177956_o());
            compound.func_74768_a("BoundZ", this.boundOrigin.func_177952_p());
        }
        compound.func_74768_a("BroodCount", this.getBroodCount());
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            if (source.func_76346_g() == this) {
                return false;
            }
            if (source.func_76346_g() instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)source.func_76346_g());
            }
        }
        if (source.func_76346_g() instanceof EntityPlayer && this.func_184207_aI() && this.func_184196_w(source.func_76346_g()) && !this.func_130014_f_().field_72995_K) {
            this.setDroppingTimer(0);
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_70112_a(double distance) {
        return distance < 16384.0 * EntityChiromawMatriarch.func_184183_bd();
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    @Nullable
    public AxisAlignedBB getNestBox() {
        return this.boundOrigin != null ? new AxisAlignedBB(this.boundOrigin, this.boundOrigin.func_177981_b(5)).func_72314_b(0.0625, 0.0, 0.0625) : null;
    }

    @Override
    public boolean isUnmountBlocked(EntityPlayer rider) {
        return !this.field_70170_p.field_72995_K && this.getDroppingTimer() > 0;
    }

    class AIReturnToNest
    extends EntityAIBase {
        private final EntityChiromawMatriarch largeChiromaw;
        protected double x;
        protected double y;
        protected double z;
        private final double speed;
        private final double speedHigh;
        private int timeToRecalcPath;

        public AIReturnToNest(EntityChiromawMatriarch large_chiromaw, double speedIn, double speedHighIn) {
            this.largeChiromaw = large_chiromaw;
            this.speed = speedIn;
            this.speedHigh = speedHighIn;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.largeChiromaw.func_70638_az();
            if (entitylivingbase != null) {
                return false;
            }
            if (this.largeChiromaw.homeisOccupied()) {
                return false;
            }
            if (this.largeChiromaw.getReturnToNest() && !this.largeChiromaw.getIsNesting()) {
                Vec3d nestLocation = this.getNestPosition();
                if (nestLocation == null) {
                    return false;
                }
                this.x = nestLocation.field_72450_a;
                this.y = nestLocation.field_72448_b;
                this.z = nestLocation.field_72449_c;
                return true;
            }
            return false;
        }

        @Nullable
        protected Vec3d getNestPosition() {
            BlockPos home = EntityChiromawMatriarch.this.getBoundOrigin();
            home = this.largeChiromaw.field_70170_p.func_175645_m(home);
            return new Vec3d((double)home.func_177958_n() + 0.5, (double)home.func_177956_o(), (double)home.func_177952_p() + 0.5);
        }

        public void func_75249_e() {
            this.moveTowardsNest();
        }

        public boolean func_75253_b() {
            return this.largeChiromaw.getReturnToNest() && !this.largeChiromaw.getIsNesting() && this.largeChiromaw.func_70638_az() == null && !this.largeChiromaw.homeisOccupied();
        }

        public void func_75246_d() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = !this.moveTowardsNest() ? 40 : 3;
            }
        }

        private boolean moveTowardsNest() {
            if (this.largeChiromaw.func_70092_e(this.x, this.y, this.z) < 6.0) {
                this.largeChiromaw.func_70605_aq().func_75642_a(this.x, this.y, this.z, this.speed * 0.25);
                this.largeChiromaw.returnFast = false;
                return true;
            }
            PathNavigate navigator = this.largeChiromaw.func_70661_as();
            if (!navigator.func_75492_a(this.x, this.y, this.z, this.largeChiromaw.returnFast ? this.speedHigh : this.speed)) {
                Vec3d target = new Vec3d(this.x, this.y, this.z);
                if ((target = this.findNextPointTowards(12, 5, target)) != null && !navigator.func_75492_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, this.largeChiromaw.returnFast ? this.speedHigh : this.speed)) {
                    this.largeChiromaw.func_70605_aq().func_75642_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, this.largeChiromaw.returnFast ? this.speedHigh : this.speed);
                }
                return false;
            }
            return true;
        }

        @Nullable
        private Vec3d findNextPointTowards(int xz, int y, Vec3d target) {
            Vec3d offset = target.func_178788_d(this.largeChiromaw.func_174791_d()).func_72432_b().func_186678_a((double)(8.0f + this.largeChiromaw.field_70146_Z.nextFloat() * 6.0f));
            Vec3d side = offset.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
            Vec3d up = side.func_72431_c(offset).func_72432_b();
            return this.largeChiromaw.func_174791_d().func_178787_e(offset).func_178787_e(side.func_186678_a((double)((this.largeChiromaw.field_70146_Z.nextFloat() - 0.5f) * 8.0f))).func_178787_e(up.func_186678_a((double)((this.largeChiromaw.field_70146_Z.nextFloat() - 0.5f) * 8.0f)));
        }
    }

    class AIChangeNest
    extends EntityAIBase {
        private final EntityChiromawMatriarch largeChiromaw;
        protected float maxRangeSq = 32400.0f;
        private int checkTimer = 0;
        private int idleChangeCounter = 0;

        public AIChangeNest(EntityChiromawMatriarch large_chiromaw) {
            this.func_75248_a(0);
            this.largeChiromaw = large_chiromaw;
        }

        private Vec3d getCenter(AxisAlignedBB aabb) {
            return new Vec3d(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5, aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
        }

        public boolean func_75250_a() {
            if (!this.largeChiromaw.getReturnToNest() && this.largeChiromaw.func_70638_az() == null && this.checkTimer-- <= 0) {
                this.checkTimer = 10;
                BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(this.largeChiromaw.field_70170_p);
                ArrayList<LocationStorage> priorityNests = new ArrayList<LocationStorage>();
                ArrayList<LocationStorage> otherNests = new ArrayList<LocationStorage>();
                for (ILocalStorage localStorage : worldStorage.getLocalStorageHandler().getLoadedStorages()) {
                    LocationStorage location;
                    Vec3d center;
                    if (!(localStorage instanceof LocationStorage) || localStorage.getBoundingBox() == null || !((center = this.getCenter((location = (LocationStorage)localStorage).getBoundingBox())).func_186679_c(this.largeChiromaw.field_70165_t, this.largeChiromaw.field_70163_u, this.largeChiromaw.field_70161_v) < (double)this.maxRangeSq) || location.getType() != EnumLocationType.FLOATING_ISLAND && location.getType() != EnumLocationType.CHIROMAW_MATRIARCH_NEST || this.largeChiromaw.field_70146_Z.nextInt(15) != 0 && !this.largeChiromaw.field_70170_p.func_72872_a(this.largeChiromaw.getClass(), location.getBoundingBox()).isEmpty()) continue;
                    if (location instanceof LocationChiromawMatriarchNest && this.largeChiromaw.field_70170_p.func_190525_a(center.field_72450_a, center.field_72448_b, center.field_72449_c, 32.0, entity -> !((EntityPlayer)entity).func_184812_l_() && !((EntityPlayer)entity).func_175149_v()) != null) {
                        priorityNests.add(location);
                        continue;
                    }
                    if (!(location instanceof LocationChiromawMatriarchNest) && this.largeChiromaw.field_70146_Z.nextInt(3) != 0) continue;
                    otherNests.add(location);
                }
                LocationStorage nest = null;
                if (!priorityNests.isEmpty()) {
                    Collections.shuffle(priorityNests);
                    nest = (LocationStorage)priorityNests.get(0);
                    this.largeChiromaw.returnFast = true;
                } else if (!otherNests.isEmpty() && this.idleChangeCounter++ >= 8) {
                    this.idleChangeCounter = 0;
                    Collections.shuffle(otherNests);
                    nest = (LocationStorage)otherNests.get(0);
                    this.largeChiromaw.returnFast = false;
                }
                if (nest != null) {
                    Object nestPos;
                    if (nest instanceof LocationChiromawMatriarchNest) {
                        nestPos = ((LocationChiromawMatriarchNest)nest).getNestPosition();
                        if (nestPos == null) {
                            nestPos = new BlockPos(this.getCenter(nest.getBoundingBox()));
                        }
                    } else {
                        AxisAlignedBB locationBB = nest.getBoundingBox();
                        nestPos = locationBB != null ? new BlockPos(this.getCenter(locationBB)) : null;
                    }
                    if (nestPos != null && !(nestPos = this.largeChiromaw.field_70170_p.func_175645_m(nestPos)).equals((Object)this.largeChiromaw.getBoundOrigin())) {
                        this.largeChiromaw.setBoundOrigin((BlockPos)nestPos);
                        this.largeChiromaw.setIsNesting(false);
                        this.largeChiromaw.setReturnToNest(true);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        private final EntityChiromawMatriarch largeChiromaw;

        public AIMoveRandom(EntityChiromawMatriarch large_chiromaw) {
            this.func_75248_a(1);
            this.largeChiromaw = large_chiromaw;
        }

        public boolean func_75250_a() {
            return !this.largeChiromaw.getReturnToNest() && !this.largeChiromaw.func_70605_aq().func_75640_a() && this.largeChiromaw.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = this.largeChiromaw.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)this.largeChiromaw);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.largeChiromaw.field_70146_Z.nextInt(33) - 16, this.largeChiromaw.field_70146_Z.nextInt(17) - 8, this.largeChiromaw.field_70146_Z.nextInt(33) - 16);
                if (!this.largeChiromaw.field_70170_p.func_175623_d(blockpos1)) continue;
                this.largeChiromaw.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 3.0);
                if (this.largeChiromaw.func_70638_az() != null) break;
                this.largeChiromaw.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIPickUpAndDropAttack
    extends EntityAIBase {
        World world;
        protected int attackTick;
        double speedTowardsTarget;
        boolean longMemory;
        Path path;
        private int delayCounter;
        private double targetX;
        private double targetY;
        private double targetZ;
        protected final int attackInterval = 20;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private final EntityChiromawMatriarch largeChiromaw;
        float rotation;

        public AIPickUpAndDropAttack(EntityChiromawMatriarch large_chiromaw, double speedIn, boolean useLongMemory) {
            this.largeChiromaw = large_chiromaw;
            this.world = this.largeChiromaw.field_70170_p;
            this.speedTowardsTarget = speedIn;
            this.longMemory = useLongMemory;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.largeChiromaw.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.delayCounter <= 0) {
                    this.path = this.largeChiromaw.func_70661_as().func_75494_a((Entity)entitylivingbase);
                    this.delayCounter = 4 + this.largeChiromaw.func_70681_au().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.largeChiromaw.func_70661_as().func_75494_a((Entity)entitylivingbase);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(entitylivingbase) >= this.largeChiromaw.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.largeChiromaw.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (this.largeChiromaw.func_184207_aI()) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (!this.longMemory) {
                return !this.largeChiromaw.func_70661_as().func_75500_f();
            }
            if (!this.largeChiromaw.func_180485_d(new BlockPos((Entity)entitylivingbase))) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).func_175149_v() && !((EntityPlayer)entitylivingbase).func_184812_l_();
        }

        public void func_75249_e() {
            this.largeChiromaw.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
            this.delayCounter = 0;
        }

        public void func_75251_c() {
            EntityLivingBase entitylivingbase = this.largeChiromaw.func_70638_az();
            if (entitylivingbase instanceof EntityPlayer && (((EntityPlayer)entitylivingbase).func_175149_v() || ((EntityPlayer)entitylivingbase).func_184812_l_())) {
                this.largeChiromaw.func_70624_b(null);
            }
            this.largeChiromaw.func_70661_as().func_75499_g();
            this.rotation = 0.0f;
            EntityChiromawMatriarch.this.setIsSpinning(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.largeChiromaw.func_70638_az();
            if (entitylivingbase == null) {
                return;
            }
            if (!this.largeChiromaw.getIsSpinning()) {
                this.largeChiromaw.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            }
            double distToEnemySqr = this.largeChiromaw.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
            --this.delayCounter;
            if (!this.largeChiromaw.func_184207_aI()) {
                if ((this.longMemory || this.largeChiromaw.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.largeChiromaw.func_70681_au().nextFloat() < 0.05f)) {
                    this.targetX = entitylivingbase.field_70165_t;
                    this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
                    this.targetZ = entitylivingbase.field_70161_v;
                    this.delayCounter = 4 + this.largeChiromaw.func_70681_au().nextInt(7);
                    if (this.canPenalize) {
                        PathPoint finalPathPoint;
                        this.delayCounter += this.failedPathFindingPenalty;
                        this.failedPathFindingPenalty = this.largeChiromaw.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.largeChiromaw.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                    }
                    if (distToEnemySqr > 1024.0) {
                        this.delayCounter += 10;
                    } else if (distToEnemySqr > 256.0) {
                        this.delayCounter += 5;
                    }
                    if (!this.largeChiromaw.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget)) {
                        this.delayCounter += 15;
                    }
                }
                if (this.largeChiromaw.field_70146_Z.nextBoolean()) {
                    this.checkAndPerformDropAttack(entitylivingbase, distToEnemySqr);
                } else {
                    this.checkAndPerformSpinAttack(entitylivingbase, distToEnemySqr);
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if (this.largeChiromaw.func_184207_aI()) {
                if (entitylivingbase != null && !this.world.func_175623_d(this.largeChiromaw.func_180425_c().func_177979_c(3)) || (double)this.largeChiromaw.func_180425_c().func_177956_o() < this.largeChiromaw.pickupHeight + 16.0) {
                    this.largeChiromaw.func_70661_as().func_75499_g();
                    Vec3d vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.largeChiromaw, (int)16, (int)10, (Vec3d)new Vec3d((double)this.largeChiromaw.getBoundOrigin().func_177958_n() + 0.5, (double)this.largeChiromaw.getBoundOrigin().func_177956_o() + 0.5, (double)this.largeChiromaw.getBoundOrigin().func_177952_p() + 0.5));
                    if (vec3d != null) {
                        this.largeChiromaw.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 2.0);
                    }
                    this.largeChiromaw.field_70181_x += 0.05;
                }
                if (!this.world.field_72995_K && (this.largeChiromaw.field_70163_u >= this.largeChiromaw.pickupHeight + 16.0 || this.largeChiromaw.getDroppingTimer() <= 0 || !this.world.field_72995_K && this.world.isSideSolid(new BlockPos(MathHelper.func_76128_c((double)this.largeChiromaw.field_70165_t), MathHelper.func_76128_c((double)(this.largeChiromaw.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.largeChiromaw.field_70161_v)), EnumFacing.DOWN))) {
                    this.largeChiromaw.setReturnToNest(true);
                    this.largeChiromaw.func_184226_ay();
                    this.largeChiromaw.func_130014_f_().func_184133_a(null, this.largeChiromaw.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_RELEASE, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat() - this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
                }
                if (this.largeChiromaw.getDroppingTimer() >= 0 && this.attackTick <= 0) {
                    this.largeChiromaw.func_70652_k((Entity)entitylivingbase);
                    this.attackTick = 20;
                }
                if (this.largeChiromaw.getDroppingTimer() >= 0) {
                    this.largeChiromaw.setDroppingTimer(EntityChiromawMatriarch.this.getDroppingTimer() - 1);
                }
            }
            if (this.largeChiromaw.getIsSpinning()) {
                this.rotation += 30.0f;
                if (this.rotation % 30.0f == 0.0f) {
                    Vec3d targetVector = new Vec3d(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v);
                    Vec3d chiromawVectorToTarget = new Vec3d(this.largeChiromaw.field_70165_t, this.largeChiromaw.field_70163_u, this.largeChiromaw.field_70161_v).func_178788_d(targetVector);
                    double height = chiromawVectorToTarget.field_72448_b;
                    double distance = chiromawVectorToTarget.func_72433_c();
                    double angle = MathHelper.func_181159_b((double)height, (double)distance) * 57.29577951308232;
                    EntityBLArrow arrow = new EntityBLArrow(this.world, (EntityLivingBase)this.largeChiromaw);
                    arrow.setType(EnumArrowType.CHIROMAW_BARB);
                    arrow.func_184547_a((Entity)this.largeChiromaw, (float)angle, this.rotation, 1.5f, 0.5f, 0.5f);
                    this.largeChiromaw.func_130014_f_().func_184133_a(null, this.largeChiromaw.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_BARB_FIRE, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat() - this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
                    this.world.func_72838_d((Entity)arrow);
                }
                if (this.rotation >= 720.0f) {
                    this.rotation = 0.0f;
                    EntityChiromawMatriarch.this.setIsSpinning(false);
                }
            }
        }

        private void checkAndPerformSpinAttack(EntityLivingBase entitylivingbase, double distToEnemySqr) {
            if (!(distToEnemySqr >= 36.0) || !(distToEnemySqr <= 100.0) || this.attackTick > 0) {
                return;
            }
            this.largeChiromaw.func_130014_f_().func_184133_a(null, this.largeChiromaw.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_ROAR, SoundCategory.HOSTILE, 1.0f, 1.0f + (this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat() - this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
            this.attackTick = 40;
            this.largeChiromaw.setIsSpinning(true);
        }

        protected void checkAndPerformDropAttack(EntityLivingBase enemy, double distToEnemySqr) {
            double attackReachSq = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= attackReachSq && this.attackTick <= 0) {
                this.attackTick = 20;
                this.largeChiromaw.func_70664_aZ();
                this.largeChiromaw.func_184609_a(EnumHand.MAIN_HAND);
                this.largeChiromaw.func_70652_k((Entity)enemy);
                this.largeChiromaw.func_130014_f_().func_184133_a(null, this.largeChiromaw.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_GRAB, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat() - this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
                enemy.func_184205_a((Entity)this.largeChiromaw, true);
                this.largeChiromaw.pickupHeight = this.largeChiromaw.field_70163_u;
                this.largeChiromaw.setDroppingTimer(120);
            }
        }

        protected double getAttackReachSqr(EntityLivingBase attackTarget) {
            return this.largeChiromaw.field_70130_N * 2.0f * this.largeChiromaw.field_70130_N * 2.0f + attackTarget.field_70130_N;
        }
    }

    class AIFindNearestTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        protected double baseRange;
        protected double revengeRange;

        public AIFindNearestTarget(EntityCreature creature, Class<T> classTarget, boolean checkSight, double rangeIn) {
            super(creature, classTarget, checkSight);
            this.baseRange = this.revengeRange = rangeIn;
        }

        public AIFindNearestTarget(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, @Nullable boolean onlyNearby, Predicate<? super T> targetSelector) {
            super(creature, classTarget, chance, checkSight, onlyNearby, targetSelector);
        }

        public boolean func_75250_a() {
            if (super.func_75250_a()) {
                double distance;
                if (this.field_75309_a != null && (distance = this.field_75299_d.func_70068_e((Entity)this.field_75309_a)) <= 256.0) {
                    this.field_75299_d.func_130014_f_().func_184133_a(null, this.field_75299_d.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_ROAR, SoundCategory.HOSTILE, 2.0f, 1.5f);
                }
                return true;
            }
            return false;
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, targetDistance);
        }

        protected double func_111175_f() {
            if (EntityChiromawMatriarch.this.func_70643_av() != null) {
                EntityChiromawMatriarch.this.func_70624_b(EntityChiromawMatriarch.this.func_70643_av());
                this.revengeRange = EntityChiromawMatriarch.this.func_70032_d((Entity)EntityChiromawMatriarch.this.func_70643_av());
            }
            return Math.max(this.baseRange, this.revengeRange);
        }
    }

    public class AIPoop
    extends EntityAIBase {
        private final EntityChiromawMatriarch largeChiromaw;

        public AIPoop(EntityChiromawMatriarch large_chiromaw) {
            this.func_75248_a(0);
            this.largeChiromaw = large_chiromaw;
        }

        public boolean func_75250_a() {
            return !this.largeChiromaw.getIsNesting() && this.largeChiromaw.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            this.checkForPoopTarget();
        }

        private void checkForPoopTarget() {
            EntityPlayer player;
            AxisAlignedBB underBox;
            int distanceToSurface = MathHelper.func_76128_c((double)this.largeChiromaw.field_70163_u) - this.largeChiromaw.field_70170_p.func_175645_m(new BlockPos((Entity)this.largeChiromaw)).func_177956_o();
            ArrayList<BlockPos> placeToPoop = new ArrayList<BlockPos>();
            if (distanceToSurface >= 16 && !this.getPoopTarget(EntityChiromawMatriarch.this.field_70170_p, underBox = this.largeChiromaw.func_174813_aQ().func_72314_b(0.625, (double)distanceToSurface, 0.625).func_72317_d(0.0, (double)(-distanceToSurface) / 2.0, 0.0)).isEmpty() && (player = this.getPoopTarget(EntityChiromawMatriarch.this.field_70170_p, underBox).get(0)) != null) {
                for (BlockPos posDrop : BlockPos.func_177980_a((BlockPos)player.func_180425_c().func_177982_a(-1, 0, -1), (BlockPos)player.func_180425_c().func_177982_a(1, 2, 1))) {
                    if (!EntityChiromawMatriarch.this.field_70170_p.func_175623_d(posDrop) || !EntityChiromawMatriarch.this.field_70170_p.func_175678_i(posDrop)) continue;
                    placeToPoop.add(posDrop);
                }
                if (!placeToPoop.isEmpty()) {
                    Collections.shuffle(placeToPoop);
                    BlockPos posPoop = (BlockPos)placeToPoop.get(0);
                    EntityChiromawDroppings poopEntity = new EntityChiromawDroppings(EntityChiromawMatriarch.this.field_70170_p, (EntityLivingBase)this.largeChiromaw, (double)posPoop.func_177958_n() + 0.5, this.largeChiromaw.func_180425_c().func_177956_o(), (double)posPoop.func_177952_p() + 0.5);
                    EntityChiromawMatriarch.this.field_70170_p.func_72838_d((Entity)poopEntity);
                    this.largeChiromaw.func_130014_f_().func_184133_a(null, this.largeChiromaw.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_POOP, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat() - this.largeChiromaw.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
                }
            }
        }

        public List<EntityPlayer> getPoopTarget(World world, AxisAlignedBB underBox) {
            return world.func_175647_a(EntityPlayer.class, underBox, EntitySelectors.field_94557_a);
        }
    }
}

