/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityAshSprite
extends EntityMob
implements IEntityBL {
    protected static final byte EVENT_ENABLE_NO_CLIP = 80;
    protected static final byte EVENT_DISABLE_NO_CLIP = 81;
    protected static final DataParameter<Byte> ASH_SPRITE_FLAGS = EntityDataManager.func_187226_a(EntityAshSprite.class, (DataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockPos boundOrigin;
    private boolean canNoClip = true;
    private int noClipTimeout = 0;

    public EntityAshSprite(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(0.4f, 0.8f);
        this.field_70728_aV = 3;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.noClipTimeout > 0) {
                if (this.canNoClip) {
                    this.canNoClip = false;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)81);
                }
                --this.noClipTimeout;
            } else {
                if (!this.canNoClip) {
                    this.canNoClip = true;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)80);
                }
                this.noClipTimeout = 0;
            }
        }
        this.field_70145_X = this.canNoClip || !this.func_70058_J();
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.func_130014_f_().field_72995_K) {
            this.spawnParticles(this.func_130014_f_(), this.func_180425_c(), this.field_70146_Z);
        }
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 80) {
            this.canNoClip = true;
        } else if (id == 81) {
            this.canNoClip = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            worldIn.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, (double)pos.func_177958_n() + 0.5 + (double)(rand.nextBoolean() ? -0.5f : 0.5f) * Math.pow(rand.nextFloat(), 1.0), (double)pos.func_177956_o() + 0.5 + (double)rand.nextFloat() - 0.5, (double)pos.func_177952_p() + 0.5 + (double)(rand.nextBoolean() ? -0.5f : 0.5f) * Math.pow(rand.nextFloat(), 1.0), 0.0, 0.2, 0.0, new int[0]);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityAshSprite.class}));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ASH_SPRITE_FLAGS, (Object)0);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ASH_SPRITE;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.ASHSPRITE_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.ASHSPRITE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.ASHSPRITE_DEATH;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("BoundX")) {
            this.boundOrigin = new BlockPos(compound.func_74762_e("BoundX"), compound.func_74762_e("BoundY"), compound.func_74762_e("BoundZ"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.boundOrigin != null) {
            compound.func_74768_a("BoundX", this.boundOrigin.func_177958_n());
            compound.func_74768_a("BoundY", this.boundOrigin.func_177956_o());
            compound.func_74768_a("BoundZ", this.boundOrigin.func_177952_p());
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        if (super.func_70097_a(source, damage)) {
            this.noClipTimeout = 60;
            return true;
        }
        return false;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    private boolean getAshSpriteFlag(int mask) {
        byte i = (Byte)this.field_70180_af.func_187225_a(ASH_SPRITE_FLAGS);
        return (i & mask) != 0;
    }

    private void setAshSpriteFlag(int mask, boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(ASH_SPRITE_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_70180_af.func_187227_b(ASH_SPRITE_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getAshSpriteFlag(1);
    }

    public void setCharging(boolean charging) {
        this.setAshSpriteFlag(1, charging);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    class AIMoveRandom
    extends EntityAIBase {
        private final EntityAshSprite ashSprite;

        public AIMoveRandom(EntityAshSprite ash_sprite) {
            this.func_75248_a(1);
            this.ashSprite = ash_sprite;
        }

        public boolean func_75250_a() {
            return !this.ashSprite.func_70605_aq().func_75640_a() && this.ashSprite.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = this.ashSprite.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)this.ashSprite);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.ashSprite.field_70146_Z.nextInt(15) - 7, this.ashSprite.field_70146_Z.nextInt(11) - 5, this.ashSprite.field_70146_Z.nextInt(15) - 7);
                if (!this.ashSprite.field_70170_p.func_175623_d(blockpos1)) continue;
                this.ashSprite.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (this.ashSprite.func_70638_az() != null) break;
                this.ashSprite.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        private final EntityAshSprite ashSprite;

        public AIMoveControl(EntityAshSprite ash_sprite) {
            super((EntityLiving)ash_sprite);
            this.ashSprite = ash_sprite;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.ashSprite.field_70165_t;
                double d1 = this.field_75647_c - this.ashSprite.field_70163_u;
                double d2 = this.field_75644_d - this.ashSprite.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < this.ashSprite.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    this.ashSprite.field_70159_w *= 0.5;
                    this.ashSprite.field_70181_x *= 0.5;
                    this.ashSprite.field_70179_y *= 0.5;
                } else {
                    this.ashSprite.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    this.ashSprite.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    this.ashSprite.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (this.ashSprite.func_70638_az() == null) {
                        this.ashSprite.field_70761_aq = this.ashSprite.field_70177_z = -((float)MathHelper.func_181159_b((double)this.ashSprite.field_70159_w, (double)this.ashSprite.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = this.ashSprite.func_70638_az().field_70165_t - this.ashSprite.field_70165_t;
                        double d5 = this.ashSprite.func_70638_az().field_70161_v - this.ashSprite.field_70161_v;
                        this.ashSprite.field_70761_aq = this.ashSprite.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        private final EntityAshSprite ashSprite;

        public AIChargeAttack(EntityAshSprite ash_sprite) {
            this.func_75248_a(1);
            this.ashSprite = ash_sprite;
        }

        public boolean func_75250_a() {
            if (this.ashSprite.func_70638_az() != null && !this.ashSprite.func_70605_aq().func_75640_a() && this.ashSprite.field_70146_Z.nextInt(7) == 0) {
                return this.ashSprite.func_70068_e((Entity)this.ashSprite.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.ashSprite.func_70605_aq().func_75640_a() && this.ashSprite.isCharging() && this.ashSprite.func_70638_az() != null && this.ashSprite.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase target = this.ashSprite.func_70638_az();
            if (target != null) {
                Vec3d vec3d = target.func_174824_e(1.0f);
                this.ashSprite.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                this.ashSprite.setCharging(true);
            }
        }

        public void func_75251_c() {
            this.ashSprite.setCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase target = this.ashSprite.func_70638_az();
            if (target != null) {
                if (this.ashSprite.func_174813_aQ().func_72326_a(target.func_174813_aQ())) {
                    this.ashSprite.func_70652_k((Entity)target);
                    this.ashSprite.setCharging(false);
                } else {
                    double d0 = this.ashSprite.func_70068_e((Entity)target);
                    if (d0 < 9.0) {
                        Vec3d vec3d = target.func_174824_e(1.0f);
                        this.ashSprite.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                    }
                }
            }
        }
    }
}

