/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.draeton;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thebetweenlands.api.entity.IPullerEntity;
import thebetweenlands.common.entity.draeton.DraetonPhysicsPart;
import thebetweenlands.common.entity.draeton.EntityDraeton;
import thebetweenlands.common.entity.mobs.EntityFirefly;

public class EntityPullerFirefly
extends EntityFirefly
implements IPullerEntity,
IEntityAdditionalSpawnData {
    private int carriageId;
    private int pullerId;
    private DraetonPhysicsPart puller;

    public EntityPullerFirefly(World world) {
        super(world);
    }

    public EntityPullerFirefly(World world, EntityDraeton carriage, DraetonPhysicsPart puller) {
        super(world);
        this.setPuller(carriage, puller);
    }

    public String func_70005_c_() {
        return I18n.func_74838_a((String)"entity.thebetweenlands.firefly.name");
    }

    @Override
    public EntityDraeton getCarriage() {
        Entity entity = this.field_70170_p.func_73045_a(this.carriageId);
        return entity instanceof EntityDraeton ? (EntityDraeton)entity : null;
    }

    @Override
    public void setPuller(EntityDraeton carriage, DraetonPhysicsPart puller) {
        this.puller = puller;
        this.pullerId = puller.id;
        this.carriageId = carriage.func_145782_y();
    }

    @Override
    public float getPull(float pull) {
        return pull * 0.15f;
    }

    @Override
    public float getCarriageDrag(float drag) {
        return 1.0f - (1.0f - drag) * 0.5f;
    }

    @Override
    public float getDrag(float drag) {
        return drag;
    }

    @Override
    public Entity createReleasedEntity() {
        EntityFirefly entity = new EntityFirefly(this.field_70170_p);
        entity.func_70020_e(this.func_189511_e(new NBTTagCompound()));
        entity.func_94061_f(false);
        entity.func_184221_a(UUID.randomUUID());
        entity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        return entity;
    }

    @Override
    public void spawnReleasedEntity() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d(this.createReleasedEntity());
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_175446_cd() {
        if (this.puller != null) {
            return this.puller.carriage.isControlling(this.puller);
        }
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.puller == null || !this.puller.isActive) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70089_S()) {
                    this.func_70106_y();
                }
            } else {
                DraetonPhysicsPart puller;
                Entity entity = this.field_70170_p.func_73045_a(this.carriageId);
                if (entity instanceof EntityDraeton && (puller = ((EntityDraeton)entity).getPhysicsPartById(this.pullerId)) != null) {
                    this.puller = puller;
                    puller.setEntity(this);
                }
            }
        } else if (this.puller.carriage.isControlling(this.puller)) {
            this.func_70080_a(this.puller.x, this.puller.y, this.puller.z, 0.0f, 0.0f);
            this.field_70759_as = this.field_70761_aq = (float)Math.toDegrees(Math.atan2(this.puller.motionZ, this.puller.motionX)) - 90.0f;
            this.field_70177_z = this.field_70761_aq;
            this.field_70125_A = (float)Math.toDegrees(-Math.atan2(this.puller.motionY, Math.sqrt(this.puller.motionX * this.puller.motionX + this.puller.motionZ * this.puller.motionZ)));
            this.field_70122_E = false;
        } else {
            this.puller.x = this.field_70165_t;
            this.puller.y = this.field_70163_u;
            this.puller.z = this.field_70161_v;
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.carriageId);
        buffer.writeInt(this.pullerId);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.carriageId = buffer.readInt();
        this.pullerId = buffer.readInt();
    }
}

