/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.draeton;

import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import thebetweenlands.common.entity.draeton.EntityDraeton;

public class EntityDraetonInteractionPart
extends MultiPartEntityPart {
    private final EntityDraeton draeton;
    private final boolean isCarriage;
    private boolean enabled = true;
    private static final String translationBase = "entity.thebetweenlands.draeton";

    EntityDraetonInteractionPart(EntityDraeton draeton, String name, float width, float height, boolean isCarriage) {
        super((IEntityMultiPart)draeton, name, width, height);
        this.draeton = draeton;
        this.isCarriage = isCarriage;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String func_70005_c_() {
        String name = "";
        if (this.field_146032_b.matches("upgrade_([1-4])")) {
            name = this.getUpgradeName(Integer.parseInt(this.field_146032_b.substring(8)) - 1);
        } else if (this.field_146032_b.equals("upgrade_anchor")) {
            name = "entity.thebetweenlands.draeton_upgrade_anchor.name";
        } else if (this.field_146032_b.equals("burner")) {
            name = "entity.thebetweenlands.draeton_burner.name";
        } else if (this.field_146032_b.startsWith("balloon")) {
            name = "entity.thebetweenlands.draeton_balloon.name";
        } else if (this.field_146032_b.equals("gui")) {
            name = "entity.thebetweenlands.draeton.name";
        } else if (this.field_146032_b.startsWith("leakage")) {
            name = "entity.thebetweenlands.draeton_leakage.name";
        }
        return I18n.func_74838_a((String)name);
    }

    private String getUpgradeName(int index) {
        ItemStack stack = this.draeton.getUpgradesInventory().func_70301_a(index);
        if (this.draeton.isFurnaceUpgrade(stack)) {
            return "entity.thebetweenlands.draeton_upgrade_furnace.name";
        }
        if (this.draeton.isStorageUpgrade(stack)) {
            return stack.func_82833_r();
        }
        if (this.draeton.isCraftingUpgrade(stack)) {
            return "entity.thebetweenlands.draeton_upgrade_crafting.name";
        }
        return "";
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return this.draeton.interactFromMultipart(this, player, hand);
    }

    public boolean func_70067_L() {
        if (!this.enabled) {
            return false;
        }
        if (this.isCarriage) {
            return this.draeton.func_70067_L();
        }
        return true;
    }

    public boolean canRiderInteract() {
        if (this.isCarriage) {
            return this.draeton.canRiderInteract();
        }
        return super.canRiderInteract();
    }

    public Entity func_184208_bv() {
        if (this.isCarriage) {
            return this.draeton;
        }
        return super.func_184208_bv();
    }
}

