/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import thebetweenlands.common.entity.ai.EntityAITargetNonCreature;

public class EntityAINearestAttackableTargetNonCreature<T extends EntityLivingBase>
extends EntityAITargetNonCreature {
    protected final Class<T> targetClass;
    private final int targetChance;
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super T> targetEntitySelector;
    protected T targetEntity;

    public EntityAINearestAttackableTargetNonCreature(EntityLiving creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public EntityAINearestAttackableTargetNonCreature(EntityLiving creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public EntityAINearestAttackableTargetNonCreature(EntityLiving creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, final @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate<T>(){

            public boolean apply(@Nullable T p_apply_1_) {
                return p_apply_1_ == null ? false : (targetSelector != null && !targetSelector.apply(p_apply_1_) ? false : (!EntitySelectors.field_180132_d.apply(p_apply_1_) ? false : EntityAINearestAttackableTargetNonCreature.this.isSuitableTarget((EntityLivingBase)p_apply_1_, false)));
            }
        };
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.taskOwner.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass != EntityPlayer.class && this.targetClass != EntityPlayerMP.class) {
            List list = this.taskOwner.func_130014_f_().func_175647_a(this.targetClass, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector);
            if (list.isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (EntityLivingBase)list.get(0);
            return true;
        }
        this.targetEntity = this.taskOwner.func_130014_f_().func_184150_a(this.taskOwner.field_70165_t, this.taskOwner.field_70163_u + (double)this.taskOwner.func_70047_e(), this.taskOwner.field_70161_v, this.getTargetDistance(), this.getTargetDistance(), (Function)new Function<EntityPlayer, Double>(){

            @Nullable
            public Double apply(@Nullable EntityPlayer p_apply_1_) {
                ItemStack itemstack = p_apply_1_.func_184582_a(EntityEquipmentSlot.HEAD);
                if (itemstack != null && itemstack.func_77973_b() == Items.field_151144_bL) {
                    boolean flag2;
                    int i = itemstack.func_77952_i();
                    boolean flag = EntityAINearestAttackableTargetNonCreature.this.taskOwner instanceof EntitySkeleton && i == 0;
                    boolean flag1 = EntityAINearestAttackableTargetNonCreature.this.taskOwner instanceof EntityZombie && i == 2;
                    boolean bl = flag2 = EntityAINearestAttackableTargetNonCreature.this.taskOwner instanceof EntityCreeper && i == 4;
                    if (flag || flag1 || flag2) {
                        return 0.5;
                    }
                }
                return 1.0;
            }
        }, this.targetEntitySelector);
        return this.targetEntity != null;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.taskOwner.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    @Override
    public void func_75249_e() {
        this.taskOwner.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

