/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.entity.EntityProximitySpawner;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityTriggeredFallingBlock
extends EntityProximitySpawner {
    private static final DataParameter<Boolean> IS_WALK_WAY = EntityDataManager.func_187226_a(EntityTriggeredFallingBlock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_HANGING = EntityDataManager.func_187226_a(EntityTriggeredFallingBlock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_TEMP = EntityDataManager.func_187226_a(EntityTriggeredFallingBlock.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityTriggeredFallingBlock(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_189654_d(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_WALK_WAY, (Object)false);
        this.field_70180_af.func_187214_a(IS_HANGING, (Object)false);
        this.field_70180_af.func_187214_a(IS_TEMP, (Object)false);
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isTemporary() && this.field_70173_aa > 20) {
                this.func_70106_y();
            }
            if (this.func_130014_f_().func_82737_E() % 5L == 0L) {
                if (!this.isHanging()) {
                    this.checkArea();
                } else {
                    this.checkBlockAbove();
                }
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            this.dustParticles();
        }
    }

    private void checkBlockAbove() {
        if (this.func_130014_f_().func_175623_d(this.func_180425_c().func_177984_a())) {
            Entity spawn = this.getEntitySpawned();
            if (spawn != null) {
                this.performPreSpawnaction((Entity)this, spawn);
                if (!spawn.field_70128_L) {
                    this.func_130014_f_().func_72838_d(spawn);
                }
            }
            if (!this.field_70128_L && this.isSingleUse()) {
                this.func_70106_y();
            }
        }
    }

    public void dustParticles() {
        if (this.field_70146_Z.nextInt(16) == 0) {
            BlockPos blockpos = this.func_180425_c().func_177977_b();
            if (EntityTriggeredFallingBlock.canFallThrough(this.func_130014_f_().func_180495_p(blockpos))) {
                double d0 = (float)this.func_180425_c().func_177958_n() + this.field_70146_Z.nextFloat();
                double d1 = !this.isWalkway() ? (double)this.func_180425_c().func_177956_o() - 0.05 : (double)this.func_180425_c().func_177956_o() + 1.0;
                double d2 = (float)this.func_180425_c().func_177952_p() + this.field_70146_Z.nextFloat();
                if (!this.isWalkway()) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)this.getBlockType(this.func_130014_f_(), this.func_180425_c()))});
                } else {
                    double motionX = this.func_130014_f_().field_73012_v.nextDouble() * (double)0.1f - (double)0.05f;
                    double motionY = this.func_130014_f_().field_73012_v.nextDouble() * (double)0.025f + (double)0.025f;
                    double motionZ = this.func_130014_f_().field_73012_v.nextDouble() * (double)0.1f - (double)0.05f;
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_DUST, d0, d1, d2, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)this.getBlockType(this.func_130014_f_(), this.func_180425_c()))});
                }
            }
        }
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    @Override
    protected void performPreSpawnaction(Entity targetEntity, Entity entitySpawned) {
        ((EntityFallingBlock)entitySpawned).func_145806_a(true);
        if (!this.func_130014_f_().field_72995_K) {
            targetEntity.func_130014_f_().func_184133_a(null, targetEntity.func_180425_c(), (SoundEvent)SoundRegistry.ROOF_COLLAPSE, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    protected boolean func_70610_aX() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70024_g(double x, double y, double z) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        Entity sourceEntity;
        if (source instanceof EntityDamageSource && (sourceEntity = ((EntityDamageSource)source).func_76346_g()) instanceof EntityPlayer && ((EntityPlayer)sourceEntity).func_184812_l_()) {
            this.func_70106_y();
        }
        return false;
    }

    @Override
    protected float getProximityHorizontal() {
        return this.isWalkway() ? 0.0625f : 1.0f;
    }

    @Override
    protected float getProximityVertical() {
        return 1.0f;
    }

    @Override
    protected AxisAlignedBB proximityBox() {
        return new AxisAlignedBB(this.func_180425_c()).func_72314_b((double)this.getProximityHorizontal(), (double)this.getProximityVertical(), (double)this.getProximityHorizontal()).func_72317_d(0.0, this.isWalkway() ? 1.0 : (double)(-this.getProximityVertical() * 2.0f), 0.0);
    }

    @Override
    protected boolean canSneakPast() {
        return true;
    }

    @Override
    protected boolean checkSight() {
        return false;
    }

    @Override
    protected Entity getEntitySpawned() {
        if (this.getBlockType(this.func_130014_f_(), this.func_180425_c()).func_177230_c() != null) {
            EntityFallingBlock entity = new EntityFallingBlock(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getBlockType(this.func_130014_f_(), this.func_180425_c()));
            entity.field_145813_c = false;
            return entity;
        }
        return null;
    }

    private IBlockState getBlockType(World world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    @Override
    protected int getEntitySpawnCount() {
        return 1;
    }

    @Override
    protected boolean isSingleUse() {
        return true;
    }

    @Override
    protected int maxUseCount() {
        return 0;
    }

    public void setWalkway(boolean walkway) {
        this.field_70180_af.func_187227_b(IS_WALK_WAY, (Object)walkway);
    }

    public boolean isWalkway() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_WALK_WAY);
    }

    public boolean isHanging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HANGING);
    }

    public void setHanging(boolean walkway) {
        this.field_70180_af.func_187227_b(IS_HANGING, (Object)walkway);
    }

    public boolean isTemporary() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_TEMP);
    }

    public void setTemporary(boolean temp) {
        this.field_70180_af.func_187227_b(IS_TEMP, (Object)temp);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setWalkway(nbt.func_74767_n("walk_way"));
        this.setHanging(nbt.func_74767_n("hanging"));
        this.setTemporary(nbt.func_74767_n("temp"));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("walk_way", this.isWalkway());
        nbt.func_74757_a("hanging", this.isHanging());
        nbt.func_74757_a("temp", this.isTemporary());
    }
}

