/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityResurrection
extends Entity {
    protected static final byte EVENT_RESPAWN = 80;
    private Supplier<Vec3d> positionSupplier;
    private NBTTagCompound entityNbt;
    private int timer;
    private int resurrectionTime;
    private boolean respawning = false;

    public EntityResurrection(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityResurrection(World world, NBTTagCompound entityNbt, Supplier<Vec3d> positionSupplier, int resurrectionTime) {
        this(world);
        this.entityNbt = entityNbt;
        this.positionSupplier = positionSupplier;
        this.resurrectionTime = resurrectionTime;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.timer = compound.func_74762_e("respawnTimer");
        this.entityNbt = compound.func_74775_l("entityNbt");
        this.resurrectionTime = compound.func_74762_e("resurrectionTime");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("respawnTimer", this.timer);
        compound.func_74782_a("entityNbt", (NBTBase)this.entityNbt);
        compound.func_74768_a("resurrectionTime", this.resurrectionTime);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            Vec3d newPosition;
            if (this.positionSupplier != null && (newPosition = this.positionSupplier.get()) != null) {
                this.func_70012_b(newPosition.field_72450_a, newPosition.field_72448_b, newPosition.field_72449_c, this.field_70177_z, this.field_70125_A);
            }
            if (this.timer++ > this.resurrectionTime - 20) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)80);
                if (this.timer > this.resurrectionTime) {
                    Entity entity;
                    if (this.field_70170_p instanceof WorldServer && (entity = EntityList.func_75615_a((NBTTagCompound)this.entityNbt, (World)this.field_70170_p)) != null) {
                        if (entity.func_184222_aU() && ((WorldServer)this.field_70170_p).func_175733_a(entity.func_110124_au()) == null) {
                            if (entity instanceof EntityLivingBase) {
                                EntityLivingBase living = (EntityLivingBase)entity;
                                living.func_70606_j(Math.max(living.func_110143_aJ(), living.func_110138_aP() * 0.5f));
                            }
                            entity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                            entity.field_70179_y = 0.0;
                            entity.field_70181_x = 0.0;
                            entity.field_70159_w = 0.0;
                            this.field_70170_p.func_72838_d(entity);
                            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.RESURRECTION, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        } else {
                            entity.func_70106_y();
                        }
                    }
                    this.func_70106_y();
                }
            }
        } else if (this.respawning) {
            this.spawnParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 80) {
            this.respawning = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        for (int i = 0; i < 3; ++i) {
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_NEAREST_NEIGHBOR, BLParticles.SMOOTH_SMOKE.create(this.field_70170_p, this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f), this.field_70163_u + 1.0 + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f), this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f), (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f)).withScale(16.0f)).withColor(1.0f, 1.0f, 1.0f, 0.5f)).withData(40, true, Float.valueOf(0.0f), true)));
        }
    }
}

