/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.block.misc.BlockMistBridge;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityMistBridge
extends EntityCreature
implements IEntityBL {
    public boolean startExtention;
    public boolean startRetraction;
    private int matchDistance = 0;

    public EntityMistBridge(World world) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
        this.func_189654_d(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            int index;
            List<BlockPos> pos;
            if (this.startExtention && this.field_70170_p.func_82737_E() % 1L == 0L) {
                pos = this.matchDistance(this.field_70170_p, this.matchDistance);
                if (!pos.isEmpty()) {
                    for (index = 0; index < pos.size(); ++index) {
                        this.field_70170_p.func_180501_a(pos.get(index), this.getTempBlock(), 2);
                    }
                }
                if (this.matchDistance < 16) {
                    ++this.matchDistance;
                }
                if (this.matchDistance >= 16) {
                    this.startExtention = false;
                    this.matchDistance = 0;
                }
            }
            if (this.startRetraction) {
                pos = this.matchDistance(this.field_70170_p, this.matchDistance);
                if (!pos.isEmpty()) {
                    for (index = 0; index < pos.size(); ++index) {
                        this.restoreBlocks(pos.get(index));
                    }
                }
                if (this.matchDistance < 16) {
                    ++this.matchDistance;
                }
                if (this.matchDistance >= 16) {
                    this.func_70106_y();
                }
            }
            if (this.field_70173_aa > 1) {
                if (this.isMist() && (this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() != BlockRegistry.MIST_BRIDGE || this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() == BlockRegistry.MIST_BRIDGE && !((Boolean)this.field_70170_p.func_180495_p(this.func_180425_c()).func_177229_b((IProperty)BlockMistBridge.SOLID)).booleanValue() || this.field_70173_aa >= 200)) {
                    if (!this.startRetraction) {
                        this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), (SoundEvent)SoundRegistry.MIST_STAFF_VANISH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    this.startRetraction = true;
                }
                if (!this.isMist() && this.field_70173_aa >= 200) {
                    if (!this.startRetraction) {
                        this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), (SoundEvent)SoundRegistry.MIST_STAFF_VANISH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    this.startRetraction = true;
                }
            }
        }
    }

    public boolean func_70058_J() {
        return true;
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70024_g(double x, double y, double z) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public boolean isMist() {
        NBTTagCompound entityNbt = this.getEntityData();
        return entityNbt.func_74767_n("isMist");
    }

    public IBlockState getTempBlock() {
        if (!this.isMist()) {
            return BlockRegistry.SHADOW_WALKER.func_176223_P();
        }
        return BlockRegistry.MIST_BRIDGE.func_176223_P();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_130014_f_().field_72995_K) {
            this.startExtention = true;
        }
        return livingdata;
    }

    public void setBlockList(List<Integer> blockDistance, List<BlockPos> convertPos, boolean isMist) {
        NBTTagList distanceList = new NBTTagList();
        NBTTagList posList = new NBTTagList();
        NBTTagList stateList = new NBTTagList();
        NBTTagCompound entityNbt = this.getEntityData();
        for (int blockCount = 0; blockCount < convertPos.size(); ++blockCount) {
            NBTTagCompound tagPos = NBTUtil.func_186859_a((BlockPos)convertPos.get(blockCount));
            posList.func_74742_a((NBTBase)tagPos);
            IBlockState state = this.field_70170_p.func_180495_p(convertPos.get(blockCount));
            NBTTagCompound tagState = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)tagState, (IBlockState)state);
            stateList.func_74742_a((NBTBase)tagState);
            int distance = blockDistance.get(blockCount);
            NBTTagCompound tagDistance = new NBTTagCompound();
            tagDistance.func_74768_a("distance", distance);
            distanceList.func_74742_a((NBTBase)tagDistance);
        }
        if (!posList.func_82582_d() && !stateList.func_82582_d()) {
            entityNbt.func_74782_a("originPos", (NBTBase)posList);
            entityNbt.func_74782_a("tempBlockTypes", (NBTBase)stateList);
            entityNbt.func_74782_a("distance", (NBTBase)distanceList);
            entityNbt.func_74757_a("isMist", isMist);
        }
        this.func_70014_b(entityNbt);
    }

    public List<BlockPos> matchDistance(World world, int distanceIn) {
        NBTTagCompound entityNbt = this.getEntityData();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        NBTTagList posTagList = entityNbt.func_150295_c("originPos", 10);
        NBTTagList distanceTagList = entityNbt.func_150295_c("distance", 10);
        for (int indexCount = 0; indexCount < distanceTagList.func_74745_c(); ++indexCount) {
            if (distanceTagList.func_150305_b(indexCount).func_74762_e("distance") != distanceIn) continue;
            posList.add(NBTUtil.func_186861_c((NBTTagCompound)posTagList.func_150305_b(indexCount)));
        }
        return posList;
    }

    private void restoreBlocks(BlockPos blockPos) {
        NBTTagCompound entityNbt = this.getEntityData();
        NBTTagList posTagList = entityNbt.func_150295_c("originPos", 10);
        NBTTagList stateTagList = entityNbt.func_150295_c("tempBlockTypes", 10);
        for (int indexCount = 0; indexCount < posTagList.func_74745_c(); ++indexCount) {
            BlockPos origin = NBTUtil.func_186861_c((NBTTagCompound)posTagList.func_150305_b(indexCount));
            if (origin.func_177958_n() != blockPos.func_177958_n() || origin.func_177956_o() != blockPos.func_177956_o() || origin.func_177952_p() != blockPos.func_177952_p()) continue;
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)stateTagList.func_150305_b(indexCount));
            this.field_70170_p.func_180501_a(origin, state, 3);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        Entity sourceEntity;
        if (source instanceof EntityDamageSource && (sourceEntity = ((EntityDamageSource)source).func_76346_g()) instanceof EntityPlayer && ((EntityPlayer)sourceEntity).func_184812_l_()) {
            this.func_70106_y();
        }
        return false;
    }
}

