/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.Validate;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.common.item.herblore.ItemAspectVial;
import thebetweenlands.common.item.misc.ItemGlowingGoop;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.AspectRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityBLItemFrame
extends EntityItemFrame
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityBLItemFrame.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> INVISIBLE = EntityDataManager.func_187226_a(EntityBLItemFrame.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_GLOWING = EntityDataManager.func_187226_a(EntityBLItemFrame.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String TAG_COLOR = "DyeColor";
    protected static final Predicate<Entity> IS_HANGING_ENTITY = entity -> entity instanceof EntityHanging;
    private float itemDropChance = 1.0f;
    public EnumFacing realFacingDirection;

    public EntityBLItemFrame(World worldIn) {
        super(worldIn);
    }

    public EntityBLItemFrame(World worldIn, BlockPos pos, EnumFacing facing, int color) {
        super(worldIn, pos, facing);
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
        this.field_70180_af.func_187227_b(INVISIBLE, (Object)false);
        this.field_70180_af.func_187227_b(IS_GLOWING, (Object)false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(INVISIBLE, (Object)false);
        this.field_70180_af.func_187214_a(IS_GLOWING, (Object)false);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack held = this.func_82335_i();
        if (held.func_190926_b()) {
            return new ItemStack(ItemRegistry.ITEM_FRAME, 1, this.getColor());
        }
        return held.func_77946_l();
    }

    public void func_146065_b(@Nullable Entity entityIn, boolean p_146065_2_) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack itemstack = this.func_82335_i();
            if (entityIn instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    this.removeFrameFromMap(itemstack);
                    return;
                }
            }
            if (p_146065_2_) {
                this.func_70099_a(new ItemStack(ItemRegistry.ITEM_FRAME, 1, this.getColor()), 0.0f);
            }
            if (!itemstack.func_190926_b() && this.field_70146_Z.nextFloat() < this.itemDropChance) {
                itemstack = itemstack.func_77946_l();
                this.removeFrameFromMap(itemstack);
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public boolean func_70518_d() {
        if (this.realFacingDirection.func_176740_k() == EnumFacing.Axis.Y) {
            if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
                return false;
            }
            BlockPos blockpos = this.field_174861_a.func_177972_a(this.realFacingDirection.func_176734_d());
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (!(iblockstate.isSideSolid((IBlockAccess)this.field_70170_p, blockpos, this.realFacingDirection) || iblockstate.func_185904_a().func_76220_a() || BlockRedstoneDiode.func_185546_B((IBlockState)iblockstate))) {
                return false;
            }
            return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), IS_HANGING_ENTITY::test).isEmpty();
        }
        return super.func_70518_d();
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)((float)this.realFacingDirection.func_82601_c() * 0.25f), this.field_70163_u + (double)offsetY + (double)((float)this.realFacingDirection.func_96559_d() * 0.25f), this.field_70161_v + (double)((float)this.realFacingDirection.func_82599_e() * 0.25f), stack);
        entityitem.func_174869_p();
        if (this.realFacingDirection == EnumFacing.DOWN) {
            entityitem.field_70181_x = -Math.abs(entityitem.field_70181_x);
        }
        this.field_70170_p.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    private void removeFrameFromMap(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemMap) {
                MapData mapdata = ((ItemMap)stack.func_77973_b()).func_77873_a(stack, this.field_70170_p);
                mapdata.field_76203_h.remove("frame-" + this.func_145782_y());
            }
            stack.func_82842_a((EntityItemFrame)null);
            this.func_82334_a(ItemStack.field_190927_a);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a(TAG_COLOR, this.getColor());
        compound.func_74757_a("IS_INVISIBLE", ((Boolean)this.field_70180_af.func_187225_a(INVISIBLE)).booleanValue());
        compound.func_74757_a("IS_GLOWING", ((Boolean)this.field_70180_af.func_187225_a(IS_GLOWING)).booleanValue());
        compound.func_74774_a("REAL_FACING_DIRECTION", (byte)this.realFacingDirection.func_176745_a());
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74762_e(TAG_COLOR));
        this.field_70180_af.func_187227_b(INVISIBLE, (Object)compound.func_74767_n("IS_INVISIBLE"));
        this.field_70180_af.func_187227_b(IS_GLOWING, (Object)compound.func_74767_n("IS_GLOWING"));
        super.func_70037_a(compound);
        this.func_174859_a(EnumFacing.func_82600_a((int)compound.func_74771_c("REAL_FACING_DIRECTION")));
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeLong(this.field_174861_a.func_177986_g());
        buf.writeShort(this.realFacingDirection.func_176745_a());
    }

    public void readSpawnData(ByteBuf buf) {
        this.field_174861_a = BlockPos.func_177969_a((long)buf.readLong());
        this.func_174859_a(EnumFacing.func_82600_a((int)buf.readShort()));
    }

    protected void func_174859_a(EnumFacing facingDirectionIn) {
        Validate.notNull((Object)facingDirectionIn);
        this.realFacingDirection = facingDirectionIn;
        this.field_174860_b = this.realFacingDirection.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.SOUTH : this.realFacingDirection;
        float f = this.field_70177_z = this.realFacingDirection.func_176740_k() == EnumFacing.Axis.Y ? 0.0f : (float)(this.realFacingDirection.func_176736_b() * 90);
        this.field_70125_A = this.realFacingDirection.func_176740_k() == EnumFacing.Axis.Y ? (this.realFacingDirection == EnumFacing.UP ? -90.0f : 90.0f) : 0.0f;
        this.field_70126_B = this.field_70177_z;
        this.func_174856_o();
    }

    protected void func_174856_o() {
        if (this.realFacingDirection == null) {
            return;
        }
        if (this.realFacingDirection.func_176740_k() == EnumFacing.Axis.Y) {
            double d0 = (double)this.field_174861_a.func_177958_n() + 0.5;
            double d1 = (double)this.field_174861_a.func_177956_o() + 0.5;
            double d2 = (double)this.field_174861_a.func_177952_p() + 0.5;
            double d6 = this.func_82330_g();
            double d7 = -this.realFacingDirection.func_96559_d();
            double d8 = this.func_82330_g();
            this.field_70165_t = d0;
            this.field_70163_u = (d1 -= (double)this.realFacingDirection.func_96559_d() * 0.46875) - (d7 /= 32.0);
            this.field_70161_v = d2;
            this.field_70131_O = 0.0625f;
            this.func_174826_a(new AxisAlignedBB(d0 - d6, d1 - d7, d2 - (d8 /= 32.0), d0 + (d6 /= 32.0), d1 + d7, d2 + d8));
        } else {
            super.func_174856_o();
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void SetVisibility(boolean isInvisible, EntityPlayer player) {
        if (isInvisible) {
            AdvancementCriterionRegistry.ITEM_FRAME_INVISIBLE.trigger((EntityPlayerMP)player);
        }
        this.field_70180_af.func_187227_b(INVISIBLE, (Object)isInvisible);
    }

    public boolean IsFrameInvisible() {
        return (Boolean)this.field_70180_af.func_187225_a(INVISIBLE);
    }

    public boolean IsFrameGlowing() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_GLOWING);
    }

    public void SetGlowing(boolean isGlowing, EntityPlayer player) {
        if (isGlowing) {
            AdvancementCriterionRegistry.ITEM_FRAME_GLOWING.trigger((EntityPlayerMP)player);
        }
        this.field_70180_af.func_187227_b(IS_GLOWING, (Object)isGlowing);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_70093_af()) {
                if (itemstack.func_77973_b() instanceof ItemAspectVial && !this.IsFrameInvisible()) {
                    ItemAspectContainer aspectVial = ItemAspectContainer.fromItem(itemstack);
                    List<Aspect> aspectList = aspectVial.getAspects(player);
                    for (Aspect aspect : aspectList) {
                        if (aspect.type != AspectRegistry.FREIWYNN || aspect.amount < 100) continue;
                        aspectVial.drain(AspectRegistry.FREIWYNN, 100);
                        this.SetVisibility(true, player);
                        return true;
                    }
                } else if (itemstack.func_77973_b() instanceof ItemGlowingGoop && !this.func_184202_aL()) {
                    itemstack.func_190918_g(1);
                    this.SetGlowing(true, player);
                    return true;
                }
            }
            if (this.func_82335_i().func_190926_b()) {
                if (!itemstack.func_190926_b()) {
                    this.func_82334_a(itemstack);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                }
            } else {
                this.func_184185_a(SoundEvents.field_187632_cP, 1.0f, 1.0f);
                this.func_82336_g(this.func_82333_j() + 1);
            }
        }
        return true;
    }
}

