/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.falldamagereduce;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IFallDamageReductionCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class FallDamageReductionCapability
extends EntityCapability<FallDamageReductionCapability, IFallDamageReductionCapability, EntityPlayer>
implements IFallDamageReductionCapability,
ISerializableCapability {
    private long reductionTime = -1L;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "fall_damage_reduction");
    }

    @Override
    protected Capability<IFallDamageReductionCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_FALL_DAMAGE_REDUCTION;
    }

    @Override
    protected Class<IFallDamageReductionCapability> getCapabilityClass() {
        return IFallDamageReductionCapability.class;
    }

    @Override
    protected FallDamageReductionCapability getDefaultCapabilityImplementation() {
        return new FallDamageReductionCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("reductionTime", this.reductionTime);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.reductionTime = nbt.func_74763_f("reductionTime");
    }

    @Override
    public boolean isActive() {
        return this.getRemainingActiveTicks() > 0;
    }

    @Override
    public int getRemainingActiveTicks() {
        return this.reductionTime >= 0L ? Math.max(0, (int)(this.reductionTime - ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E())) : 0;
    }

    @Override
    public void setActive(int duration) {
        if (duration <= 0) {
            this.setNotActive();
        } else {
            this.reductionTime = ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E() + (long)duration;
            this.markDirty();
        }
    }

    @Override
    public void setNotActive() {
        if (this.reductionTime != -1L) {
            this.reductionTime = -1L;
            this.markDirty();
        }
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onPlayerFallDamage(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            IFallDamageReductionCapability cap;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            float amount = event.getAmount();
            if (event.getSource() == DamageSource.field_76379_h && (cap = (IFallDamageReductionCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FALL_DAMAGE_REDUCTION, null)) != null && cap.isActive()) {
                event.setAmount(0.0f + amount * 0.125f);
            }
        }
    }
}

