/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.ISwarmedCapability;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.block.plant.BlockNesting;
import thebetweenlands.common.block.plant.BlockWeedwoodBush;
import thebetweenlands.common.entity.mobs.EntitySwarm;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockWeedwoodBushInfested
extends BlockWeedwoodBush {
    private ItemStack drop;
    private int stage;

    public BlockWeedwoodBushInfested(ItemStack drop, int stage) {
        this.drop = drop;
        this.stage = stage;
        this.func_149675_a(true);
    }

    @Override
    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.drop.func_77973_b();
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.drop.func_77952_i();
    }

    @Override
    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing dir) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        return block instanceof BlockWeedwoodBush && !(block instanceof BlockNesting);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        switch (this.stage) {
            case 0: {
                world.func_180501_a(pos, BlockRegistry.WEEDWOOD_BUSH_INFESTED_1.func_176223_P(), 2);
                break;
            }
            case 1: {
                world.func_180501_a(pos, BlockRegistry.WEEDWOOD_BUSH_INFESTED_2.func_176223_P(), 2);
                break;
            }
            case 2: {
                world.func_180501_a(pos, BlockRegistry.WEEDWOOD_BUSH_INFESTED_3.func_176223_P(), 2);
                break;
            }
            case 3: {
                world.func_180501_a(pos, BlockRegistry.WEEDWOOD_BUSH_INFESTED_4.func_176223_P(), 2);
                break;
            }
            case 4: {
                world.func_180501_a(pos, BlockRegistry.DEAD_WEEDWOOD_BUSH.func_176223_P(), 2);
                EntitySwarm swarm = new EntitySwarm(world);
                swarm.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                world.func_72838_d((Entity)swarm);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        Block block;
        ItemStack held = player.func_184586_b(hand);
        if (!(world.field_72995_K || held.func_190926_b() || !(held.func_77973_b() instanceof ItemShears) && held.func_77973_b() != ItemRegistry.SILT_CRAB_CLAW || (block = (iblockstate = world.func_180495_p(pos)).func_177230_c()) != BlockRegistry.WEEDWOOD_BUSH_INFESTED_2 && block != BlockRegistry.WEEDWOOD_BUSH_INFESTED_3)) {
            ItemStack harvest = new ItemStack(this.drop.func_77973_b(), 2, this.drop.func_77952_i());
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, harvest);
            item.field_70179_y = 0.0;
            item.field_70181_x = 0.0;
            item.field_70159_w = 0.0;
            world.func_72838_d((Entity)item);
            world.func_180501_a(pos, BlockRegistry.WEEDWOOD_BUSH.func_176223_P(), 2);
            held.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return true;
    }

    @Override
    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return item.func_77973_b() instanceof ItemShears || item.func_77973_b() == ItemRegistry.SILT_CRAB_CLAW;
    }

    @Override
    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)BlockRegistry.WEEDWOOD_BUSH.func_176223_P().func_177230_c())), (Object)new ItemStack(this.drop.func_77973_b(), 1, this.drop.func_77952_i()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double px = (double)pos.func_177958_n() + 0.5;
        double py = (double)pos.func_177956_o() + 1.2;
        double pz = (double)pos.func_177952_p() + 0.5;
        if (world.field_73012_v.nextInt(10) == 0) {
            switch (this.stage) {
                case 0: {
                    BLParticles.SULFUR_TORCH.spawn(world, px, py, pz, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withColor(0.6f, 0.35f, 0.8f, 0.28f));
                    break;
                }
                case 1: {
                    BLParticles.SILK_MOTH.spawn(world, px, py, pz);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    BLParticles.DIRT_DECAY.spawn(world, px, py, pz);
                }
            }
        }
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return -1;
    }

    @Override
    public boolean isFarmable(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        return false;
    }

    @Override
    public float getSpreadChance(World world, BlockPos pos, IBlockState state, BlockPos taretPos, Random rand) {
        return 0.0f;
    }

    @Override
    public void spreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
    }

    @Override
    public void decayPlant(World world, BlockPos pos, IBlockState state, Random rand) {
        world.func_175698_g(pos);
    }

    @Override
    public int getCompostCost(World world, BlockPos pos, IBlockState state, Random rand) {
        return 0;
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        ISwarmedCapability cap;
        super.func_180634_a(world, pos, state, entity);
        if (!entity.field_70170_p.field_72995_K && (cap = (ISwarmedCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_SWARMED, null)) != null) {
            cap.setSwarmedStrength(cap.getSwarmedStrength() + 0.005f);
        }
    }

    @Override
    public boolean canBeDestroyedByPuddles(World world, BlockPos pos, IBlockState state) {
        return true;
    }
}

