/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.IFarmablePlant;
import thebetweenlands.api.block.ISickleHarvestable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.block.SoilHelper;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockPlant
extends BlockBush
implements IShearable,
ISickleHarvestable,
IFarmablePlant,
ITintedBlock {
    protected static final AxisAlignedBB PLANT_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    protected ItemStack sickleHarvestableDrop;
    protected boolean isReplaceable = false;

    public BlockPlant() {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(BLCreativeTabs.PLANTS);
    }

    public BlockPlant setSickleDrop(ItemStack drop) {
        this.sickleHarvestableDrop = drop;
        return this;
    }

    public BlockPlant setReplaceable(boolean replaceable) {
        this.isReplaceable = replaceable;
        return this;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PLANT_AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a()) && this.func_180671_f(worldIn, pos, worldIn.func_180495_p(pos));
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return this.isReplaceable;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    protected boolean func_185514_i(IBlockState state) {
        return SoilHelper.canSustainPlant(state);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return item.func_77973_b() == ItemRegistry.SYRMORITE_SHEARS || item.func_77973_b() == ItemRegistry.SILT_CRAB_CLAW;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)this)));
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public List<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return this.sickleHarvestableDrop != null ? ImmutableList.of((Object)this.sickleHarvestableDrop.func_77946_l()) : ImmutableList.of();
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        return world.func_175623_d(targetPos) && this.func_176196_c(world, targetPos);
    }

    @Override
    public float getSpreadChance(World world, BlockPos pos, IBlockState state, BlockPos taretPos, Random rand) {
        return 0.25f;
    }

    @Override
    public void spreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        world.func_175656_a(targetPos, this.func_176223_P());
    }

    @Override
    public void decayPlant(World world, BlockPos pos, IBlockState state, Random rand) {
        world.func_175698_g(pos);
    }

    @Override
    public int getCompostCost(World world, BlockPos pos, IBlockState state, Random rand) {
        return 4;
    }

    @Override
    public boolean isFarmable(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : -1;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b() && ItemMisc.EnumItemMisc.COMPOST.isItemOf(heldItem)) {
            pos = pos.func_177977_b();
            for (int i = 0; i < 3; ++i) {
                state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof BlockGenericDugSoil) {
                    return state.func_177230_c().func_180639_a(world, pos, state, playerIn, hand, EnumFacing.UP, 0.5f, 1.0f, 0.5f);
                }
                if (!this.isSamePlant(state)) break;
                pos = pos.func_177977_b();
            }
        }
        return false;
    }

    protected boolean isSamePlant(IBlockState blockState) {
        return blockState.func_177230_c() == this;
    }
}

