/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockHollowLog
extends BlockHorizontal {
    public static final float WALL_THICKNESS = 0.125f;
    public static final AxisAlignedBB TOP_BOUNDING_BOX = new AxisAlignedBB(0.0, 1.0, 0.0, 1.0, 0.875, 1.0);
    public static final AxisAlignedBB BOTTOM_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final AxisAlignedBB SOUTH_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 1.0, 1.0, 1.0, 0.875);
    public static final AxisAlignedBB NORTH_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    public static final AxisAlignedBB EAST_BOUNDING_BOX = new AxisAlignedBB(1.0, 0.0, 0.0, 0.875, 1.0, 1.0);
    public static final AxisAlignedBB WEST_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public BlockHollowLog() {
        super(Material.field_151575_d);
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return Block.field_185505_j;
    }

    protected void addBox(EnumFacing facing, IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        IBlockState lstate;
        AxisAlignedBB box;
        switch (facing) {
            case UP: {
                box = TOP_BOUNDING_BOX;
                break;
            }
            case DOWN: {
                box = BOTTOM_BOUNDING_BOX;
                break;
            }
            case NORTH: {
                box = NORTH_BOUNDING_BOX;
                break;
            }
            case SOUTH: {
                box = SOUTH_BOUNDING_BOX;
                break;
            }
            case EAST: {
                box = EAST_BOUNDING_BOX;
                break;
            }
            case WEST: {
                box = WEST_BOUNDING_BOX;
                break;
            }
            default: {
                return;
            }
        }
        if (facing.func_176740_k() != EnumFacing.Axis.Y && worldIn.func_175667_e(pos.func_177972_a(facing)) && (lstate = worldIn.func_180495_p(pos.func_177972_a(facing))).func_177230_c() == BlockRegistry.HOLLOW_LOG && ((EnumFacing)lstate.func_177229_b((IProperty)field_185512_D)).func_176740_k() != facing.func_176740_k()) {
            return;
        }
        BlockHollowLog.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        BlockHollowLog.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TOP_BOUNDING_BOX);
        BlockHollowLog.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOTTOM_BOUNDING_BOX);
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                this.addBox(EnumFacing.EAST, state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
                this.addBox(EnumFacing.WEST, state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
                break;
            }
            case EAST: 
            case WEST: {
                this.addBox(EnumFacing.NORTH, state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
                this.addBox(EnumFacing.SOUTH, state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
                break;
            }
            default: {
                BlockHollowLog.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_BOUNDING_BOX);
                BlockHollowLog.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_BOUNDING_BOX);
                BlockHollowLog.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_BOUNDING_BOX);
                BlockHollowLog.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_BOUNDING_BOX);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side.func_176730_m().func_177956_o() != 0 || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this || side.func_176740_k() != ((EnumFacing)blockAccess.func_180495_p(pos.func_177972_a(side)).func_177229_b((IProperty)field_185512_D)).func_176740_k();
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side.func_176740_k() != ((EnumFacing)base_state.func_177229_b((IProperty)field_185512_D)).func_176740_k();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.ITEMS_MISC;
    }

    public int func_180651_a(IBlockState state) {
        return ItemMisc.EnumItemMisc.DRY_BARK.getID();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }
}

