/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.IFarmablePlant;
import thebetweenlands.api.block.ISickleHarvestable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.block.SoilHelper;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockDoublePlantBL
extends BlockBush
implements BlockRegistry.IStateMappedBlock,
IShearable,
ISickleHarvestable,
IFarmablePlant,
ITintedBlock {
    protected static final AxisAlignedBB PLANT_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);
    public static final PropertyEnum<EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumBlockHalf.class);
    public static final PropertyEnum<EnumFacing> FACING = BlockHorizontal.field_185512_D;
    protected ItemStack sickleHarvestableDrop;
    protected boolean replaceable;

    public BlockDoublePlantBL() {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.LOWER)).func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(BLCreativeTabs.PLANTS);
    }

    public BlockDoublePlantBL setSickleDrop(ItemStack drop) {
        this.sickleHarvestableDrop = drop;
        return this;
    }

    public BlockDoublePlantBL setReplaceable(boolean replaceable) {
        this.replaceable = replaceable;
        return this;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PLANT_AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return this.replaceable;
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            BlockDoublePlantBL blockBelowOrHere;
            boolean isUpperHalf = state.func_177229_b(HALF) == EnumBlockHalf.UPPER;
            BlockPos posAboveOrHere = isUpperHalf ? pos : pos.func_177984_a();
            BlockPos posBelowOrHere = isUpperHalf ? pos.func_177977_b() : pos;
            BlockDoublePlantBL blockAboveOrHere = isUpperHalf ? this : worldIn.func_180495_p(posAboveOrHere).func_177230_c();
            BlockDoublePlantBL blockDoublePlantBL = blockBelowOrHere = isUpperHalf ? worldIn.func_180495_p(posBelowOrHere).func_177230_c() : this;
            if (!isUpperHalf && blockAboveOrHere == this) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            if (blockAboveOrHere == this) {
                worldIn.func_180501_a(posAboveOrHere, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (blockBelowOrHere == this) {
                worldIn.func_180501_a(posBelowOrHere, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.func_180671_f(worldIn, pos, state);
        }
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState stateAbove = worldIn.func_180495_p(pos.func_177984_a());
        return stateAbove.func_177230_c() == this && super.func_180671_f(worldIn, pos, stateAbove);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void placeAt(World worldIn, BlockPos lowerPos, int updateFlags) {
        worldIn.func_180501_a(lowerPos, this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.LOWER)), updateFlags);
        worldIn.func_180501_a(lowerPos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER)), updateFlags);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER)).func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)rot)), 2);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER) {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (!player.field_71075_bZ.field_75098_d) {
                    this.func_180657_a(worldIn, player, pos.func_177977_b(), worldIn.func_180495_p(pos.func_177977_b()), worldIn.func_175625_s(pos.func_177977_b()), player.func_184614_ca());
                }
                worldIn.func_175698_g(pos.func_177977_b());
            }
        } else if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public IBlockState func_176203_a(int meta) {
        int facing = meta >> 1 & 4;
        boolean isUpper = (meta & 1) == 1;
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)(isUpper ? EnumBlockHalf.UPPER : EnumBlockHalf.LOWER))).func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)facing));
    }

    public int func_176201_c(IBlockState state) {
        int facing = ((EnumFacing)state.func_177229_b(FACING)).func_176736_b();
        boolean isUpper = state.func_177229_b(HALF) == EnumBlockHalf.UPPER;
        int meta = facing << 1;
        return meta |= isUpper ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{FACING});
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return item.func_77973_b() == ItemRegistry.SYRMORITE_SHEARS || item.func_77973_b() == ItemRegistry.SILT_CRAB_CLAW;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)this)));
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public List<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return this.sickleHarvestableDrop != null ? ImmutableList.of((Object)this.sickleHarvestableDrop.func_77946_l()) : ImmutableList.of();
    }

    protected boolean func_185514_i(IBlockState state) {
        return super.func_185514_i(state) || SoilHelper.canSustainPlant(state);
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        return world.func_175623_d(targetPos) && world.func_175623_d(targetPos.func_177984_a()) && this.func_176196_c(world, targetPos);
    }

    @Override
    public float getSpreadChance(World world, BlockPos pos, IBlockState state, BlockPos taretPos, Random rand) {
        return 0.25f;
    }

    @Override
    public void spreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        world.func_175656_a(targetPos, this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.LOWER)));
        world.func_175656_a(targetPos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER)));
    }

    @Override
    public int getCompostCost(World world, BlockPos pos, IBlockState state, Random rand) {
        return 8;
    }

    @Override
    public void decayPlant(World world, BlockPos pos, IBlockState state, Random rand) {
        world.func_175698_g(pos.func_177984_a());
        world.func_175698_g(pos);
    }

    @Override
    public boolean isFarmable(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
    }

    public static enum EnumBlockHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

