/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IMudWalkerCapability;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockSludge
extends Block {
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);

    public BlockSludge() {
        super(BLMaterialRegistry.SLUDGE);
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149663_c("thebetweenlands.sludge");
        this.setHarvestLevel("shovel", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public void generateBlockTemporary(World world, BlockPos pos) {
        world.func_175656_a(pos, this.func_176223_P());
        world.func_180497_b(pos, (Block)this, 1200, 0);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rnd) {
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        boolean mudWalker;
        IMudWalkerCapability cap = (IMudWalkerCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_MUD_WALKER, null);
        boolean bl = mudWalker = entity instanceof EntityPlayer && cap != null && cap.isActive();
        if (!(entity instanceof IEntityBL) && entity.field_70122_E && !mudWalker) {
            entity.func_70110_aj();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos) != this && super.func_176225_a(state, blockAccess, pos, side);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rnd, int fortune) {
        return ItemRegistry.SLUDGE_BALL;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return this.func_176196_c(world, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

