/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.IConnectedTextureBlock;
import thebetweenlands.common.block.misc.BlockPaneBetweenlands;
import thebetweenlands.common.block.property.PropertyBoolUnlisted;

public class BlockConnectedPane
extends BlockPaneBetweenlands
implements IConnectedTextureBlock {
    public static final IUnlistedProperty<Boolean> CULL_TOP = new PropertyBoolUnlisted("cull_top");
    public static final IUnlistedProperty<Boolean> CULL_TOP_NORTH = new PropertyBoolUnlisted("cull_top_north");
    public static final IUnlistedProperty<Boolean> CULL_TOP_EAST = new PropertyBoolUnlisted("cull_top_east");
    public static final IUnlistedProperty<Boolean> CULL_TOP_SOUTH = new PropertyBoolUnlisted("cull_top_south");
    public static final IUnlistedProperty<Boolean> CULL_TOP_WEST = new PropertyBoolUnlisted("cull_top_west");
    public static final EnumMap<EnumFacing, IUnlistedProperty<Boolean>> CULL_TOP_MAP = new EnumMap(EnumFacing.class);
    public static final IUnlistedProperty<Boolean> CULL_BOTTOM = new PropertyBoolUnlisted("cull_bottom");
    public static final IUnlistedProperty<Boolean> CULL_BOTTOM_NORTH = new PropertyBoolUnlisted("cull_bottom_north");
    public static final IUnlistedProperty<Boolean> CULL_BOTTOM_EAST = new PropertyBoolUnlisted("cull_bottom_east");
    public static final IUnlistedProperty<Boolean> CULL_BOTTOM_SOUTH = new PropertyBoolUnlisted("cull_bottom_south");
    public static final IUnlistedProperty<Boolean> CULL_BOTTOM_WEST = new PropertyBoolUnlisted("cull_bottom_west");
    public static final EnumMap<EnumFacing, IUnlistedProperty<Boolean>> CULL_BOTTOM_MAP = new EnumMap(EnumFacing.class);

    public BlockConnectedPane(Material materialIn) {
        super(materialIn);
    }

    public BlockConnectedPane(Material materialIn, boolean canDrop) {
        super(materialIn, canDrop);
    }

    protected boolean canConnectTo(IBlockState state, IBlockAccess world, BlockPos pos, BlockPos toPos, IBlockState toState) {
        return toState.func_177230_c() == this;
    }

    public IBlockState getExtendedState(final IBlockState oldState, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = this.getCullingState(false, state, world, pos);
        state = this.getCullingState(true, state, world, pos);
        IConnectedTextureBlock.IConnectionRules connectionState = new IConnectedTextureBlock.IConnectionRules(){

            @Override
            public boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing face, BlockPos to) {
                return Math.abs(to.func_177958_n() - pos.func_177958_n() - face.func_82601_c()) + Math.abs(to.func_177956_o() - pos.func_177956_o() - face.func_96559_d()) + Math.abs(to.func_177952_p() - pos.func_177952_p() - face.func_82599_e()) != 1 && BlockConnectedPane.this.canConnectTo(oldState, world, pos, to, world.func_180495_p(to));
            }

            @Override
            public boolean canConnectThrough(IBlockAccess world, BlockPos pos, EnumFacing face, BlockPos to) {
                EnumFacing.Axis axis = face.func_176740_k();
                return axis == EnumFacing.Axis.X && to.func_177958_n() - pos.func_177958_n() != 0 || axis == EnumFacing.Axis.Y && to.func_177956_o() - pos.func_177956_o() != 0 || axis == EnumFacing.Axis.Z && to.func_177952_p() - pos.func_177952_p() != 0;
            }
        };
        return this.getExtendedConnectedTextureState(state, world, pos, connectionState);
    }

    protected IExtendedBlockState getCullingState(boolean up, IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = up ? EnumFacing.UP : EnumFacing.DOWN;
        EnumMap<EnumFacing, IUnlistedProperty<Boolean>> properties = up ? CULL_TOP_MAP : CULL_BOTTOM_MAP;
        IUnlistedProperty<Boolean> cullPoleProperty = properties.get(facing);
        BlockPos offsetPos = pos.func_177972_a(facing);
        boolean render = this.func_176225_a((IBlockState)state, world, pos, facing);
        if (world.func_180495_p(offsetPos).func_177230_c() == this) {
            state.withProperty(cullPoleProperty, (Object)false);
            for (EnumFacing horFacing : EnumFacing.field_176754_o) {
                state = state.withProperty(properties.get(horFacing), (Object)(render && !this.canBeConnectedTo(world, offsetPos, horFacing) ? 1 : 0));
            }
        } else {
            state.withProperty(cullPoleProperty, (Object)true);
            for (IUnlistedProperty<Boolean> property : properties.values()) {
                state = state.withProperty(property, (Object)render);
            }
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState offsetBlockState;
        BlockPos offsetPos = pos.func_177972_a(side);
        if (this.canConnectTo(blockState, blockAccess, pos, offsetPos, offsetBlockState = blockAccess.func_180495_p(offsetPos))) {
            if (side.func_176740_k() != EnumFacing.Axis.Y) {
                return false;
            }
            AxisAlignedBB thisAabb = blockState.func_185900_c(blockAccess, pos);
            AxisAlignedBB otherAabb = offsetBlockState.func_185900_c(blockAccess, pos.func_177972_a(side));
            return thisAabb.field_72336_d - thisAabb.field_72340_a > otherAabb.field_72336_d - otherAabb.field_72340_a || thisAabb.field_72334_f - thisAabb.field_72339_c > otherAabb.field_72334_f - otherAabb.field_72339_c;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    protected BlockStateContainer func_180661_e() {
        return this.getConnectedTextureBlockStateContainer(new ExtendedBlockState((Block)this, new IProperty[]{field_176241_b, field_176242_M, field_176244_O, field_176243_N}, new IUnlistedProperty[]{CULL_TOP, CULL_TOP_NORTH, CULL_TOP_EAST, CULL_TOP_SOUTH, CULL_TOP_WEST, CULL_BOTTOM, CULL_BOTTOM_NORTH, CULL_BOTTOM_EAST, CULL_BOTTOM_SOUTH, CULL_BOTTOM_WEST}));
    }

    static {
        CULL_TOP_MAP.put(EnumFacing.UP, CULL_TOP);
        CULL_TOP_MAP.put(EnumFacing.NORTH, CULL_TOP_NORTH);
        CULL_TOP_MAP.put(EnumFacing.EAST, CULL_TOP_EAST);
        CULL_TOP_MAP.put(EnumFacing.SOUTH, CULL_TOP_SOUTH);
        CULL_TOP_MAP.put(EnumFacing.WEST, CULL_TOP_WEST);
        CULL_BOTTOM_MAP.put(EnumFacing.DOWN, CULL_BOTTOM);
        CULL_BOTTOM_MAP.put(EnumFacing.NORTH, CULL_BOTTOM_NORTH);
        CULL_BOTTOM_MAP.put(EnumFacing.EAST, CULL_BOTTOM_EAST);
        CULL_BOTTOM_MAP.put(EnumFacing.SOUTH, CULL_BOTTOM_SOUTH);
        CULL_BOTTOM_MAP.put(EnumFacing.WEST, CULL_BOTTOM_WEST);
    }
}

