/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.farming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.BlockStateContainerHelper;
import thebetweenlands.common.block.SoilHelper;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;
import thebetweenlands.common.block.plant.BlockStackablePlant;
import thebetweenlands.common.tile.TileEntityDugSoil;
import thebetweenlands.util.AdvancedStateMap;

public class BlockGenericCrop
extends BlockStackablePlant
implements IGrowable {
    public static final PropertyBool DECAYED = PropertyBool.func_177716_a((String)"decayed");
    private PropertyInteger stageProperty;

    public BlockGenericCrop() {
        this.harvestAll = true;
        this.resetAge = false;
        this.setMaxHeight(1);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DECAYED, (Comparable)Boolean.valueOf(false)));
    }

    protected PropertyInteger createStageProperty() {
        return PropertyInteger.func_177719_a((String)"stage", (int)0, (int)3);
    }

    public PropertyInteger getStageProperty() {
        return this.stageProperty;
    }

    public boolean isDecayed(IBlockAccess world, BlockPos pos) {
        for (int i = 0; i < this.maxHeight + 1; ++i) {
            IBlockState blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c() instanceof BlockGenericDugSoil) {
                return (Boolean)blockState.func_177229_b((IProperty)BlockGenericDugSoil.DECAYED);
            }
            pos = pos.func_177977_b();
        }
        return false;
    }

    public boolean isComposted(IBlockAccess world, BlockPos pos) {
        for (int i = 0; i < this.maxHeight + 1; ++i) {
            IBlockState blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c() instanceof BlockGenericDugSoil) {
                return (Boolean)blockState.func_177229_b((IProperty)BlockGenericDugSoil.COMPOSTED);
            }
            pos = pos.func_177977_b();
        }
        return false;
    }

    public boolean isFogged(IBlockAccess world, BlockPos pos) {
        for (int i = 0; i < this.maxHeight + 1; ++i) {
            IBlockState blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c() instanceof BlockGenericDugSoil) {
                return (Boolean)blockState.func_177229_b((IProperty)BlockGenericDugSoil.FOGGED);
            }
            pos = pos.func_177977_b();
        }
        return false;
    }

    @Override
    protected float getGrowthChance(World world, BlockPos pos, IBlockState state, Random rand) {
        return this.isFogged((IBlockAccess)world, pos) ? 1.0f : super.getGrowthChance(world, pos, state, rand);
    }

    @Override
    protected int getGrowthSpeed(World world, BlockPos pos, IBlockState state, Random rand) {
        return super.getGrowthSpeed(world, pos, state, rand) + (this.isFogged((IBlockAccess)world, pos) ? rand.nextInt(3) + 2 : 0);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.func_184812_l_()) {
            ItemStack stack;
            ItemStack itemStack = stack = !player.func_184614_ca().func_190926_b() ? player.func_184614_ca().func_77946_l() : ItemStack.field_190927_a;
            if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                ItemStack itemstack = this.getPickBlock(state, null, worldIn, pos, player);
                if (!itemstack.func_190926_b()) {
                    items.add(itemstack);
                }
                ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
                for (ItemStack item : items) {
                    BlockGenericCrop.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
                }
            } else {
                this.harvesters.set(player);
                int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                this.func_176226_b(worldIn, pos, state, i);
                this.harvesters.set(null);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        boolean removed = super.removedByPlayer(state, world, pos, player, willHarvest);
        if (removed && (Integer)state.func_177229_b((IProperty)AGE) >= 15) {
            this.harvestAndUpdateSoil(world, pos, 10);
        }
        return removed;
    }

    protected void harvestAndUpdateSoil(World world, BlockPos pos, int compost) {
        TileEntityDugSoil te;
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        if (stateDown.func_177230_c() instanceof BlockGenericDugSoil && (te = BlockGenericDugSoil.getTile(world, pos.func_177977_b())) != null && te.isComposted()) {
            te.setCompost(Math.max(te.getCompost() - compost, 0));
            if (((BlockGenericDugSoil)stateDown.func_177230_c()).isPurified(world, pos.func_177977_b(), stateDown)) {
                te.setPurifiedHarvests(te.getPurifiedHarvests() + 1);
            }
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int i;
        int drops;
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStack seedDrop = this.getSeedDrop(world, pos, rand);
        ItemStack cropDrop = this.getCropDrop(world, pos, rand);
        if (!seedDrop.func_190926_b()) {
            drops = this.getSeedDrops(world, pos, rand, fortune);
            for (i = 0; i < drops; ++i) {
                ret.add(seedDrop.func_77946_l());
            }
        }
        if (!cropDrop.func_190926_b()) {
            drops = this.getCropDrops(world, pos, rand, fortune);
            for (i = 0; i < drops; ++i) {
                ret.add(cropDrop.func_77946_l());
            }
        }
        return ret;
    }

    public int getSeedDrops(IBlockAccess world, BlockPos pos, Random rand, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        return 1 + ((Integer)state.func_177229_b((IProperty)AGE) >= 15 ? (rand.nextInt(Math.max(3 - fortune, 1)) == 0 ? 1 : 0) : 0);
    }

    public int getCropDrops(IBlockAccess world, BlockPos pos, Random rand, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 15) {
            return 2 + rand.nextInt(3 + fortune);
        }
        return 0;
    }

    public ItemStack getSeedDrop(IBlockAccess world, BlockPos pos, Random rand) {
        return ItemStack.field_190927_a;
    }

    public ItemStack getCropDrop(IBlockAccess world, BlockPos pos, Random rand) {
        return ItemStack.field_190927_a;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        return state.func_177226_a((IProperty)DECAYED, (Comparable)Boolean.valueOf(this.isDecayed(worldIn, pos))).func_177226_a((IProperty)this.stageProperty, (Comparable)Integer.valueOf(MathHelper.func_76141_d((float)((float)((Integer)state.func_177229_b((IProperty)AGE)).intValue() / 15.0f * (float)((Integer)Collections.max(this.stageProperty.func_177700_c())).intValue()))));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        this.stageProperty = this.createStageProperty();
        return BlockStateContainerHelper.extendBlockstateContainer(super.func_180661_e(), new IProperty[]{DECAYED, this.stageProperty});
    }

    @Override
    protected boolean func_185514_i(IBlockState state) {
        return this.maxHeight > 1 && this.isSamePlant(state) || SoilHelper.canSustainCrop(state);
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return !(!super.func_176196_c(worldIn, pos) || state.func_177230_c() instanceof BlockGenericDugSoil && (Boolean)state.func_177229_b((IProperty)BlockGenericDugSoil.DECAYED) != false || state.func_177230_c() instanceof BlockGenericCrop && (Integer)state.func_177229_b((IProperty)AGE) < 15);
    }

    @Override
    protected boolean canGrow(World world, BlockPos pos, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DECAYED) == false && this.isComposted((IBlockAccess)world, pos);
    }

    @Override
    protected void growUp(World world, BlockPos pos) {
        world.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)DECAYED, world.func_180495_p(pos).func_177229_b((IProperty)DECAYED)));
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        if (!this.canGrow(worldIn, pos, state)) {
            return false;
        }
        if ((Integer)state.func_177229_b((IProperty)AGE) < 15) {
            return true;
        }
        int height = 1;
        while (worldIn.func_180495_p(pos.func_177979_c(height)).func_177230_c() == this) {
            ++height;
        }
        return this.canGrowUp(worldIn, pos, state, height);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE) + MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
        if (age > 15) {
            age = 15;
            int height = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(height)).func_177230_c() == this) {
                ++height;
            }
            if (this.canGrowUp(worldIn, pos, state, height)) {
                this.growUp(worldIn, pos);
            }
        }
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        super.setStateMapper(builder);
        builder.ignore(new IProperty[]{DECAYED}).withPropertySuffixTrue((IProperty<Boolean>)DECAYED, "decayed");
    }

    @Override
    public boolean isFarmable(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    public boolean canBeDestroyedByPuddles(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return false;
    }
}

