/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.farming;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.terrain.BlockHearthgroveLog;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.item.tools.ItemBLBucket;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockBarnacle_3_4
extends BlockSwampWater
implements BlockRegistry.IStateMappedBlock,
BlockRegistry.ICustomItemBlock {
    public static final PropertyEnum<EnumBarnacleTypeLate> BARNACLE_TYPE_LATE = PropertyEnum.func_177709_a((String)"barnacle_type_late", EnumBarnacleTypeLate.class);

    public BlockBarnacle_3_4() {
        this(FluidRegistry.SWAMP_WATER, Material.field_151586_h);
        this.func_149711_c(0.2f);
    }

    public BlockBarnacle_3_4(Fluid fluid, Material materialIn) {
        super(fluid, materialIn);
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.setUnderwaterBlock(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BARNACLE_TYPE_LATE, (Comparable)((Object)EnumBarnacleTypeLate.BARNACLE_DOWN_THREE)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        super.setStateMapper(builder);
        builder.ignore(new IProperty[]{LEVEL});
    }

    @Override
    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(BlockRegistry.BARNACLE_1_2);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        float widthMin = 0.0f;
        float heightMin = 0.0f;
        float depthMin = 0.0f;
        float widthMax = 0.0f;
        float heightMax = 0.0f;
        float depthMax = 0.0f;
        switch (this.getFacingForAttachedSide((EnumBarnacleTypeLate)((Object)state.func_177229_b(BARNACLE_TYPE_LATE)))) {
            case DOWN: {
                widthMin = 0.125f;
                heightMin = 0.0f;
                depthMin = 0.125f;
                widthMax = 0.125f;
                heightMax = 0.5f;
                depthMax = 0.125f;
                break;
            }
            case UP: {
                widthMin = 0.125f;
                heightMin = 0.5f;
                depthMin = 0.125f;
                widthMax = 0.125f;
                heightMax = 0.0f;
                depthMax = 0.125f;
                break;
            }
            case SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.125f;
                depthMin = 0.5f;
                widthMax = 0.125f;
                heightMax = 0.125f;
                depthMax = 0.0f;
                break;
            }
            case EAST: {
                widthMin = 0.5f;
                heightMin = 0.125f;
                depthMin = 0.125f;
                widthMax = 0.0f;
                heightMax = 0.125f;
                depthMax = 0.125f;
                break;
            }
            case NORTH: {
                widthMin = 0.125f;
                heightMin = 0.125f;
                depthMin = 0.0f;
                widthMax = 0.125f;
                heightMax = 0.125f;
                depthMax = 0.5f;
                break;
            }
            case WEST: {
                widthMin = 0.0f;
                heightMin = 0.125f;
                depthMin = 0.125f;
                widthMax = 0.5f;
                heightMax = 0.125f;
                depthMax = 0.125f;
            }
        }
        return new AxisAlignedBB((double)(0.0f + widthMin), (double)(0.0f + heightMin), (double)(0.0f + depthMin), (double)(1.0f - widthMax), (double)(1.0f - heightMax), (double)(1.0f - depthMax));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        return !(stack.func_77973_b() instanceof ItemBucket) || !(stack.func_77973_b() instanceof ItemBLBucket);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return BlockBarnacle_3_4.canPlaceBlock(world, pos, side);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockBarnacle_3_4.canPlaceBlock(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World world, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = world.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)world, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        return world.func_175677_d(blockpos, true) && block.func_149662_c(iblockstate) && flag && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int age = this.func_176201_c(state);
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        if (age >= 6 && age <= 11) {
            if (rand.nextBoolean()) {
                ret.add(this.getLarvae());
            }
            ret.add(this.getLarvae());
            ret.add(new ItemStack(ItemRegistry.BARNACLE, 1, 0));
        } else {
            ret.add(this.getLarvae());
        }
        return ret;
    }

    protected ItemStack getLarvae() {
        return new ItemStack(BlockRegistry.BARNACLE_1_2);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{LEVEL}).add(new IProperty[]{BARNACLE_TYPE_LATE}).add((IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0])).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BARNACLE_TYPE_LATE, (Comparable)((Object)EnumBarnacleTypeLate.byMetadata(meta)));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && this.checkForLog(world, pos, state)) {
            world.func_175684_a(pos, (Block)this, 100);
        }
    }

    private boolean checkForLog(World world, BlockPos pos, IBlockState state) {
        if (this.func_176201_c(state) > 5 && this.func_176201_c(state) <= 11) {
            return false;
        }
        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(this.getFacingForAttachedSide((EnumBarnacleTypeLate)((Object)state.func_177229_b(BARNACLE_TYPE_LATE)))));
        Block offsetBlock = offsetState.func_177230_c();
        return offsetBlock instanceof BlockHearthgroveLog && (Boolean)offsetState.func_177229_b((IProperty)BlockHearthgroveLog.TARRED) != false;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (this.checkForLog(world, pos, state)) {
            this.func_180645_a(world, pos, state, random);
            world.func_175684_a(pos, (Block)this, 100);
        }
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73012_v.nextInt(4) == 0) {
            EnumBarnacleTypeLate stage = (EnumBarnacleTypeLate)((Object)state.func_177229_b(BARNACLE_TYPE_LATE));
            switch (stage) {
                case BARNACLE_DOWN_THREE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_LATE, (Comparable)((Object)EnumBarnacleTypeLate.BARNACLE_DOWN_FOUR)), 2);
                    break;
                }
                case BARNACLE_UP_THREE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_LATE, (Comparable)((Object)EnumBarnacleTypeLate.BARNACLE_UP_FOUR)), 2);
                    break;
                }
                case BARNACLE_EAST_THREE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_LATE, (Comparable)((Object)EnumBarnacleTypeLate.BARNACLE_EAST_FOUR)), 2);
                    break;
                }
                case BARNACLE_NORTH_THREE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_LATE, (Comparable)((Object)EnumBarnacleTypeLate.BARNACLE_NORTH_FOUR)), 2);
                    break;
                }
                case BARNACLE_SOUTH_THREE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_LATE, (Comparable)((Object)EnumBarnacleTypeLate.BARNACLE_SOUTH_FOUR)), 2);
                    break;
                }
                case BARNACLE_WEST_THREE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_LATE, (Comparable)((Object)EnumBarnacleTypeLate.BARNACLE_WEST_FOUR)), 2);
                    break;
                }
                case BARNACLE_DOWN_FOUR: 
                case BARNACLE_UP_FOUR: 
                case BARNACLE_EAST_FOUR: 
                case BARNACLE_NORTH_FOUR: 
                case BARNACLE_SOUTH_FOUR: 
                case BARNACLE_WEST_FOUR: {
                    break;
                }
            }
        }
    }

    public EnumFacing getFacingForAttachedSide(EnumBarnacleTypeLate type) {
        switch (type) {
            case BARNACLE_UP_THREE: 
            case BARNACLE_UP_FOUR: {
                return EnumFacing.UP;
            }
            case BARNACLE_DOWN_THREE: 
            case BARNACLE_DOWN_FOUR: {
                return EnumFacing.DOWN;
            }
            case BARNACLE_NORTH_THREE: 
            case BARNACLE_NORTH_FOUR: {
                return EnumFacing.NORTH;
            }
            case BARNACLE_WEST_THREE: 
            case BARNACLE_WEST_FOUR: {
                return EnumFacing.WEST;
            }
            case BARNACLE_SOUTH_THREE: 
            case BARNACLE_SOUTH_FOUR: {
                return EnumFacing.SOUTH;
            }
            case BARNACLE_EAST_THREE: 
            case BARNACLE_EAST_FOUR: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.DOWN;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean flag = false;
        if (world.isSideSolid(pos.func_177972_a(this.getFacingForAttachedSide((EnumBarnacleTypeLate)((Object)state.func_177229_b(BARNACLE_TYPE_LATE)))), this.getFacingForAttachedSide((EnumBarnacleTypeLate)((Object)state.func_177229_b(BARNACLE_TYPE_LATE))).func_176734_d())) {
            flag = true;
        }
        if (!flag) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBarnacleTypeLate)((Object)state.func_177229_b(BARNACLE_TYPE_LATE))).getMetadata();
    }

    @Override
    public ItemBlock getItemBlock() {
        return null;
    }

    public static enum EnumBarnacleTypeLate implements IStringSerializable
    {
        BARNACLE_DOWN_THREE,
        BARNACLE_UP_THREE,
        BARNACLE_NORTH_THREE,
        BARNACLE_SOUTH_THREE,
        BARNACLE_WEST_THREE,
        BARNACLE_EAST_THREE,
        BARNACLE_DOWN_FOUR,
        BARNACLE_UP_FOUR,
        BARNACLE_NORTH_FOUR,
        BARNACLE_SOUTH_FOUR,
        BARNACLE_WEST_FOUR,
        BARNACLE_EAST_FOUR;

        private final String name = this.name().toLowerCase(Locale.ENGLISH);

        public int getMetadata() {
            return this.ordinal();
        }

        public String toString() {
            return this.name;
        }

        public static EnumBarnacleTypeLate byMetadata(int metadata) {
            if (metadata < 0 || metadata >= EnumBarnacleTypeLate.values().length) {
                metadata = 0;
            }
            return EnumBarnacleTypeLate.values()[metadata];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

