/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import javax.annotation.Nullable;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityWaterFilter;

public class BlockWaterFilter
extends BlockContainer {
    public BlockWaterFilter() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWaterFilter();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IFluidHandler fluidHandler;
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.func_175625_s(pos) instanceof TileEntityWaterFilter) {
            TileEntityWaterFilter tile = (TileEntityWaterFilter)world.func_175625_s(pos);
            if (FluidUtil.getFluidHandler((ItemStack)heldItem) == null && hand == EnumHand.MAIN_HAND) {
                if (world.field_72995_K && tile.tank.getFluid() != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(tile.tank.getFluid().getLocalizedName() + ": " + tile.tank.getFluidAmount() + "/" + tile.tank.getCapacity(), new Object[0]), true);
                }
                if (heldItem.func_77973_b() == ItemRegistry.SILK_FILTER || heldItem.func_77973_b() == ItemRegistry.MOSS_FILTER) {
                    if (tile.func_70301_a(0).func_190926_b() && !world.field_72995_K) {
                        tile.func_70299_a(0, heldItem.func_77946_l());
                        heldItem.func_190918_g(1);
                        tile.markForUpdate();
                    }
                    player.func_184609_a(hand);
                    return true;
                }
                if (!tile.func_70301_a(0).func_190926_b() && !world.field_72995_K && player.func_70093_af()) {
                    this.spitOutItems(world, pos, tile, 0);
                    return true;
                }
                if (!(tile.func_70301_a(1).func_190926_b() || world.field_72995_K || player.func_70093_af())) {
                    this.spitOutItems(world, pos, tile, 1);
                    return true;
                }
                if (!(tile.func_70301_a(2).func_190926_b() || world.field_72995_K || player.func_70093_af())) {
                    this.spitOutItems(world, pos, tile, 2);
                    return true;
                }
                if (!(tile.func_70301_a(3).func_190926_b() || world.field_72995_K || player.func_70093_af())) {
                    this.spitOutItems(world, pos, tile, 3);
                    return true;
                }
                if (!(tile.func_70301_a(4).func_190926_b() || world.field_72995_K || player.func_70093_af())) {
                    this.spitOutItems(world, pos, tile, 4);
                    return true;
                }
                player.func_184609_a(hand);
                return true;
            }
        }
        if ((fluidHandler = this.getFluidHandler((IBlockAccess)world, pos)) != null) {
            FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
            return FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null;
        }
        return false;
    }

    public void spitOutItems(World world, BlockPos pos, TileEntityWaterFilter tile, int slot) {
        ItemStack extracted = tile.func_70301_a(slot);
        EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, extracted);
        item.field_70179_y = 0.0;
        item.field_70181_x = 0.0;
        item.field_70159_w = 0.0;
        world.func_72838_d((Entity)item);
        tile.func_70299_a(slot, ItemStack.field_190927_a);
        tile.markForUpdate();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityWaterFilter tile = (TileEntityWaterFilter)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
            world.func_175713_t(pos);
        }
        super.func_180663_b(world, pos, state);
    }

    @Nullable
    private IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos) {
        TileEntityWaterFilter tileentity = (TileEntityWaterFilter)world.func_175625_s(pos);
        return (IFluidHandler)tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }
}

