/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.EnumBLDrinkableBrew;
import thebetweenlands.common.item.EnumBLDyeColor;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntitySteepingPot;

public class BlockSteepingPot
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool HANGING = PropertyBool.func_177716_a((String)"hanging");

    public BlockSteepingPot() {
        super(Material.field_151575_d);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HANGING});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySteepingPot();
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockFaceShape shape = worldIn.func_180495_p(pos.func_177984_a()).func_193401_d(worldIn, pos.func_177984_a(), EnumFacing.DOWN);
        return state.func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(shape != BlockFaceShape.BOWL && shape != BlockFaceShape.UNDEFINED || worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN, false)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntitySteepingPot tile = (TileEntitySteepingPot)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        IFluidHandler fluidHandler = this.getFluidHandler((IBlockAccess)world, pos);
        if (fluidHandler != null && FluidUtil.getFluidHandler((ItemStack)heldItem) != null) {
            FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
            return FluidUtil.getFluidHandler((ItemStack)heldItem) != null;
        }
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntitySteepingPot) {
            TileEntitySteepingPot tile = (TileEntitySteepingPot)world.func_175625_s(pos);
            if (tile.getHeatProgress() > 50 && tile.getHeatProgress() < 100 && tile.hasBundle()) {
                return false;
            }
            if (!player.func_70093_af() && !heldItem.func_190926_b() && heldItem.func_77973_b() == ItemRegistry.SILK_BUNDLE && tile.func_70301_a(0).func_190926_b()) {
                ItemStack ingredient = heldItem.func_77946_l();
                ingredient.func_190920_e(1);
                tile.func_70299_a(0, ingredient);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                tile.setHeatProgress(0);
                tile.hasCraftResult = false;
                if (tile.tank.getFluid() != null) {
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187806_ee, SoundCategory.BLOCKS, 0.75f, 2.0f);
                }
                world.func_184138_a(pos, state, state, 3);
                return true;
            }
            if (player.func_70093_af() && !tile.func_70301_a(0).func_190926_b()) {
                if (!player.field_71071_by.func_70441_a(tile.func_70301_a(0))) {
                    ForgeHooks.onPlayerTossEvent((EntityPlayer)player, (ItemStack)tile.func_70301_a(0), (boolean)false);
                }
                tile.func_70299_a(0, ItemStack.field_190927_a);
                tile.setHeatProgress(0);
                tile.hasCraftResult = false;
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 2.0f);
                world.func_184138_a(pos, state, state, 3);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos) {
        TileEntitySteepingPot tileentity = (TileEntitySteepingPot)world.func_175625_s(pos);
        return (IFluidHandler)tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (world.func_175625_s(pos) instanceof TileEntitySteepingPot) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            TileEntitySteepingPot pot = (TileEntitySteepingPot)world.func_175625_s(pos);
            if (pot.getTankFluidAmount() > 0 && pot.getHeatProgress() > 80) {
                int amount = pot.tank.getFluidAmount();
                int capacity = pot.tank.getCapacity();
                float size = 1.0f / (float)capacity * (float)amount;
                float xx = (float)x + 0.5f;
                float yy = (float)y + 0.35f + size * 0.25f;
                float zz = (float)z + 0.5f;
                int type = pot.tank.getFluid().getFluid().getColor();
                if (pot.tank.getFluid().tag != null && pot.tank.getFluid().tag.func_74764_b("type") && pot.tank.getFluid().getFluid() == FluidRegistry.DYE_FLUID) {
                    type = EnumBLDyeColor.byMetadata(pot.tank.getFluid().tag.func_74762_e("type")).getColorValue() | 0xFF000000;
                }
                if (pot.tank.getFluid().getFluid() == FluidRegistry.DRINKABLE_BREW) {
                    type = EnumBLDrinkableBrew.byMetadata(pot.tank.getFluid().tag.func_74762_e("type")).getColorValue() | 0xFF000000;
                }
                BLParticles.BUBBLE_INFUSION.spawn(world, xx + 0.3f - rand.nextFloat() * 0.6f, yy, zz + 0.3f - rand.nextFloat() * 0.6f, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withScale(0.3f)).withColor(type));
                if (pot.getHeatProgress() >= 100) {
                    for (int i = 0; i < 2 + rand.nextInt(3); ++i) {
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.SMOOTH_SMOKE.create(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.75f, (float)pos.func_177952_p() + 0.5f, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((rand.nextFloat() * 0.25f - 0.125f) * 0.09f, rand.nextFloat() * 0.02f + 0.01f, (rand.nextFloat() * 0.25f - 0.125f) * 0.09f)).withScale(1.0f + rand.nextFloat() * 2.0f)).withColor(type)).withData(80, true, Float.valueOf(0.01f), true)));
                    }
                }
            }
        }
    }
}

