/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityMothHouse;

public class BlockMothHouse
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ON_WALL = PropertyBool.func_177716_a((String)"on_wall");
    public static final AxisAlignedBB AABB_NS = new AxisAlignedBB(0.125, 0.0, 0.25, 0.875, 1.0, 0.75);
    public static final AxisAlignedBB AABB_EW = new AxisAlignedBB(0.25, 0.0, 0.125, 0.75, 1.0, 0.875);
    public static final AxisAlignedBB AABB_N_WALL = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 1.0, 0.375);
    public static final AxisAlignedBB AABB_S_WALL = new AxisAlignedBB(0.125, 0.0, 0.625, 0.875, 1.0, 1.0);
    public static final AxisAlignedBB AABB_E_WALL = new AxisAlignedBB(0.625, 0.0, 0.125, 1.0, 1.0, 0.875);
    public static final AxisAlignedBB AABB_W_WALL = new AxisAlignedBB(0.0, 0.0, 0.125, 0.375, 1.0, 0.875);

    public BlockMothHouse() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean onWall = (Boolean)state.func_177229_b((IProperty)ON_WALL);
        if (onWall) {
            switch (facing) {
                case NORTH: {
                    return AABB_N_WALL;
                }
                case EAST: {
                    return AABB_E_WALL;
                }
                case SOUTH: {
                    return AABB_S_WALL;
                }
                case WEST: {
                    return AABB_W_WALL;
                }
            }
        } else {
            switch (facing) {
                case NORTH: 
                case SOUTH: {
                    return AABB_NS;
                }
                case EAST: 
                case WEST: {
                    return AABB_EW;
                }
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (facing.func_176740_k() != EnumFacing.Axis.Y) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)ON_WALL, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)ON_WALL, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (super.func_176198_a(worldIn, pos, side)) {
            if (side.func_176740_k() == EnumFacing.Axis.Y) {
                BlockPos offsetPos = pos.func_177977_b();
                EnumFacing offsetFacing = EnumFacing.UP;
                BlockFaceShape shape = worldIn.func_180495_p(offsetPos).func_193401_d((IBlockAccess)worldIn, offsetPos, offsetFacing);
                return shape != BlockFaceShape.BOWL && shape != BlockFaceShape.UNDEFINED || worldIn.isSideSolid(offsetPos, offsetFacing);
            }
            BlockPos offsetPos = pos.func_177972_a(side.func_176734_d());
            EnumFacing offsetFacing = side;
            BlockFaceShape shape = worldIn.func_180495_p(offsetPos).func_193401_d((IBlockAccess)worldIn, offsetPos, offsetFacing);
            return shape == BlockFaceShape.SOLID || worldIn.isSideSolid(offsetPos, offsetFacing);
        }
        return false;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        boolean onWall = (Boolean)state.func_177229_b((IProperty)ON_WALL);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (onWall) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            BlockFaceShape shape = worldIn.func_180495_p(offsetPos).func_193401_d((IBlockAccess)worldIn, offsetPos, facing.func_176734_d());
            return shape == BlockFaceShape.SOLID || worldIn.isSideSolid(offsetPos, facing.func_176734_d());
        }
        BlockPos offsetPos = pos.func_177977_b();
        BlockFaceShape shape = worldIn.func_180495_p(offsetPos).func_193401_d((IBlockAccess)worldIn, offsetPos, EnumFacing.UP);
        return shape != BlockFaceShape.BOWL && shape != BlockFaceShape.UNDEFINED || worldIn.isSideSolid(offsetPos, EnumFacing.UP);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileEntityMothHouse) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityMothHouse)tile));
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityMothHouse) {
            TileEntityMothHouse tile = (TileEntityMothHouse)world.func_175625_s(pos);
            if (placer instanceof EntityPlayer) {
                tile.setPlacer((EntityPlayer)placer);
            }
            tile.markForUpdate();
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMothHouse();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ON_WALL});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)ON_WALL, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() & 3 | ((Boolean)state.func_177229_b((IProperty)ON_WALL) != false ? 4 : 0);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return (Boolean)state.func_177229_b((IProperty)ON_WALL) == false && face.func_176740_k() == EnumFacing.Axis.Y ? BlockFaceShape.MIDDLE_POLE_THICK : BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityMothHouse) {
            TileEntityMothHouse tile = (TileEntityMothHouse)world.func_175625_s(pos);
            if (tile == null) {
                return false;
            }
            if (heldItem.func_190926_b()) {
                this.extractItems(world, pos, state, player, hand, tile, false);
                if (player.func_70093_af()) {
                    this.extractItems(world, pos, state, player, hand, tile, true);
                }
                return true;
            }
            if (heldItem.func_77973_b() == ItemRegistry.SILK_GRUB) {
                int grubCount = tile.addGrubs(heldItem);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184586_b(hand).func_190918_g(grubCount);
                }
                tile.markForUpdate();
            }
        }
        return true;
    }

    protected void extractItems(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, TileEntityMothHouse tile, boolean grubs) {
        ItemStack itemStack = tile.func_70301_a(grubs ? 0 : 1);
        if (itemStack != ItemStack.field_190927_a) {
            player.func_191521_c(itemStack.func_77946_l());
            tile.func_70299_a(grubs ? 0 : 1, ItemStack.field_190927_a);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityMothHouse tile = (TileEntityMothHouse)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.func_70301_a(1).func_77946_l());
            tile.func_70299_a(1, ItemStack.field_190927_a);
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.func_70301_a(0).func_77946_l());
            tile.func_70299_a(0, ItemStack.field_190927_a);
            world.func_175713_t(pos);
        }
        super.func_180663_b(world, pos, state);
    }
}

