/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.EntityFishingTackleBoxSeat;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityFishingTackleBox;

public class BlockFishingTackleBox
extends BlockContainer
implements BlockRegistry.ICustomItemBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockFishingTackleBox() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176735_f());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176735_f()), 2);
        if (!world.field_72995_K && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Items")) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof TileEntityFishingTackleBox) {
                NBTTagList tags = stack.func_77978_p().func_150295_c("Items", 10);
                ((TileEntityFishingTackleBox)tileentity).inventory = NonNullList.func_191197_a((int)((TileEntityFishingTackleBox)tileentity).func_70302_i_(), (Object)ItemStack.field_190927_a);
                for (int i = 0; i < tags.func_74745_c(); ++i) {
                    NBTTagCompound data = tags.func_150305_b(i);
                    int j = data.func_74771_c("Slot") & 0xFF;
                    if (j < 0 || j >= ((TileEntityFishingTackleBox)tileentity).inventory.size()) continue;
                    ((TileEntityFishingTackleBox)tileentity).inventory.set(j, (Object)new ItemStack(data));
                }
            }
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFishingTackleBox();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityFishingTackleBox && !this.isBoxSatOn(world, pos)) {
            TileEntityFishingTackleBox tile = (TileEntityFishingTackleBox)world.func_175625_s(pos);
            if (!tile.isOpen()) {
                world.func_184133_a(null, pos, (SoundEvent)SoundRegistry.FISHING_TACKLE_BOX_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (tile.isOpen()) {
                world.func_184133_a(null, pos, (SoundEvent)SoundRegistry.FISHING_TACKLE_BOX_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            tile.setOpen(!tile.isOpen());
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
            tile.func_70296_d();
        }
    }

    private boolean isBoxSatOn(World world, BlockPos pos) {
        AxisAlignedBB detectionbox = new AxisAlignedBB(pos);
        List list = world.func_175647_a(EntityFishingTackleBoxSeat.class, detectionbox, EntitySelectors.field_94557_a);
        for (EntityFishingTackleBoxSeat entity : list) {
            if (list.isEmpty() || !(list.get(0) instanceof EntityFishingTackleBoxSeat)) continue;
            return true;
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityFishingTackleBox) {
            TileEntityFishingTackleBox tile = (TileEntityFishingTackleBox)world.func_175625_s(pos);
            if (!tile.isOpen() && !this.isBoxSatOn(world, pos) && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2)) && side == EnumFacing.UP) {
                tile.seatPlayer(player, pos);
            }
            if (tile.isOpen()) {
                player.openGui((Object)TheBetweenlands.instance, 30, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tileentity;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tileentity = world.func_175625_s(pos)) instanceof TileEntityFishingTackleBox) {
            NBTTagCompound nbt = new NBTTagCompound();
            tileentity.func_189515_b(nbt);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, 0);
            if (((TileEntityFishingTackleBox)tileentity).func_70302_i_() > 0) {
                stack.func_77982_d(nbt);
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            world.func_175713_t(pos);
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public ItemBlock getItemBlock() {
        ItemBlock FISHING_TACKLE_BOX_ITEM = new ItemBlock(BlockRegistry.FISHING_TACKLE_BOX){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
                if (stack.func_77942_o() && stack.func_77978_p().func_150295_c("Items", 10) != null) {
                    NBTTagList tags = stack.func_77978_p().func_150295_c("Items", 10);
                    for (int i = 0; i < tags.func_74745_c(); ++i) {
                        NBTTagCompound data = tags.func_150305_b(i);
                        int j = data.func_74771_c("Slot") & 0xFF;
                        if (i < 0 || i > 15) continue;
                        list.add("Slot " + (j + 1) + ": " + TextFormatting.GREEN + new ItemStack(data).func_82833_r() + " x " + new ItemStack(data).func_190916_E());
                    }
                }
            }
        };
        return FISHING_TACKLE_BOX_ITEM;
    }
}

