/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import thebetweenlands.common.block.BlockStateContainerHelper;
import thebetweenlands.common.block.property.PropertyIntegerUnlisted;

public interface IConnectedTextureBlock {
    public static final IUnlistedProperty<Integer> TOP_NORTH_WEST_INDEX = new PropertyIntegerUnlisted("top_north_west_index");
    public static final IUnlistedProperty<Integer> TOP_NORTH_EAST_INDEX = new PropertyIntegerUnlisted("top_north_east_index");
    public static final IUnlistedProperty<Integer> TOP_SOUTH_WEST_INDEX = new PropertyIntegerUnlisted("top_south_west_index");
    public static final IUnlistedProperty<Integer> TOP_SOUTH_EAST_INDEX = new PropertyIntegerUnlisted("top_south_east_index");
    public static final IUnlistedProperty<Integer> BOTTOM_NORTH_EAST_INDEX = new PropertyIntegerUnlisted("bottom_north_east_index");
    public static final IUnlistedProperty<Integer> BOTTOM_NORTH_WEST_INDEX = new PropertyIntegerUnlisted("bottom_north_west_index");
    public static final IUnlistedProperty<Integer> BOTTOM_SOUTH_EAST_INDEX = new PropertyIntegerUnlisted("bottom_south_east_index");
    public static final IUnlistedProperty<Integer> BOTTOM_SOUTH_WEST_INDEX = new PropertyIntegerUnlisted("bottom_south_west_index");
    public static final IUnlistedProperty<Integer> NORTH_UP_WEST_INDEX = new PropertyIntegerUnlisted("north_up_west_index");
    public static final IUnlistedProperty<Integer> NORTH_UP_EAST_INDEX = new PropertyIntegerUnlisted("north_up_east_index");
    public static final IUnlistedProperty<Integer> NORTH_DOWN_WEST_INDEX = new PropertyIntegerUnlisted("north_down_west_index");
    public static final IUnlistedProperty<Integer> NORTH_DOWN_EAST_INDEX = new PropertyIntegerUnlisted("north_down_east_index");
    public static final IUnlistedProperty<Integer> SOUTH_DOWN_WEST_INDEX = new PropertyIntegerUnlisted("south_down_west_index");
    public static final IUnlistedProperty<Integer> SOUTH_DOWN_EAST_INDEX = new PropertyIntegerUnlisted("south_down_east_index");
    public static final IUnlistedProperty<Integer> SOUTH_UP_WEST_INDEX = new PropertyIntegerUnlisted("south_up_west_index");
    public static final IUnlistedProperty<Integer> SOUTH_UP_EAST_INDEX = new PropertyIntegerUnlisted("south_up_east_index");
    public static final IUnlistedProperty<Integer> WEST_DOWN_NORTH_INDEX = new PropertyIntegerUnlisted("west_down_north_index");
    public static final IUnlistedProperty<Integer> WEST_DOWN_SOUTH_INDEX = new PropertyIntegerUnlisted("west_down_south_index");
    public static final IUnlistedProperty<Integer> WEST_UP_NORTH_INDEX = new PropertyIntegerUnlisted("west_up_north_index");
    public static final IUnlistedProperty<Integer> WEST_UP_SOUTH_INDEX = new PropertyIntegerUnlisted("west_up_south_index");
    public static final IUnlistedProperty<Integer> EAST_DOWN_SOUTH_INDEX = new PropertyIntegerUnlisted("east_down_south_index");
    public static final IUnlistedProperty<Integer> EAST_DOWN_NORTH_INDEX = new PropertyIntegerUnlisted("east_down_north_index");
    public static final IUnlistedProperty<Integer> EAST_UP_SOUTH_INDEX = new PropertyIntegerUnlisted("east_up_south_index");
    public static final IUnlistedProperty<Integer> EAST_UP_NORTH_INDEX = new PropertyIntegerUnlisted("east_up_north_index");

    default public ExtendedBlockState getConnectedTextureBlockStateContainer(ExtendedBlockState container) {
        ArrayList<IUnlistedProperty<Integer>> props = new ArrayList<IUnlistedProperty<Integer>>();
        if (this.isFaceConnectedTexture(EnumFacing.UP)) {
            props.add(TOP_NORTH_WEST_INDEX);
            props.add(TOP_NORTH_EAST_INDEX);
            props.add(TOP_SOUTH_WEST_INDEX);
            props.add(TOP_SOUTH_EAST_INDEX);
        }
        if (this.isFaceConnectedTexture(EnumFacing.DOWN)) {
            props.add(BOTTOM_NORTH_WEST_INDEX);
            props.add(BOTTOM_NORTH_EAST_INDEX);
            props.add(BOTTOM_SOUTH_WEST_INDEX);
            props.add(BOTTOM_SOUTH_EAST_INDEX);
        }
        if (this.isFaceConnectedTexture(EnumFacing.NORTH)) {
            props.add(NORTH_UP_WEST_INDEX);
            props.add(NORTH_UP_EAST_INDEX);
            props.add(NORTH_DOWN_WEST_INDEX);
            props.add(NORTH_DOWN_EAST_INDEX);
        }
        if (this.isFaceConnectedTexture(EnumFacing.SOUTH)) {
            props.add(SOUTH_UP_WEST_INDEX);
            props.add(SOUTH_UP_EAST_INDEX);
            props.add(SOUTH_DOWN_WEST_INDEX);
            props.add(SOUTH_DOWN_EAST_INDEX);
        }
        if (this.isFaceConnectedTexture(EnumFacing.WEST)) {
            props.add(WEST_UP_SOUTH_INDEX);
            props.add(WEST_UP_NORTH_INDEX);
            props.add(WEST_DOWN_SOUTH_INDEX);
            props.add(WEST_DOWN_NORTH_INDEX);
        }
        if (this.isFaceConnectedTexture(EnumFacing.EAST)) {
            props.add(EAST_UP_SOUTH_INDEX);
            props.add(EAST_UP_NORTH_INDEX);
            props.add(EAST_DOWN_SOUTH_INDEX);
            props.add(EAST_DOWN_NORTH_INDEX);
        }
        return BlockStateContainerHelper.extendBlockstateContainer(container, new IProperty[0], props.toArray(new IUnlistedProperty[0]));
    }

    default public boolean isFaceConnectedTexture(EnumFacing face) {
        return true;
    }

    default public IBlockState getExtendedConnectedTextureState(IExtendedBlockState state, IBlockAccess world, BlockPos pos, final Predicate<BlockPos> canConnectTo, final boolean connectToSelf) {
        IConnectionRules connectionRules = new IConnectionRules(){

            @Override
            public boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing face, BlockPos to) {
                return canConnectTo.apply((Object)to);
            }

            @Override
            public boolean canConnectThrough(IBlockAccess world, BlockPos pos, EnumFacing face, BlockPos to) {
                if (connectToSelf) {
                    return IConnectionRules.super.canConnectThrough(world, pos, face, to);
                }
                EnumFacing.Axis axis = face.func_176740_k();
                return axis == EnumFacing.Axis.X && to.func_177958_n() - pos.func_177958_n() != 0 || axis == EnumFacing.Axis.Y && to.func_177956_o() - pos.func_177956_o() != 0 || axis == EnumFacing.Axis.Z && to.func_177952_p() - pos.func_177952_p() != 0;
            }
        };
        return this.getExtendedConnectedTextureState(state, world, pos, connectionRules);
    }

    default public IBlockState getExtendedConnectedTextureState(IExtendedBlockState state, IBlockAccess world, BlockPos pos, IConnectionRules connectionRules) {
        world = connectionRules.getBlockAccessCache(world, pos);
        if (this.isFaceConnectedTexture(EnumFacing.UP)) {
            int[] quadrantIndicesUp = IConnectedTextureBlock.getQuadrantIndices(IConnectedTextureBlock.getConnectionArray(world, pos, EnumFacing.UP, connectionRules), false);
            state = state.withProperty(TOP_NORTH_WEST_INDEX, (Object)quadrantIndicesUp[0]);
            state = state.withProperty(TOP_NORTH_EAST_INDEX, (Object)quadrantIndicesUp[1]);
            state = state.withProperty(TOP_SOUTH_WEST_INDEX, (Object)quadrantIndicesUp[2]);
            state = state.withProperty(TOP_SOUTH_EAST_INDEX, (Object)quadrantIndicesUp[3]);
        }
        if (this.isFaceConnectedTexture(EnumFacing.DOWN)) {
            int[] quadrantIndicesDown = IConnectedTextureBlock.getQuadrantIndices(IConnectedTextureBlock.getConnectionArray(world, pos, EnumFacing.DOWN, connectionRules), true);
            state = state.withProperty(BOTTOM_NORTH_EAST_INDEX, (Object)quadrantIndicesDown[0]);
            state = state.withProperty(BOTTOM_NORTH_WEST_INDEX, (Object)quadrantIndicesDown[1]);
            state = state.withProperty(BOTTOM_SOUTH_EAST_INDEX, (Object)quadrantIndicesDown[2]);
            state = state.withProperty(BOTTOM_SOUTH_WEST_INDEX, (Object)quadrantIndicesDown[3]);
        }
        if (this.isFaceConnectedTexture(EnumFacing.NORTH)) {
            int[] quadrantIndicesNorth = IConnectedTextureBlock.getQuadrantIndices(IConnectedTextureBlock.getConnectionArray(world, pos, EnumFacing.NORTH, connectionRules), false);
            state = state.withProperty(NORTH_UP_WEST_INDEX, (Object)quadrantIndicesNorth[0]);
            state = state.withProperty(NORTH_UP_EAST_INDEX, (Object)quadrantIndicesNorth[1]);
            state = state.withProperty(NORTH_DOWN_WEST_INDEX, (Object)quadrantIndicesNorth[2]);
            state = state.withProperty(NORTH_DOWN_EAST_INDEX, (Object)quadrantIndicesNorth[3]);
        }
        if (this.isFaceConnectedTexture(EnumFacing.SOUTH)) {
            int[] quadrantIndicesSouth = IConnectedTextureBlock.getQuadrantIndices(IConnectedTextureBlock.getConnectionArray(world, pos, EnumFacing.SOUTH, connectionRules), false);
            state = state.withProperty(SOUTH_DOWN_WEST_INDEX, (Object)quadrantIndicesSouth[0]);
            state = state.withProperty(SOUTH_DOWN_EAST_INDEX, (Object)quadrantIndicesSouth[1]);
            state = state.withProperty(SOUTH_UP_WEST_INDEX, (Object)quadrantIndicesSouth[2]);
            state = state.withProperty(SOUTH_UP_EAST_INDEX, (Object)quadrantIndicesSouth[3]);
        }
        if (this.isFaceConnectedTexture(EnumFacing.WEST)) {
            int[] quadrantIndicesWest = IConnectedTextureBlock.getQuadrantIndices(IConnectedTextureBlock.getConnectionArray(world, pos, EnumFacing.WEST, connectionRules), true);
            state = state.withProperty(WEST_DOWN_NORTH_INDEX, (Object)quadrantIndicesWest[0]);
            state = state.withProperty(WEST_UP_NORTH_INDEX, (Object)quadrantIndicesWest[1]);
            state = state.withProperty(WEST_DOWN_SOUTH_INDEX, (Object)quadrantIndicesWest[2]);
            state = state.withProperty(WEST_UP_SOUTH_INDEX, (Object)quadrantIndicesWest[3]);
        }
        if (this.isFaceConnectedTexture(EnumFacing.EAST)) {
            int[] quadrantIndicesEast = IConnectedTextureBlock.getQuadrantIndices(IConnectedTextureBlock.getConnectionArray(world, pos, EnumFacing.EAST, connectionRules), true);
            state = state.withProperty(EAST_UP_NORTH_INDEX, (Object)quadrantIndicesEast[0]);
            state = state.withProperty(EAST_DOWN_NORTH_INDEX, (Object)quadrantIndicesEast[1]);
            state = state.withProperty(EAST_UP_SOUTH_INDEX, (Object)quadrantIndicesEast[2]);
            state = state.withProperty(EAST_DOWN_SOUTH_INDEX, (Object)quadrantIndicesEast[3]);
        }
        return state;
    }

    public static int[] getQuadrantIndices(boolean[] connectionArray, boolean flipXZ) {
        int tls = 0;
        int trs = 0;
        int bls = 0;
        int brs = 0;
        for (int xo = 0; xo <= 2; ++xo) {
            for (int zo = 0; zo <= 2; ++zo) {
                boolean currentNeighbourState = connectionArray[IConnectedTextureBlock.getIndex(xo, zo, 3)];
                int segXPath = 1;
                int segZPath = 2;
                if (flipXZ) {
                    segXPath = 2;
                    segZPath = 1;
                }
                if (xo != 1 && zo == 1 || xo == 1 && zo != 1) {
                    if (!currentNeighbourState) continue;
                    if (xo == 0) {
                        if (!connectionArray[IConnectedTextureBlock.getIndex(1, 2, 3)]) {
                            bls = segXPath;
                        }
                        if (connectionArray[IConnectedTextureBlock.getIndex(1, 0, 3)]) continue;
                        tls = segXPath;
                        continue;
                    }
                    if (xo == 2) {
                        if (!connectionArray[IConnectedTextureBlock.getIndex(1, 2, 3)]) {
                            brs = segXPath;
                        }
                        if (connectionArray[IConnectedTextureBlock.getIndex(1, 0, 3)]) continue;
                        trs = segXPath;
                        continue;
                    }
                    if (zo == 0) {
                        if (!connectionArray[IConnectedTextureBlock.getIndex(0, 1, 3)]) {
                            tls = segZPath;
                        }
                        if (connectionArray[IConnectedTextureBlock.getIndex(2, 1, 3)]) continue;
                        trs = segZPath;
                        continue;
                    }
                    if (zo != 2) continue;
                    if (!connectionArray[IConnectedTextureBlock.getIndex(0, 1, 3)]) {
                        bls = segZPath;
                    }
                    if (connectionArray[IConnectedTextureBlock.getIndex(2, 1, 3)]) continue;
                    brs = segZPath;
                    continue;
                }
                if (xo == 1 || zo == 1 || !connectionArray[IConnectedTextureBlock.getIndex(xo, 1, 3)] || !connectionArray[IConnectedTextureBlock.getIndex(1, zo, 3)]) continue;
                int segment = currentNeighbourState ? 3 : 4;
                if (xo == 2 && zo == 0) {
                    trs = segment;
                    continue;
                }
                if (xo == 2 && zo == 2) {
                    brs = segment;
                    continue;
                }
                if (xo == 0 && zo == 2) {
                    bls = segment;
                    continue;
                }
                tls = segment;
            }
        }
        return new int[]{tls, trs, bls, brs};
    }

    public static boolean[] getConnectionArray(IBlockAccess world, BlockPos pos, EnumFacing dir, IConnectionRules connectionRules) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean xp = true;
        boolean yp = true;
        boolean xr = false;
        boolean yr = false;
        boolean zr = false;
        boolean[] connectionArray = new boolean[9];
        switch (dir) {
            case DOWN: {
                xp = false;
            }
            case UP: {
                xr = true;
                zr = true;
                break;
            }
            case NORTH: {
                yp = false;
            }
            case SOUTH: {
                xr = true;
                yr = true;
                break;
            }
            case EAST: {
                xp = false;
            }
            case WEST: {
                zr = true;
                yr = true;
                break;
            }
            default: {
                return connectionArray;
            }
        }
        BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int xo = xr ? -1 : 0; xo <= (xr ? 1 : 0); ++xo) {
            for (int yo = yr ? -1 : 0; yo <= (yr ? 1 : 0); ++yo) {
                for (int zo = zr ? -1 : 0; zo <= (zr ? 1 : 0); ++zo) {
                    BlockPos.PooledMutableBlockPos diagPos;
                    boolean isDiagConnectable;
                    EnumFacing.Axis axis;
                    int mx = (xr ? xo : yo) + 1;
                    int my = (zr ? zo : (xr ? yo : zo)) + 1;
                    int blockIndex = IConnectedTextureBlock.getIndex(xp ? mx : 2 - mx, yp ? my : 2 - my, 3);
                    if (!connectionRules.canConnectThrough(world, pos, dir, (BlockPos)checkPos.func_181079_c(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e())) || ((axis = dir.func_176740_k()) != EnumFacing.Axis.X || yo == 0 && zo == 0) && (axis != EnumFacing.Axis.Y || xo == 0 && zo == 0) && (axis != EnumFacing.Axis.Z || xo == 0 && yo == 0) || !(isDiagConnectable = connectionRules.canConnectTo(world, pos, dir, (BlockPos)(diagPos = checkPos.func_181079_c(axis == EnumFacing.Axis.X ? x + dir.func_82601_c() : x + xo, axis == EnumFacing.Axis.Y ? y + dir.func_96559_d() : y + yo, axis == EnumFacing.Axis.Z ? z + dir.func_82599_e() : z + zo)))) && !connectionRules.canConnectThrough(world, pos, dir, (BlockPos)diagPos)) continue;
                    BlockPos.PooledMutableBlockPos obstructionPos = checkPos.func_181079_c(axis == EnumFacing.Axis.X ? x : x + xo, axis == EnumFacing.Axis.Y ? y : y + yo, axis == EnumFacing.Axis.Z ? z : z + zo);
                    connectionArray[blockIndex] = isDiagConnectable || connectionRules.canConnectThrough(world, pos, dir, (BlockPos)obstructionPos) ? true : connectionRules.canConnectTo(world, pos, dir, (BlockPos)checkPos.func_181079_c(x + xo, y + yo, z + zo));
                }
            }
        }
        checkPos.func_185344_t();
        return connectionArray;
    }

    public static int getIndex(int x, int y, int width) {
        return x % width + y * width;
    }

    public static interface IConnectionRules {
        default public IBlockAccess getBlockAccessCache(IBlockAccess world, BlockPos pos) {
            return world;
        }

        public boolean canConnectTo(IBlockAccess var1, BlockPos var2, EnumFacing var3, BlockPos var4);

        default public boolean canConnectThrough(IBlockAccess world, BlockPos pos, EnumFacing face, BlockPos to) {
            boolean onSamePlane;
            EnumFacing.Axis axis = face.func_176740_k();
            BlockPos planeOffset = new BlockPos(axis == EnumFacing.Axis.X ? 0 : to.func_177958_n() - pos.func_177958_n(), axis == EnumFacing.Axis.Y ? 0 : to.func_177956_o() - pos.func_177956_o(), axis == EnumFacing.Axis.Z ? 0 : to.func_177952_p() - pos.func_177952_p());
            boolean bl = onSamePlane = !(axis == EnumFacing.Axis.X && to.func_177958_n() - pos.func_177958_n() != 0 || axis == EnumFacing.Axis.Y && to.func_177956_o() - pos.func_177956_o() != 0 || axis == EnumFacing.Axis.Z && to.func_177952_p() - pos.func_177952_p() != 0);
            if (Math.abs(planeOffset.func_177958_n()) + Math.abs(planeOffset.func_177956_o()) + Math.abs(planeOffset.func_177952_p()) > 1) {
                BlockPos.MutableBlockPos directNeighbour = new BlockPos.MutableBlockPos();
                for (EnumFacing offsetFace : EnumFacing.field_82609_l) {
                    if (Math.abs(planeOffset.func_177958_n() + offsetFace.func_82601_c()) + Math.abs(planeOffset.func_177956_o() + offsetFace.func_96559_d()) + Math.abs(planeOffset.func_177952_p() + offsetFace.func_82599_e()) != 1) continue;
                    if (onSamePlane ? world.isSideSolid(to, offsetFace, false) || world.isSideSolid(to, face, false) : world.isSideSolid(to, offsetFace, false) || world.isSideSolid(to, face.func_176734_d(), false)) {
                        return false;
                    }
                    directNeighbour.func_181079_c(to.func_177958_n() + offsetFace.func_82601_c(), to.func_177956_o() + offsetFace.func_96559_d(), to.func_177952_p() + offsetFace.func_82599_e());
                    if (this.canConnectTo(world, pos, face, (BlockPos)directNeighbour) || !(onSamePlane ? world.isSideSolid((BlockPos)directNeighbour, offsetFace.func_176734_d(), false) || world.isSideSolid((BlockPos)directNeighbour, face, false) : world.isSideSolid((BlockPos)directNeighbour, offsetFace.func_176734_d(), false) || world.isSideSolid((BlockPos)directNeighbour, face.func_176734_d(), false))) continue;
                    return false;
                }
                return true;
            }
            EnumFacing offsetDir = EnumFacing.func_176737_a((float)planeOffset.func_177958_n(), (float)planeOffset.func_177956_o(), (float)planeOffset.func_177952_p());
            if (onSamePlane) {
                return !world.isSideSolid(to, offsetDir.func_176734_d(), false) && !world.isSideSolid(to, face, false);
            }
            return !world.isSideSolid(to, offsetDir.func_176734_d(), false) && !world.isSideSolid(to, face.func_176734_d(), false);
        }
    }
}

