/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.SplittableRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.tile.TileEntityWaterFilter;

@SideOnly(value=Side.CLIENT)
public class RenderWaterFilter
extends TileEntitySpecialRenderer<TileEntityWaterFilter> {
    public void render(TileEntityWaterFilter tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        int i;
        ItemStack stack;
        if (tile == null || !tile.func_145830_o()) {
            return;
        }
        float fluidLevel = tile.tank.getFluidAmount();
        float height = 0.375f;
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        SplittableRandom rand = new SplittableRandom(tile.func_174877_v().func_177958_n() + tile.func_174877_v().func_177956_o() + tile.func_174877_v().func_177952_p());
        float yMin = 0.0f;
        if (fluidLevel > 0.0f) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            FluidStack fluidStack = tile.tank.getFluid();
            height = 0.4375f / (float)tile.tank.getCapacity() * (float)tile.tank.getFluidAmount();
            TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill().toString());
            int fluidColor = fluidStack.getFluid().getColor(fluidStack);
            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179137_b((double)x, (double)(y + 0.5), (double)z);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float xMax = 1.75f;
            float zMax = 1.75f;
            float xMin = 0.25f;
            float zMin = 0.25f;
            yMin = 0.0f;
            this.setGLColorFromInt(fluidColor, 1.0f);
            this.renderCuboid(buffer, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite);
            tessellator.func_78381_a();
            if (tile.getFluidAnimation()) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                GlStateManager.func_179109_b((float)0.0f, (float)-0.1875f, (float)0.0f);
                this.renderCuboid(buffer, 1.0625f, 0.9375f, -0.125f, 0.25f, 0.9375f, 1.0625f, fluidStillSprite);
                if (tile.hasMossFilter() || tile.hasSilkFilter()) {
                    this.renderCuboid(buffer, 1.375f, 0.625f, 0.0f, 0.00625f, 0.625f, 1.375f, fluidStillSprite);
                }
                tessellator.func_78381_a();
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
        }
        if (!tile.func_70301_a(0).func_190926_b()) {
            GlStateManager.func_179094_E();
            double yUp = 0.28125;
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + yUp), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)1.0, (double)0.5);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            ItemStack stack2 = tile.func_70301_a(0);
            renderItem.func_181564_a(stack2, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
        if (!tile.func_70301_a(1).func_190926_b()) {
            stack = tile.func_70301_a(1);
            double yUp = 0.3125;
            int items = tile.func_70301_a(1).func_190916_E() / 4 + 1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + yUp), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            for (i = 0; i < items; ++i) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(rand.nextDouble() * 0.25 - 0.125), (double)0.0, (double)(rand.nextDouble() * 0.25 - 0.125));
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 30.0f - 15.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 30.0f - 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)0.125, (double)0.125, (double)0.125);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
        if (!tile.func_70301_a(2).func_190926_b()) {
            stack = tile.func_70301_a(2);
            double yUp = 0.3125;
            int items = tile.func_70301_a(2).func_190916_E() / 4 + 1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + yUp), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            for (i = 0; i < items; ++i) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(rand.nextDouble() * 0.25 - 0.125), (double)0.0, (double)(rand.nextDouble() * 0.25 - 0.125));
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 30.0f - 15.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 30.0f - 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)0.125, (double)0.125, (double)0.125);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
        if (!tile.func_70301_a(3).func_190926_b()) {
            stack = tile.func_70301_a(3);
            double yUp = 0.3125;
            int items = tile.func_70301_a(3).func_190916_E() / 4 + 1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + yUp), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            for (i = 0; i < items; ++i) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(rand.nextDouble() * 0.25 - 0.125), (double)0.0, (double)(rand.nextDouble() * 0.25 - 0.125));
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 30.0f - 15.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 30.0f - 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)0.125, (double)0.125, (double)0.125);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
        if (!tile.func_70301_a(4).func_190926_b()) {
            stack = tile.func_70301_a(4);
            double yUp = 0.3125;
            int items = tile.func_70301_a(4).func_190916_E() / 4 + 1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + yUp), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            for (i = 0; i < items; ++i) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(rand.nextDouble() * 0.25 - 0.125), (double)0.0, (double)(rand.nextDouble() * 0.25 - 0.125));
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 30.0f - 15.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 30.0f - 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)0.125, (double)0.125, (double)0.125);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    private void setGLColorFromInt(int color, float alpha) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    private void renderCuboid(BufferBuilder buffer, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite) {
        double uMin = textureAtlasSprite.func_94209_e();
        double uMax = textureAtlasSprite.func_94212_f();
        double vMin = textureAtlasSprite.func_94206_g();
        double vMax = textureAtlasSprite.func_94210_h();
        double vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMax);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMax);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMax, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMax, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMax, vMin);
    }

    private void addVertexWithUV(BufferBuilder buffer, float x, float y, float z, double u, double v) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_187315_a(u, v).func_181675_d();
    }
}

