/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.render.model.tile.ModelMothHouse;
import thebetweenlands.common.block.container.BlockMothHouse;
import thebetweenlands.common.tile.TileEntityMothHouse;
import thebetweenlands.util.StatePropertyHelper;

public class RenderMothHouse
extends TileEntitySpecialRenderer<TileEntityMothHouse> {
    public static final ModelMothHouse MODEL = new ModelMothHouse();
    public static ResourceLocation TEXTURE_STAGE_0 = new ResourceLocation("thebetweenlands:textures/tiles/mothhouse_0.png");
    public static ResourceLocation TEXTURE_STAGE_1 = new ResourceLocation("thebetweenlands:textures/tiles/mothhouse_1.png");
    public static ResourceLocation TEXTURE_STAGE_2 = new ResourceLocation("thebetweenlands:textures/tiles/mothhouse_2.png");
    public static ResourceLocation TEXTURE_STAGE_3 = new ResourceLocation("thebetweenlands:textures/tiles/mothhouse_3.png");

    public void render(TileEntityMothHouse te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        ItemStack grubs;
        EnumFacing rotation = StatePropertyHelper.getStatePropertySafely(te, BlockMothHouse.class, BlockMothHouse.FACING, EnumFacing.NORTH);
        int silkRenderStage = 0;
        if (te != null) {
            silkRenderStage = te.getSilkRenderStage();
        }
        silkRenderStage = Math.max(0, Math.min(silkRenderStage, 3));
        switch (silkRenderStage) {
            case 0: {
                this.func_147499_a(TEXTURE_STAGE_0);
                break;
            }
            case 1: {
                this.func_147499_a(TEXTURE_STAGE_1);
                break;
            }
            case 2: {
                this.func_147499_a(TEXTURE_STAGE_2);
                break;
            }
            case 3: {
                this.func_147499_a(TEXTURE_STAGE_3);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        switch (rotation) {
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        boolean onWall = StatePropertyHelper.getStatePropertySafely(te, BlockMothHouse.class, BlockMothHouse.ON_WALL, false);
        if (onWall) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.38f);
        }
        MODEL.render();
        if (te != null && !te.isSilkProductionFinished() && x * x + y * y + z * z < 256.0 && !(grubs = te.func_70301_a(0)).func_190926_b()) {
            this.renderGrubs(grubs);
        }
        GlStateManager.func_179121_F();
    }

    private void renderGrubs(ItemStack stack) {
        if (stack.func_190916_E() > 0) {
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            switch (stack.func_190916_E()) {
                default: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)0.15, (double)0.15, (double)0.15);
                    GlStateManager.func_179137_b((double)0.5, (double)5.8, (double)0.4);
                    GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                    GlStateManager.func_179121_F();
                }
                case 5: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)0.15, (double)0.15, (double)0.15);
                    GlStateManager.func_179137_b((double)-0.5, (double)6.2, (double)0.4);
                    GlStateManager.func_179114_b((float)-80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                    GlStateManager.func_179121_F();
                }
                case 4: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)0.15, (double)0.15, (double)0.15);
                    GlStateManager.func_179137_b((double)1.1, (double)6.8, (double)0.4);
                    GlStateManager.func_179114_b((float)-8.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                    GlStateManager.func_179121_F();
                }
                case 3: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)0.15, (double)0.15, (double)0.15);
                    GlStateManager.func_179137_b((double)0.3, (double)8.6, (double)0.4);
                    GlStateManager.func_179114_b((float)-75.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                    GlStateManager.func_179121_F();
                }
                case 2: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)0.15, (double)0.15, (double)0.15);
                    GlStateManager.func_179137_b((double)-1.0, (double)8.0, (double)0.4);
                    GlStateManager.func_179114_b((float)5.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                    GlStateManager.func_179121_F();
                }
                case 1: 
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.15, (double)0.15, (double)0.15);
            GlStateManager.func_179137_b((double)0.5, (double)7.5, (double)0.4);
            GlStateManager.func_179114_b((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }
}

