/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.SplittableRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.armor.ModelSpiritTreeFaceMaskSmall;
import thebetweenlands.common.tile.TileEntityGrubHub;

@SideOnly(value=Side.CLIENT)
public class RenderGrubHub
extends TileEntitySpecialRenderer<TileEntityGrubHub> {
    private static final ModelSpiritTreeFaceMaskSmall maskModel = new ModelSpiritTreeFaceMaskSmall(false);
    private static final ResourceLocation TEXTURE_SMALL = new ResourceLocation("thebetweenlands", "textures/entity/spirit_tree_face_small.png");
    private static final ResourceLocation TEXTURE_EYES = new ResourceLocation("thebetweenlands", "textures/entity/spirit_tree_face_small_glow.png");

    public void render(TileEntityGrubHub tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        float fluidLevel = tile.tank.getFluidAmount();
        float height = 0.0625f;
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        SplittableRandom rand = new SplittableRandom(tile.func_174877_v().func_177958_n() + tile.func_174877_v().func_177956_o() + tile.func_174877_v().func_177952_p());
        GlStateManager.func_179094_E();
        this.func_147499_a(TEXTURE_SMALL);
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z - 0.4375));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        RenderGrubHub.maskModel.head_base.field_78797_d = 16.5f;
        RenderGrubHub.maskModel.head_base.field_78798_e = 8.0f;
        RenderGrubHub.maskModel.head_base.func_78785_a(0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.func_147499_a(TEXTURE_SMALL);
        GlStateManager.func_179137_b((double)(x - 0.4375), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        RenderGrubHub.maskModel.head_base.field_78797_d = 16.5f;
        RenderGrubHub.maskModel.head_base.field_78798_e = 8.0f;
        RenderGrubHub.maskModel.head_base.func_78785_a(0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.func_147499_a(TEXTURE_SMALL);
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 1.4375));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        RenderGrubHub.maskModel.head_base.field_78797_d = 16.5f;
        RenderGrubHub.maskModel.head_base.field_78798_e = 8.0f;
        RenderGrubHub.maskModel.head_base.func_78785_a(0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.func_147499_a(TEXTURE_SMALL);
        GlStateManager.func_179137_b((double)(x + 1.4375), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        RenderGrubHub.maskModel.head_base.field_78797_d = 16.5f;
        RenderGrubHub.maskModel.head_base.field_78798_e = 8.0f;
        RenderGrubHub.maskModel.head_base.func_78785_a(0.0625f);
        GlStateManager.func_179121_F();
        if (tile.switchTextureCount > 0) {
            GlStateManager.func_179094_E();
            this.func_147499_a(TEXTURE_EYES);
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z - 0.4375));
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            RenderGrubHub.maskModel.head_base.field_78797_d = 16.5f;
            RenderGrubHub.maskModel.head_base.field_78798_e = 8.0f;
            RenderGrubHub.maskModel.head_base.func_78785_a(0.0625f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            this.func_147499_a(TEXTURE_EYES);
            GlStateManager.func_179137_b((double)(x - 0.4375), (double)(y + 1.5), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            RenderGrubHub.maskModel.head_base.field_78797_d = 16.5f;
            RenderGrubHub.maskModel.head_base.field_78798_e = 8.0f;
            RenderGrubHub.maskModel.head_base.func_78785_a(0.0625f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            this.func_147499_a(TEXTURE_EYES);
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 1.4375));
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            RenderGrubHub.maskModel.head_base.field_78797_d = 16.5f;
            RenderGrubHub.maskModel.head_base.field_78798_e = 8.0f;
            RenderGrubHub.maskModel.head_base.func_78785_a(0.0625f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            this.func_147499_a(TEXTURE_EYES);
            GlStateManager.func_179137_b((double)(x + 1.4375), (double)(y + 1.5), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            RenderGrubHub.maskModel.head_base.field_78797_d = 16.5f;
            RenderGrubHub.maskModel.head_base.field_78798_e = 8.0f;
            RenderGrubHub.maskModel.head_base.func_78785_a(0.0625f);
            GlStateManager.func_179121_F();
        }
        if (tile != null) {
            if (fluidLevel > 0.0f) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                FluidStack fluidStack = tile.tank.getFluid();
                height = 0.68749f / (float)tile.tank.getCapacity() * (float)tile.tank.getFluidAmount();
                TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill().toString());
                int fluidColor = fluidStack.getFluid().getColor(fluidStack);
                GlStateManager.func_179140_f();
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_147499_a(TextureMap.field_110575_b);
                GlStateManager.func_179137_b((double)x, (double)(y + 0.0625), (double)z);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                float yMin = 0.0f;
                float xMax = 1.75f;
                float zMax = 1.75f;
                float xMin = 0.25f;
                float zMin = 0.25f;
                yMin = 0.0f;
                this.setGLColorFromInt(fluidColor, 1.0f);
                this.renderCuboid(buffer, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite);
                tessellator.func_78381_a();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
            }
            if (!tile.func_70301_a(0).func_190926_b()) {
                GlStateManager.func_179094_E();
                double yUp = 0.8125;
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + yUp), (double)(z + 0.5));
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                int items = tile.func_70301_a(0).func_190916_E();
                for (int i = 0; i < items; ++i) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(rand.nextDouble() / 2.0 - 0.25), (double)0.0, (double)(rand.nextDouble() / 2.0 - 0.25));
                    GlStateManager.func_179114_b((float)((float)rand.nextDouble() * 360.0f - 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    ItemStack stack = tile.func_70301_a(0);
                    renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    private void setGLColorFromInt(int color, float alpha) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    private void renderCuboid(BufferBuilder buffer, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite) {
        double uMin = textureAtlasSprite.func_94209_e();
        double uMax = textureAtlasSprite.func_94212_f();
        double vMin = textureAtlasSprite.func_94206_g();
        double vMax = textureAtlasSprite.func_94210_h();
        double vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMax);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMax);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMax, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMax, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMin, vMax);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMax, vMax);
    }

    private void addVertexWithUV(BufferBuilder buffer, float x, float y, float z, double u, double v) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_187315_a(u, v).func_181675_d();
    }
}

