/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.SplittableRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.client.render.model.tile.ModelFishTrimmingTable;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.item.misc.ItemMobAnadia;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityFishTrimmingTable;

public class RenderFishTrimmingTable
extends TileEntitySpecialRenderer<TileEntityFishTrimmingTable> {
    public static final ResourceLocation TEXTURE_BASE = new ResourceLocation("thebetweenlands:textures/tiles/fish_trimming_table.png");
    public static final ResourceLocation TEXTURE_USED = new ResourceLocation("thebetweenlands:textures/tiles/fish_trimming_table_used.png");
    public static final ModelFishTrimmingTable MODEL = new ModelFishTrimmingTable();

    public void render(TileEntityFishTrimmingTable te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int meta = te != null ? te.func_145832_p() : 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)(RenderFishTrimmingTable.getRotation(meta) - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        this.func_147499_a(TEXTURE_BASE);
        if (te != null) {
            if (!te.func_70301_a(4).func_190926_b()) {
                this.func_147499_a(TEXTURE_USED);
            }
            if (!te.func_70301_a(5).func_190926_b()) {
                MODEL.renderParts(te);
            }
        }
        MODEL.render();
        GlStateManager.func_179121_F();
        if (te != null) {
            SplittableRandom rand = new SplittableRandom(te.func_174877_v().func_177958_n() + te.func_174877_v().func_177956_o() + te.func_174877_v().func_177952_p());
            if (!te.func_70301_a(0).func_190926_b()) {
                if (this.shouldRenderAsEntity(te, 0) && te.getInputEntity() != null) {
                    this.renderAnadiaInSlot(te.func_70301_a(0), te.getInputEntity(), 0.0f, 0.8f, 0.0f, 1.0f);
                } else {
                    this.renderItemInSlot(te.func_70301_a(0), 0.0f, 0.75f, 0.0f, 0.5f, 0.0f);
                }
            }
            if (!te.func_70301_a(1).func_190926_b()) {
                this.renderItemInSlot(te.func_70301_a(1), -0.25f, 0.75f, 0.0f, 0.25f, (float)rand.nextDouble() * 60.0f - 30.0f);
            }
            if (!te.func_70301_a(2).func_190926_b()) {
                this.renderItemInSlot(te.func_70301_a(2), 0.0f, 0.75f, -0.125f, 0.25f, (float)rand.nextDouble() * 60.0f - 30.0f);
            }
            if (!te.func_70301_a(3).func_190926_b()) {
                this.renderItemInSlot(te.func_70301_a(3), 0.25f, 0.75f, 0.0f, 0.25f, (float)rand.nextDouble() * 60.0f - 30.0f);
            }
            if (!te.func_70301_a(4).func_190926_b()) {
                this.renderItemInSlot(te.func_70301_a(4), -0.25f, 0.75f, 0.25f, 0.25f, (float)rand.nextDouble() * 60.0f - 30.0f);
            }
        }
        GlStateManager.func_179121_F();
    }

    public boolean shouldRenderAsEntity(TileEntityFishTrimmingTable te, int slot) {
        if (te.func_70301_a(slot).func_77973_b() == ItemRegistry.ANADIA && ((ItemMob)te.func_70301_a(slot).func_77973_b()).hasEntityData(te.func_70301_a(slot))) {
            return true;
        }
        return te.func_70301_a(slot).func_77973_b() == ItemRegistry.SILT_CRAB || te.func_70301_a(slot).func_77973_b() == ItemRegistry.BUBBLER_CRAB;
    }

    public void renderAnadiaInSlot(ItemStack stack, Entity entity, float x, float y, float z, float scale) {
        if (entity != null) {
            if (stack.func_77973_b() instanceof ItemMobAnadia && ((ItemMobAnadia)stack.func_77973_b()).isRotten((World)Minecraft.func_71410_x().field_71441_e, stack)) {
                ((EntityAnadia)entity).setFishColour(EntityAnadia.EnumAnadiaColor.ROTTEN);
            }
            entity.field_70125_A = 0.0f;
            entity.field_70127_C = 0.0f;
            entity.field_70177_z = 0.0f;
            entity.field_70126_B = 0.0f;
            float scale2 = 1.0f / entity.field_70130_N * 0.5f;
            if (stack.func_77973_b() instanceof ItemMobAnadia) {
                scale2 = 1.0f / ((EntityAnadia)entity).getFishSize() * 0.5f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (stack.func_77973_b() instanceof ItemMobAnadia) {
                GlStateManager.func_179109_b((float)0.1875f, (float)0.0f, (float)-0.0625f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179152_a((float)scale2, (float)scale2, (float)scale2);
            Render renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity);
            renderer.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GlStateManager.func_179121_F();
        }
    }

    public void renderItemInSlot(ItemStack stack, float x, float y, float z, float scale, float rotate) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            if (stack.func_77973_b() != ItemRegistry.BONE_AXE) {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotate, (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-70.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.func_147499_a(TextureMap.field_110575_b);
            ITextureObject tex = Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b);
            tex.func_174936_b(false, false);
            RenderHelper.func_74518_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, (World)null, (EntityLivingBase)null));
            RenderHelper.func_74519_b();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            this.func_147499_a(TextureMap.field_110575_b);
            tex.func_174935_a();
        }
    }

    public static float getRotation(int meta) {
        switch (meta) {
            case 5: {
                return 180.0f;
            }
            default: {
                return 0.0f;
            }
            case 3: {
                return 90.0f;
            }
            case 2: 
        }
        return -90.0f;
    }
}

